/*
 * Decompiled with CFR 0.152.
 */
package org.shoal.adapter.store.commands;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.shoal.adapter.store.commands.AcknowledgedCommand;
import org.shoal.ha.cache.api.DataStoreException;
import org.shoal.ha.cache.impl.store.DataStoreEntry;

public class SaveCommand<K, V>
extends AcknowledgedCommand<K, V> {
    private static final transient Logger _logger = Logger.getLogger("org.shoal.ha.cache.command.save");
    private transient V v;
    protected long version;
    protected long lastAccessedAt;
    protected long maxIdleTime;
    private transient String targetInstanceName;
    private transient byte[] rawV;

    public SaveCommand() {
        super((byte)33);
    }

    public SaveCommand(K k, V v, long version, long lastAccessedAt, long maxIdleTime) {
        this();
        super.setKey(k);
        this.v = v;
        this.version = version;
        this.lastAccessedAt = lastAccessedAt;
        this.maxIdleTime = maxIdleTime;
    }

    @Override
    public boolean beforeTransmit() {
        this.targetInstanceName = this.dsc.getKeyMapper().getMappedInstance(this.dsc.getGroupName(), this.getKey());
        super.setTargetName(this.targetInstanceName);
        super.beforeTransmit();
        return this.getTargetName() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(String initiator) throws DataStoreException {
        DataStoreEntry entry;
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, this.dsc.getServiceName() + this.getName() + " received save_command for key = " + this.getKey() + " from " + initiator);
        }
        DataStoreEntry dataStoreEntry = entry = this.dsc.getReplicaStore().getOrCreateEntry(this.getKey());
        synchronized (dataStoreEntry) {
            this.dsc.getDataStoreEntryUpdater().executeSave(entry, this);
        }
        if (this.dsc.isDoSynchronousReplication()) {
            _logger.log(Level.WARNING, "SaveCommand Sending SIMPLE_ACK");
            super.sendAcknowledgement();
        }
        this.dsc.getDataStoreMBean().incrementExecutedSaveCount();
    }

    @Override
    public String toString() {
        return this.getName() + "(" + this.getKey() + ")";
    }

    @Override
    public String getKeyMappingInfo() {
        return this.targetInstanceName;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeLong(this.version);
        out.writeLong(this.lastAccessedAt);
        out.writeLong(this.maxIdleTime);
        this.rawV = this.dsc.getDataStoreEntryUpdater().getState(this.v);
        out.writeObject(this.rawV);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, this.dsc.getServiceName() + " sending save_command for key = " + this.getKey() + "; version = " + this.version + "; lastAccessedAt = " + this.lastAccessedAt + "; to " + this.getTargetName());
        }
    }

    public long getVersion() {
        return this.version;
    }

    public long getLastAccessedAt() {
        return this.lastAccessedAt;
    }

    public long getMaxIdleTime() {
        return this.maxIdleTime;
    }

    public byte[] getRawV() {
        return this.rawV;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.version = in.readLong();
        this.lastAccessedAt = in.readLong();
        this.maxIdleTime = in.readLong();
        this.rawV = (byte[])in.readObject();
    }
}

