/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.deployapi;

import com.sun.enterprise.deploy.shared.ArchiveFactory;
import com.sun.enterprise.deployment.deploy.shared.MemoryMappedArchive;
import com.sun.enterprise.module.bootstrap.StartupContext;
import com.sun.enterprise.module.single.StaticModulesRegistry;
import com.sun.enterprise.util.HostAndPort;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.StringUtils;
import com.sun.hk2.component.ExistingSingletonInhabitant;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.model.DeployableObject;
import javax.enterprise.deploy.shared.CommandType;
import javax.enterprise.deploy.shared.DConfigBeanVersionType;
import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.spi.DeploymentConfiguration;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import javax.enterprise.deploy.spi.exceptions.DConfigBeanVersionUnsupportedException;
import javax.enterprise.deploy.spi.exceptions.InvalidModuleException;
import javax.enterprise.deploy.spi.exceptions.TargetException;
import javax.enterprise.deploy.spi.status.DeploymentStatus;
import javax.enterprise.deploy.spi.status.ProgressEvent;
import javax.enterprise.deploy.spi.status.ProgressObject;
import org.glassfish.api.admin.ProcessEnvironment;
import org.glassfish.api.deployment.archive.Archive;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.deployapi.DeploymentStatusImplWithError;
import org.glassfish.deployapi.ProgressObjectSink;
import org.glassfish.deployapi.SimpleProgressObjectImpl;
import org.glassfish.deployapi.TargetImpl;
import org.glassfish.deployapi.TargetModuleIDImpl;
import org.glassfish.deployapi.config.SunDeploymentConfiguration;
import org.glassfish.deployment.client.DFDeploymentProperties;
import org.glassfish.deployment.client.DFProgressObject;
import org.glassfish.deployment.client.DeploymentFacility;
import org.glassfish.deployment.client.DeploymentFacilityFactory;
import org.glassfish.deployment.client.ServerConnectionEnvironment;
import org.glassfish.deployment.client.ServerConnectionIdentifier;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.Inhabitant;

public class SunDeploymentManager
implements DeploymentManager {
    private ServerConnectionIdentifier serverId = null;
    private DeploymentFacility deploymentFacility = null;
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(SunDeploymentManager.class);
    private static Locale defaultLocale = Locale.US;
    private Locale currentLocale = defaultLocale;
    private static Locale[] supportedLocales = new Locale[]{Locale.US};
    private String disconnectedMessage = localStrings.getLocalString("enterprise.deployapi.spi.disconnectedDM", "Illegal operation for a disconnected DeploymentManager");
    private static final String ENABLED_ATTRIBUTE_NAME = "Enabled";
    private Habitat habitat;

    public SunDeploymentManager() {
    }

    public SunDeploymentManager(ServerConnectionIdentifier sci) {
        this.deploymentFacility = DeploymentFacilityFactory.getDeploymentFacility();
        this.deploymentFacility.connect(sci);
        this.prepareHabitat();
    }

    public void setServerConnectionEnvironment(ServerConnectionEnvironment env) {
        this.serverId.setConnectionEnvironment(env);
    }

    public Target[] getTargets() throws IllegalStateException {
        this.verifyConnected();
        try {
            return this.deploymentFacility.listTargets();
        }
        catch (Throwable e) {
            IllegalStateException ex = new IllegalStateException(e.getMessage());
            ex.initCause(e);
            throw ex;
        }
    }

    public TargetModuleID[] getRunningModules(ModuleType moduleType, Target[] targetList) throws TargetException, IllegalStateException {
        return this.getModules(moduleType, targetList, "running");
    }

    public TargetModuleID[] getNonRunningModules(ModuleType moduleType, Target[] targetList) throws TargetException, IllegalStateException {
        return this.getModules(moduleType, targetList, "non-running");
    }

    public TargetModuleID[] getAvailableModules(ModuleType moduleType, Target[] targetList) throws TargetException, IllegalStateException {
        return this.getModules(moduleType, targetList, "all");
    }

    private void verifyConnected() {
        if (this.isDisconnected()) {
            throw new IllegalStateException(this.disconnectedMessage);
        }
    }

    private boolean isDisconnected() {
        if (this.deploymentFacility == null) {
            return true;
        }
        return !this.deploymentFacility.isConnected();
    }

    private TargetModuleID[] getModules(ModuleType moduleType, Target[] targetList, String state) throws TargetException, IllegalStateException {
        this.verifyConnected();
        if (moduleType == null) {
            return null;
        }
        try {
            Vector resultingTMIDs = new Vector();
            for (int i = 0; i < targetList.length; ++i) {
                TargetImpl aTarget = (TargetImpl)targetList[i];
                TargetModuleID[] tmids = this.deploymentFacility._listAppRefs(new Target[]{aTarget}, state, this.getTypeFromModuleType(moduleType));
                this.addToTargetModuleIDs(tmids, moduleType, aTarget, resultingTMIDs);
            }
            TargetModuleID[] answer = resultingTMIDs.toArray(new TargetModuleIDImpl[resultingTMIDs.size()]);
            return answer;
        }
        catch (Exception e) {
            TargetException tg = new TargetException(localStrings.getLocalString("enterprise.deployapi.spi.errorgetreqmods", "Error getting required modules"));
            tg.initCause((Throwable)e);
            throw tg;
        }
    }

    private String getTypeFromModuleType(ModuleType moduleType) {
        if (moduleType.equals(ModuleType.WAR)) {
            return "web";
        }
        if (moduleType.equals(ModuleType.EJB)) {
            return "ejb";
        }
        if (moduleType.equals(ModuleType.CAR)) {
            return "appclient";
        }
        if (moduleType.equals(ModuleType.RAR)) {
            return "connector";
        }
        if (moduleType.equals(ModuleType.EAR)) {
            return "ear";
        }
        return null;
    }

    private ModuleType getModuleTypeFromType(String type) {
        if (type.equals("war")) {
            return ModuleType.WAR;
        }
        if (type.equals("ejb")) {
            return ModuleType.EJB;
        }
        if (type.equals("car")) {
            return ModuleType.CAR;
        }
        if (type.equals("rar")) {
            return ModuleType.RAR;
        }
        if (type.equals("ear")) {
            return ModuleType.EAR;
        }
        return null;
    }

    private void addToTargetModuleIDs(TargetModuleID[] tmids, ModuleType type, TargetImpl targetImpl, Collection resultingTMIDs) throws IOException {
        for (int j = 0; j < tmids.length; ++j) {
            HostAndPort webHost = this.deploymentFacility.getHostAndPort(targetImpl.getName(), tmids[j].getModuleID(), false);
            if (tmids[j] instanceof TargetModuleIDImpl) {
                ((TargetModuleIDImpl)tmids[j]).setModuleType(type);
            }
            resultingTMIDs.add(tmids[j]);
            try {
                if (type.equals(ModuleType.EAR)) {
                    this.setJ2EEApplicationTargetModuleIDInfo(tmids[j], webHost);
                    continue;
                }
                if (!type.equals(ModuleType.WAR)) continue;
                this.setWebApplicationTargetModuleIDInfo(tmids[j], webHost);
                continue;
            }
            catch (Exception exp) {
                Logger.getAnonymousLogger().log(Level.WARNING, exp.getLocalizedMessage(), exp);
            }
        }
    }

    private void setJ2EEApplicationTargetModuleIDInfo(TargetModuleID tmid, HostAndPort hostAndPort) throws MalformedURLException, IOException {
        TargetImpl targetImpl = (TargetImpl)tmid.getTarget();
        try {
            List<String> subModuleInfoList = this.deploymentFacility.getSubModuleInfoForJ2EEApplication(tmid.getModuleID());
            for (String subModuleInfo : subModuleInfoList) {
                List<String> infoParts = StringUtils.parseStringList(subModuleInfo, ":");
                String subModuleName = infoParts.get(0);
                String subModuleID = tmid.getModuleID() + "#" + subModuleName;
                String subType = infoParts.get(1);
                ModuleType subModuleType = this.getModuleTypeFromType(subType);
                TargetModuleIDImpl childTmid = new TargetModuleIDImpl(targetImpl, subModuleID);
                childTmid.setModuleType(subModuleType);
                if (subType.equals("war")) {
                    URL webURL = new URL("http", hostAndPort.getHost(), hostAndPort.getPort(), infoParts.get(2));
                    childTmid.setWebURL(webURL.toExternalForm());
                }
                if (!(tmid instanceof TargetModuleIDImpl)) continue;
                ((TargetModuleIDImpl)tmid).addChildTargetModuleID(childTmid);
            }
        }
        catch (Exception exp) {
            Logger.getAnonymousLogger().log(Level.WARNING, exp.getLocalizedMessage(), exp);
        }
    }

    private void setWebApplicationTargetModuleIDInfo(TargetModuleID tmid, HostAndPort webHost) throws MalformedURLException, IOException {
        String path = this.deploymentFacility.getContextRoot(tmid.getModuleID());
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        URL webURL = new URL("http", webHost.getHost(), webHost.getPort(), path);
        if (tmid instanceof TargetModuleIDImpl) {
            ((TargetModuleIDImpl)tmid).setWebURL(webURL.toExternalForm());
        }
    }

    public DeploymentConfiguration createConfiguration(DeployableObject dObj) throws InvalidModuleException {
        try {
            SunDeploymentConfiguration deploymentConfiguration = new SunDeploymentConfiguration(dObj);
            deploymentConfiguration.setDeploymentManager(this);
            return deploymentConfiguration;
        }
        catch (ConfigurationException e) {
            InvalidModuleException ime = new InvalidModuleException(e.getMessage());
            ime.initCause((Throwable)e);
            throw ime;
        }
    }

    public ProgressObject distribute(Target[] targetList, File moduleArchive, File deploymentPlan) throws IllegalStateException {
        return this.deploy(targetList, moduleArchive, deploymentPlan, null);
    }

    public ProgressObject distribute(Target[] targetList, InputStream moduleArchive, InputStream deploymentPlan) throws IllegalStateException {
        return this.deploy(targetList, moduleArchive, deploymentPlan, null);
    }

    public ProgressObject distribute(Target[] targetList, ModuleType type, InputStream moduleArchive, InputStream deploymentPlan) throws IllegalStateException {
        DFDeploymentProperties dProps = new DFDeploymentProperties();
        dProps.setProperty("type", this.getTypeFromModuleType(type));
        return this.deploy(targetList, moduleArchive, deploymentPlan, (Properties)dProps);
    }

    public ProgressObject start(TargetModuleID[] moduleIDList) throws IllegalStateException {
        return this.executeCommandUsingFacility(CommandType.START, moduleIDList);
    }

    public ProgressObject stop(TargetModuleID[] moduleIDList) throws IllegalStateException {
        return this.executeCommandUsingFacility(CommandType.STOP, moduleIDList);
    }

    public ProgressObject undeploy(TargetModuleID[] moduleIDList) throws IllegalStateException {
        return this.executeCommandUsingFacility(CommandType.UNDEPLOY, moduleIDList);
    }

    public boolean isRedeploySupported() {
        return true;
    }

    public ProgressObject redeploy(TargetModuleID[] moduleIDList, File moduleArchive, File deploymentPlan) throws UnsupportedOperationException, IllegalStateException {
        try {
            TargetModuleIDCollection coll = new TargetModuleIDCollection(moduleIDList);
            Iterator it = coll.iterator();
            while (it.hasNext()) {
                DeploymentFacilityModuleWork work = (DeploymentFacilityModuleWork)it.next();
                ProgressObject po = this.deploy(work.targets(), moduleArchive, deploymentPlan, (Properties)this.getRedeployOptions(work.getModuleID()));
                work.setProgressObject(po);
                coll.getProgressObjectSink().sinkProgressObject(po);
            }
            return coll.getProgressObjectSink();
        }
        catch (Throwable e) {
            return this.prepareErrorProgressObject(CommandType.REDEPLOY, e);
        }
    }

    public ProgressObject redeploy(TargetModuleID[] moduleIDList, InputStream moduleArchive, InputStream deploymentPlan) throws UnsupportedOperationException, IllegalStateException {
        try {
            TargetModuleIDCollection coll = new TargetModuleIDCollection(moduleIDList);
            Iterator it = coll.iterator();
            while (it.hasNext()) {
                DeploymentFacilityModuleWork work = (DeploymentFacilityModuleWork)it.next();
                DFDeploymentProperties dProps = this.getRedeployOptions(work.getModuleID());
                ProgressObject po = this.deploy(work.targets(), moduleArchive, deploymentPlan, (Properties)dProps);
                work.setProgressObject(po);
                coll.getProgressObjectSink().sinkProgressObject(po);
            }
            return coll.getProgressObjectSink();
        }
        catch (Throwable e) {
            return this.prepareErrorProgressObject(CommandType.REDEPLOY, e);
        }
    }

    public void release() {
        if (!this.isDisconnected()) {
            this.deploymentFacility = null;
        }
    }

    public Locale getDefaultLocale() {
        return defaultLocale;
    }

    public Locale getCurrentLocale() {
        return this.currentLocale;
    }

    public void setLocale(Locale locale) throws UnsupportedOperationException {
        for (int i = 0; i < supportedLocales.length; ++i) {
            if (supportedLocales[i] != locale) continue;
            this.currentLocale = locale;
            return;
        }
        throw new UnsupportedOperationException(localStrings.getLocalString("enterprise.deployapi.spi.localnotsupported", "Locale {0} is not supported", locale));
    }

    public Locale[] getSupportedLocales() {
        return supportedLocales;
    }

    public boolean isLocaleSupported(Locale locale) {
        Locale[] locales = this.getSupportedLocales();
        for (int i = 0; i < locales.length; ++i) {
            if (!locales[i].equals(locale)) continue;
            return true;
        }
        return false;
    }

    public DConfigBeanVersionType getDConfigBeanVersion() {
        return DConfigBeanVersionType.V5;
    }

    public boolean isDConfigBeanVersionSupported(DConfigBeanVersionType version) {
        return version.getValue() == this.getDConfigBeanVersion().getValue();
    }

    public void setDConfigBeanVersion(DConfigBeanVersionType version) throws DConfigBeanVersionUnsupportedException {
        if (!this.isDConfigBeanVersionSupported(version)) {
            throw new DConfigBeanVersionUnsupportedException(localStrings.getLocalString("enterprise.deployapi.spi.dconfigbeanversionnotsupported", "DConfigBean version {0} is not supported", version.toString()));
        }
    }

    private DFDeploymentProperties getRedeployOptions(String moduleID) {
        DFDeploymentProperties deplProps = new DFDeploymentProperties();
        deplProps.setForce(true);
        deplProps.setName(moduleID);
        deplProps.setRedeploy(true);
        return deplProps;
    }

    private ProgressObject deploy(Target[] targetList, InputStream moduleStream, InputStream deploymentPlanStream, Properties presetOptions) throws IllegalStateException {
        MemoryMappedArchive moduleArchive = null;
        MemoryMappedArchive deploymentPlanArchive = null;
        try {
            moduleArchive = new MemoryMappedArchive(moduleStream);
            if (deploymentPlanStream != null) {
                deploymentPlanArchive = new MemoryMappedArchive(deploymentPlanStream);
            }
            return this.deploy(targetList, (ReadableArchive)moduleArchive, (ReadableArchive)deploymentPlanArchive, presetOptions);
        }
        catch (Throwable e) {
            String msg = localStrings.getLocalString("enterprise.deployapi.spi.errpreparearchstream", "Could not prepare archives for module and/or deployment plan input streams");
            IllegalArgumentException ex = new IllegalArgumentException(msg);
            ex.initCause(e);
            return this.prepareErrorProgressObject(CommandType.DISTRIBUTE, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProgressObject deploy(Target[] targetList, File moduleArchive, File deploymentPlan, Properties presetOptions) throws IllegalStateException {
        ProgressObject progressObject;
        ReadableArchive appArchive = null;
        ReadableArchive planArchive = null;
        ArchiveFactory archiveFactory = this.getArchiveFactory();
        try {
            ProgressObject po;
            appArchive = archiveFactory.openArchive(moduleArchive);
            if (deploymentPlan != null && deploymentPlan.length() != 0L && (planArchive = archiveFactory.openArchive(deploymentPlan)) == null) {
                throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployapi.spi.noarchivisthandlesplan", "No archivist is able to handle the deployment plan {0}", deploymentPlan.getAbsolutePath()));
            }
            progressObject = po = this.deploy(targetList, appArchive, planArchive, presetOptions);
            this.closeArchives(CommandType.DISTRIBUTE, appArchive, moduleArchive.getAbsolutePath(), planArchive, deploymentPlan != null ? deploymentPlan.getAbsolutePath() : null);
        }
        catch (Exception se) {
            ProgressObject progressObject2;
            try {
                String msg = localStrings.getLocalString("enterprise.deployapi.spi.errpreparearchfile", "Could not prepare archives for module and/or deployment plan files");
                IllegalArgumentException ex = new IllegalArgumentException(msg);
                ex.initCause(se);
                progressObject2 = this.prepareErrorProgressObject(CommandType.DISTRIBUTE, ex);
                this.closeArchives(CommandType.DISTRIBUTE, appArchive, moduleArchive.getAbsolutePath(), planArchive, deploymentPlan != null ? deploymentPlan.getAbsolutePath() : null);
            }
            catch (Throwable throwable) {
                this.closeArchives(CommandType.DISTRIBUTE, appArchive, moduleArchive.getAbsolutePath(), planArchive, deploymentPlan != null ? deploymentPlan.getAbsolutePath() : null);
                throw throwable;
            }
            return progressObject2;
        }
        return progressObject;
    }

    private ProgressObject deploy(Target[] targetList, ReadableArchive moduleArchive, ReadableArchive planArchive, Properties presetOptions) throws IllegalStateException {
        this.verifyConnected();
        ProgressObject progressObj = null;
        try {
            Properties options = this.getProperties();
            if (presetOptions != null) {
                options.putAll((Map<?, ?>)presetOptions);
            }
            progressObj = this.deploymentFacility.deploy(targetList, moduleArchive, planArchive, (Map)options);
        }
        catch (Throwable e) {
            progressObj = this.prepareErrorProgressObject(CommandType.DISTRIBUTE, e);
        }
        return progressObj;
    }

    private ProgressObject closeArchives(CommandType commandType, ReadableArchive moduleArchive, String moduleArchiveSpec, ReadableArchive planArchive, String planArchiveSpec) {
        ProgressObject errorPO = null;
        IOException moduleIOE = this.closeArchive(moduleArchive);
        IOException planIOE = this.closeArchive(planArchive);
        IOException excForProgressObject = null;
        String errorMsg = null;
        if (moduleIOE != null) {
            excForProgressObject = moduleIOE;
            errorMsg = planIOE != null ? localStrings.getLocalString("enterprise.deployapi.spi.errclosearchs", "Could not close module archive {0} or deployment plan archive {1}", moduleArchiveSpec, planArchiveSpec) : localStrings.getLocalString("enterprise.deployapi.spi.errclosemodulearch", "Could not close module archive {0}", moduleArchiveSpec);
        } else if (planIOE != null) {
            excForProgressObject = planIOE;
            errorMsg = localStrings.getLocalString("enterprise.deployapi.spi.errcloseplanarch", "Could not close deployment plan archive {0}", planArchiveSpec);
        }
        if (errorMsg != null) {
            IOException ioe = new IOException(errorMsg);
            ioe.initCause(excForProgressObject);
            errorPO = this.prepareErrorProgressObject(commandType, ioe);
        }
        return errorPO;
    }

    private IOException closeArchive(ReadableArchive archive) {
        IOException errorIOE = null;
        if (archive != null) {
            try {
                archive.close();
            }
            catch (IOException ioe) {
                errorIOE = ioe;
            }
        }
        return errorIOE;
    }

    private ProgressObject executeCommandUsingFacility(CommandType commandType, TargetModuleID[] targetModuleIDList) throws IllegalStateException {
        this.verifyConnected();
        try {
            TargetModuleIDCollection coll = new TargetModuleIDCollection(targetModuleIDList);
            Iterator it = coll.iterator();
            while (it.hasNext()) {
                DeploymentFacilityModuleWork work = (DeploymentFacilityModuleWork)it.next();
                DFProgressObject po = null;
                if (commandType.equals(CommandType.START)) {
                    po = this.deploymentFacility.enable(work.targets(), work.getModuleID());
                } else if (commandType.equals(CommandType.STOP)) {
                    po = this.deploymentFacility.disable(work.targets(), work.getModuleID());
                } else if (commandType.equals(CommandType.UNDEPLOY)) {
                    po = this.deploymentFacility.undeploy(work.targets(), work.getModuleID());
                } else {
                    throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployapi.spi.unexpcommand", "Received unexpected deployment facility command ${0}", commandType.toString()));
                }
                work.setProgressObject(po);
                coll.getProgressObjectSink().sinkProgressObject(po);
            }
            return coll.getProgressObjectSink();
        }
        catch (Throwable thr) {
            return this.prepareErrorProgressObject(commandType, thr);
        }
    }

    private ProgressObject prepareErrorProgressObject(CommandType commandType, Throwable thr) {
        DeploymentStatusImplWithError ds = new DeploymentStatusImplWithError(CommandType.DISTRIBUTE, thr);
        SimpleProgressObjectImpl progressObj = new SimpleProgressObjectImpl(ds);
        ProgressEvent event = new ProgressEvent((Object)progressObj, null, (DeploymentStatus)ds);
        progressObj.fireProgressEvent(event);
        return progressObj;
    }

    protected Properties getProperties() {
        DFDeploymentProperties dProps = new DFDeploymentProperties();
        dProps.setEnabled(false);
        return dProps;
    }

    public ProgressObject distribute(Target[] targetList, Archive moduleArchive, Archive deploymentPlan, Object deploymentOptions) throws IllegalStateException {
        return null;
    }

    public Archive getArchive(URI path, String name) throws IOException {
        if (path == null) {
            File root = File.createTempFile(name, ".jar");
            path = root.toURI();
        }
        ArchiveFactory factory = this.getArchiveFactory();
        boolean exists = false;
        if (!path.getScheme().equals("file") && !path.getScheme().equals("jar")) {
            return null;
        }
        File target = new File(path);
        exists = target.exists();
        if (exists) {
            return factory.openArchive(path);
        }
        return factory.createArchive(path);
    }

    private void prepareHabitat() {
        StaticModulesRegistry registry = new StaticModulesRegistry(this.getClass().getClassLoader());
        this.habitat = registry.createHabitat("default");
        StartupContext startupContext = new StartupContext();
        this.habitat.add((Inhabitant)new ExistingSingletonInhabitant((Object)startupContext));
        this.habitat.addComponent(null, (Object)new ProcessEnvironment(ProcessEnvironment.ProcessType.Other));
    }

    private ArchiveFactory getArchiveFactory() {
        return (ArchiveFactory)this.habitat.getComponent(ArchiveFactory.class);
    }

    protected static class DeploymentFacilityModuleWork {
        private String moduleID = null;
        private Collection targets = new Vector();
        private ProgressObject progressObject = null;

        public DeploymentFacilityModuleWork(String moduleID) {
            this.moduleID = moduleID;
        }

        public void addTarget(Target target) {
            if (!(target instanceof TargetImpl)) {
                throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployapi.spi.unexptargettyp", "Target must be of type TargetImpl but encountered {0}", target.getClass().getName()));
            }
            this.targets.add(target);
        }

        public Target[] targets() {
            return this.targets.toArray(new TargetImpl[this.targets.size()]);
        }

        public ProgressObject getProgressObject() {
            return this.progressObject;
        }

        public void setProgressObject(ProgressObject progressObject) {
            this.progressObject = progressObject;
        }

        public String getModuleID() {
            return this.moduleID;
        }
    }

    protected static class TargetModuleIDCollection {
        private HashMap moduleIDToInfoMap = new HashMap();
        ProgressObjectSink progressObjectSink = null;

        public TargetModuleIDCollection(TargetModuleID[] targetModuleIDs) throws IllegalArgumentException {
            for (int i = 0; i < targetModuleIDs.length; ++i) {
                Target candidateTarget = targetModuleIDs[i].getTarget();
                if (!(candidateTarget instanceof TargetImpl)) {
                    throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployapi.spi.nott", "Expected TargetImpl instance but found instance of {0}", candidateTarget.getClass().getName()));
                }
                String moduleID = targetModuleIDs[i].getModuleID();
                DeploymentFacilityModuleWork work = (DeploymentFacilityModuleWork)this.moduleIDToInfoMap.get(moduleID);
                if (work == null) {
                    work = new DeploymentFacilityModuleWork(moduleID);
                    this.moduleIDToInfoMap.put(moduleID, work);
                }
                work.addTarget(candidateTarget);
            }
        }

        public Iterator iterator() {
            return this.moduleIDToInfoMap.values().iterator();
        }

        public int size() {
            return this.moduleIDToInfoMap.size();
        }

        public ProgressObjectSink getProgressObjectSink() {
            if (this.progressObjectSink == null) {
                this.progressObjectSink = new ProgressObjectSink();
            }
            return this.progressObjectSink;
        }
    }
}

