/*
 * Decompiled with CFR 0.152.
 */
package org.shoal.ha.cache.impl.command;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.reflect.Array;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.shoal.ha.cache.api.AbstractCommandInterceptor;
import org.shoal.ha.cache.api.DataStoreContext;
import org.shoal.ha.cache.api.DataStoreException;
import org.shoal.ha.cache.api.ObjectInputStreamWithLoader;
import org.shoal.ha.cache.impl.command.Command;
import org.shoal.ha.cache.impl.interceptor.CommandHandlerInterceptor;
import org.shoal.ha.cache.impl.interceptor.TransmitInterceptor;
import org.shoal.ha.cache.impl.util.MessageReceiver;

public class CommandManager<K, V>
extends MessageReceiver {
    private String myName;
    private DataStoreContext<K, V> dsc;
    private Command<K, V>[] commands = (Command[])Array.newInstance(Command.class, 256);
    private volatile AbstractCommandInterceptor<K, V> head;
    private volatile AbstractCommandInterceptor<K, V> tail;
    private static Logger _logger = Logger.getLogger("org.shoal.ha.cache.command");
    private static Logger _statsLogger = Logger.getLogger("org.shoal.ha.cache.stats");

    public void initialize(DataStoreContext<K, V> dsc) {
        this.dsc = dsc;
        this.myName = dsc.getInstanceName();
        this.head = new CommandHandlerInterceptor();
        this.head.initialize(dsc);
        this.tail = new TransmitInterceptor();
        this.tail.initialize(dsc);
        this.head.setNext(this.tail);
        this.tail.setPrev(this.head);
    }

    public void registerCommand(Command command) {
        this.commands[command.getOpcode()] = command;
        command.initialize(this.dsc);
    }

    public synchronized void registerExecutionInterceptor(AbstractCommandInterceptor<K, V> interceptor) {
        interceptor.initialize(this.dsc);
        interceptor.setPrev(this.tail.getPrev());
        this.tail.getPrev().setNext(interceptor);
        interceptor.setNext(this.tail);
        this.tail.setPrev(interceptor);
    }

    public void execute(Command<K, V> cmd) throws DataStoreException {
        this.executeCommand(cmd, true, this.myName);
    }

    public final void executeCommand(Command<K, V> cmd, boolean forward, String initiator) throws DataStoreException {
        cmd.initialize(this.dsc);
        if (forward) {
            try {
                this.head.onTransmit(cmd, initiator);
                cmd.onSuccess();
            }
            catch (DataStoreException dseEx) {
                cmd.onFailure();
            }
        } else {
            this.tail.onReceive(cmd, initiator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void handleMessage(String sourceMemberName, String token, byte[] messageData) {
        ObjectInputStream ois = null;
        ByteArrayInputStream bis = null;
        try {
            bis = new ByteArrayInputStream(messageData);
            ois = this.dsc.getKeyTransformer() == null ? new ObjectInputStreamWithLoader(bis, this.dsc.getClassLoader()) : new ObjectInputStream(bis);
            Command cmd = (Command)ois.readObject();
            if (_logger.isLoggable(Level.FINER)) {
                _logger.log(Level.FINER, this.dsc.getServiceName() + " RECEIVED " + cmd);
            }
            cmd.initialize(this.dsc);
            int receivedCount = this.dsc.getDataStoreMBean().incrementBatchReceivedCount();
            if (_statsLogger.isLoggable(Level.FINE)) {
                _statsLogger.log(Level.FINE, "Received message#  " + receivedCount + "  from " + sourceMemberName);
            }
            this.executeCommand(cmd, false, sourceMemberName);
        }
        catch (IOException dse) {
            _logger.log(Level.WARNING, "Error during parsing command: opcode: " + messageData[0], dse);
        }
        catch (Throwable th) {
            _logger.log(Level.WARNING, "Error[2] during parsing command: opcode: " + messageData[0], th);
        }
        finally {
            try {
                bis.close();
            }
            catch (Exception ex) {}
            try {
                ois.close();
            }
            catch (Exception ex) {}
        }
    }
}

