/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.gms.tools;

import com.sun.enterprise.gms.tools.MultiCastReceiverThread;
import com.sun.enterprise.gms.tools.MulticastSenderThread;
import com.sun.enterprise.gms.tools.StringManager;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.StringTokenizer;
import java.util.UUID;

public class MulticastTester {
    static final StringManager sm = StringManager.getInstance();
    static final String DASH = "--";
    static final String SEP = "|";
    public static final String HELP_OPTION = "--" + sm.get("help.option", new Object[0]);
    public static final String PORT_OPTION = "--" + sm.get("port.option", new Object[0]);
    public static final String ADDRESS_OPTION = "--" + sm.get("address.option", new Object[0]);
    public static final String BIND_OPTION = "--" + sm.get("bind.int.option", new Object[0]);
    public static final String TTL_OPTION = "--" + sm.get("ttl.option", new Object[0]);
    public static final String WAIT_PERIOD_OPTION = "--" + sm.get("period.option", new Object[0]);
    public static final String TIMEOUT_OPTION = "--" + sm.get("timeout.option", new Object[0]);
    public static final String DEBUG_OPTION = "--" + sm.get("debug.option", new Object[0]);
    int mcPort = 2048;
    String mcAddress = "228.9.3.1";
    String bindInterface = null;
    int ttl = -1;
    long msgPeriodInMillis = 2000L;
    boolean debug = false;
    long testerTimeoutInSeconds = 20L;

    public int run(String[] args) {
        String dataString;
        if (!this.parseArgs(args)) {
            return 1;
        }
        StringBuilder out = new StringBuilder();
        out.append(sm.get("port.set", Integer.toString(this.mcPort))).append("\n");
        out.append(sm.get("address.set", this.mcAddress)).append("\n");
        out.append(sm.get("bind.int.set", this.bindInterface)).append("\n");
        out.append(sm.get("period.set", this.msgPeriodInMillis)).append("\n");
        if (this.ttl != -1) {
            out.append(sm.get("ttl.set", this.ttl)).append("\n");
        }
        System.out.println(out.toString());
        try {
            InetAddress localHost = InetAddress.getLocalHost();
            dataString = this.mcAddress + SEP + localHost.getHostName() + SEP + UUID.randomUUID().toString();
        }
        catch (UnknownHostException uhe) {
            System.err.println(sm.get("whoops", uhe.getMessage()));
            return 1;
        }
        MultiCastReceiverThread receiver = new MultiCastReceiverThread(this.mcPort, this.mcAddress, this.bindInterface, this.debug, dataString);
        MulticastSenderThread sender = new MulticastSenderThread(this.mcPort, this.mcAddress, this.bindInterface, this.ttl, this.msgPeriodInMillis, this.debug, dataString);
        receiver.start();
        sender.start();
        try {
            Thread.sleep(1000L * this.testerTimeoutInSeconds);
            receiver.done = true;
            sender.done = true;
            receiver.interrupt();
            receiver.join(500L);
            if (receiver.isAlive()) {
                this.log("could not join receiver thread (expected)");
            } else {
                this.log("joined receiver thread");
            }
            sender.interrupt();
            sender.join(500L);
            if (sender.isAlive()) {
                this.log("could not join sender thread");
            } else {
                this.log("joined sender thread");
            }
        }
        catch (InterruptedException ie) {
            System.err.println(sm.get("whoops", ie.getMessage()));
            ie.printStackTrace();
        }
        System.out.println(sm.get("timeout.exit", this.testerTimeoutInSeconds, TIMEOUT_OPTION));
        if (!receiver.receivedAnything.get()) {
            System.out.println(sm.get("no.data.for.you", new Object[0]));
            return 1;
        }
        return 0;
    }

    private boolean parseArgs(String[] args) {
        try {
            for (int i = 0; i < args.length; ++i) {
                String arg = args[i];
                if (HELP_OPTION.equals(arg)) {
                    this.printHelp();
                    return false;
                }
                if (PORT_OPTION.equals(arg)) {
                    try {
                        arg = args[++i];
                        this.mcPort = Integer.parseInt(arg);
                        continue;
                    }
                    catch (NumberFormatException nfe) {
                        System.err.println(sm.get("bad.num.param", arg, PORT_OPTION));
                        return false;
                    }
                }
                if (ADDRESS_OPTION.equals(arg)) {
                    this.mcAddress = args[++i];
                    continue;
                }
                if (BIND_OPTION.equals(arg)) {
                    this.bindInterface = args[++i];
                    continue;
                }
                if (TTL_OPTION.equals(arg)) {
                    try {
                        arg = args[++i];
                        this.ttl = Integer.parseInt(arg);
                        continue;
                    }
                    catch (NumberFormatException nfe) {
                        System.err.println(sm.get("bad.num.param", arg, TTL_OPTION));
                        return false;
                    }
                }
                if (WAIT_PERIOD_OPTION.equals(arg)) {
                    try {
                        arg = args[++i];
                        this.msgPeriodInMillis = Long.parseLong(arg);
                        continue;
                    }
                    catch (NumberFormatException nfe) {
                        System.err.println(sm.get("bad.num.param", arg, WAIT_PERIOD_OPTION));
                        return false;
                    }
                }
                if (TIMEOUT_OPTION.equals(arg)) {
                    try {
                        arg = args[++i];
                        this.testerTimeoutInSeconds = Long.parseLong(arg);
                    }
                    catch (NumberFormatException nfe) {
                        System.err.println(sm.get("bad.num.param", arg, TIMEOUT_OPTION));
                        return false;
                    }
                    System.out.println(sm.get("timeout.set", this.testerTimeoutInSeconds));
                    continue;
                }
                if (DEBUG_OPTION.equals(arg)) {
                    System.err.println(sm.get("debug.set", new Object[0]));
                    this.debug = true;
                    continue;
                }
                System.err.println(sm.get("unknown.option", arg, HELP_OPTION));
                return false;
            }
        }
        catch (ArrayIndexOutOfBoundsException badUser) {
            System.err.println(sm.get("bad.user.param", new Object[0]));
            this.printHelp();
            return false;
        }
        return true;
    }

    private void printHelp() {
        StringBuilder sb = new StringBuilder();
        sb.append(sm.get("help.message", new Object[0])).append("\n");
        sb.append(HELP_OPTION).append("\n");
        sb.append(PORT_OPTION).append("\n");
        sb.append(ADDRESS_OPTION).append("\n");
        sb.append(BIND_OPTION).append("\n");
        sb.append(TTL_OPTION).append("\n");
        sb.append(WAIT_PERIOD_OPTION).append("\n");
        sb.append(TIMEOUT_OPTION).append("\n");
        sb.append(DEBUG_OPTION).append("\n");
        System.out.println(sb.toString());
    }

    private void log(String msg) {
        if (this.debug) {
            System.err.println("MainThread: " + msg);
        }
    }

    public static void main(String[] args) {
        MulticastTester tester = new MulticastTester();
        System.exit(tester.run(args));
    }

    static String trimDataString(String s) {
        StringTokenizer st = new StringTokenizer(s, SEP);
        st.nextToken();
        return st.nextToken();
    }
}

