/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.mgmt.transport;

import com.sun.enterprise.ee.cms.logging.GMSLogDomain;
import com.sun.enterprise.mgmt.transport.MessageIOException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class NetworkUtility {
    private static final Logger LOG;
    public static final String IPV4ANYADDRESS = "0.0.0.0";
    public static final String IPV6ANYADDRESS = "::";
    public static final String IPV4LOOPBACK = "127.0.0.1";
    public static final String IPV6LOOPBACK = "::1";
    public static final InetAddress ANYADDRESS;
    public static final InetAddress ANYADDRESSV4;
    public static final InetAddress ANYADDRESSV6;
    public static final InetAddress LOOPBACK;
    public static final InetAddress LOOPBACKV4;
    public static final InetAddress LOOPBACKV6;
    public static volatile List<InetAddress> allLocalAddresses;
    public static volatile NetworkInterface firstNetworkInterface;
    public static volatile InetAddress firstInetAddressV4;
    public static volatile InetAddress firstInetAddressV6;
    private static Method isLoopbackMethod;
    private static Method isUpMethod;
    private static Method supportsMulticastMethod;
    private static final Field DEPTH_FIELD;

    public static List<InetAddress> getAllLocalAddresses() {
        Enumeration<NetworkInterface> allInterfaces;
        ArrayList<InetAddress> allAddr;
        block11: {
            if (allLocalAddresses != null) {
                return allLocalAddresses;
            }
            allAddr = new ArrayList<InetAddress>();
            allInterfaces = null;
            try {
                allInterfaces = NetworkInterface.getNetworkInterfaces();
            }
            catch (SocketException t) {
                if (!LOG.isLoggable(Level.INFO)) break block11;
                LOG.log(Level.INFO, "Could not get local interfaces' list", t);
            }
        }
        if (allInterfaces == null) {
            allInterfaces = Collections.enumeration(Collections.emptyList());
        }
        while (allInterfaces.hasMoreElements()) {
            NetworkInterface anInterface = allInterfaces.nextElement();
            try {
                if (!NetworkUtility.isUp(anInterface)) continue;
                Enumeration<InetAddress> allIntfAddr = anInterface.getInetAddresses();
                while (allIntfAddr.hasMoreElements()) {
                    InetAddress anAddr = allIntfAddr.nextElement();
                    if (anAddr.isLoopbackAddress() || anAddr.isAnyLocalAddress() || allAddr.contains(anAddr)) continue;
                    allAddr.add(anAddr);
                }
            }
            catch (Throwable t) {
                if (!LOG.isLoggable(Level.INFO)) continue;
                LOG.log(Level.INFO, "Could not get addresses for " + anInterface, t);
            }
        }
        if (allAddr.isEmpty()) {
            if (LOOPBACKV4 != null) {
                allAddr.add(LOOPBACKV4);
            }
            if (LOOPBACKV6 != null) {
                allAddr.add(LOOPBACKV6);
            }
        }
        allLocalAddresses = allAddr;
        return allLocalAddresses;
    }

    public static NetworkInterface getFirstNetworkInterface() throws IOException {
        if (firstNetworkInterface != null) {
            return firstNetworkInterface;
        }
        NetworkInterface loopback = null;
        NetworkInterface firstInterface = null;
        Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
        while (interfaces != null && interfaces.hasMoreElements()) {
            NetworkInterface anInterface = interfaces.nextElement();
            if (NetworkUtility.isLoopbackNetworkInterface(anInterface)) {
                loopback = anInterface;
                continue;
            }
            if (!NetworkUtility.supportsMulticast(anInterface) || NetworkUtility.getFirstInetAddress(anInterface, false) == null && NetworkUtility.getFirstInetAddress(anInterface, true) == null) continue;
            firstInterface = anInterface;
            break;
        }
        if (firstInterface == null) {
            firstInterface = loopback;
        }
        if (firstInterface == null) {
            throw new IOException("failed to find a network interface");
        }
        firstNetworkInterface = firstInterface;
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("getFirstNetworkInterface  result: interface name" + firstNetworkInterface.getName() + " address:" + firstNetworkInterface.getInetAddresses().nextElement().toString());
        }
        return firstNetworkInterface;
    }

    public static InetAddress getFirstInetAddress(boolean preferIPv6) throws IOException {
        if (preferIPv6 && firstInetAddressV6 != null) {
            return firstInetAddressV6;
        }
        if (!preferIPv6 && firstInetAddressV4 != null) {
            return firstInetAddressV4;
        }
        NetworkInterface anInterface = NetworkUtility.getFirstNetworkInterface();
        Enumeration<InetAddress> allIntfAddr = anInterface.getInetAddresses();
        while (allIntfAddr.hasMoreElements()) {
            InetAddress anAddr = allIntfAddr.nextElement();
            if (anAddr.isLoopbackAddress() || anAddr.isAnyLocalAddress()) continue;
            if (firstInetAddressV6 == null && anAddr instanceof Inet6Address) {
                firstInetAddressV6 = anAddr;
            } else if (firstInetAddressV4 == null && anAddr instanceof Inet4Address) {
                firstInetAddressV4 = anAddr;
            }
            if (firstInetAddressV6 == null || firstInetAddressV4 == null) continue;
            break;
        }
        if (preferIPv6) {
            return firstInetAddressV6;
        }
        return firstInetAddressV4;
    }

    public static InetAddress getFirstInetAddress(NetworkInterface anInterface, boolean preferIPv6) throws IOException {
        if (anInterface == null) {
            return null;
        }
        InetAddress firstInetAddressV4 = null;
        InetAddress firstInetAddressV6 = null;
        Enumeration<InetAddress> allIntfAddr = anInterface.getInetAddresses();
        while (allIntfAddr.hasMoreElements()) {
            InetAddress anAddr = allIntfAddr.nextElement();
            if (anAddr.isLoopbackAddress() || anAddr.isAnyLocalAddress()) continue;
            if (firstInetAddressV6 == null && anAddr instanceof Inet6Address) {
                firstInetAddressV6 = anAddr;
            } else if (firstInetAddressV4 == null && anAddr instanceof Inet4Address) {
                firstInetAddressV4 = anAddr;
            }
            if (firstInetAddressV6 == null || firstInetAddressV4 == null) continue;
            break;
        }
        if (preferIPv6) {
            return firstInetAddressV6;
        }
        return firstInetAddressV4;
    }

    public static boolean isLoopbackNetworkInterface(NetworkInterface anInterface) {
        if (anInterface == null) {
            return false;
        }
        if (isLoopbackMethod != null) {
            try {
                return (Boolean)isLoopbackMethod.invoke((Object)anInterface, new Object[0]);
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        boolean hasLoopback = false;
        Enumeration<InetAddress> allIntfAddr = anInterface.getInetAddresses();
        while (allIntfAddr.hasMoreElements()) {
            InetAddress anAddr = allIntfAddr.nextElement();
            if (!anAddr.isLoopbackAddress()) continue;
            hasLoopback = true;
            break;
        }
        return hasLoopback;
    }

    public static boolean supportsMulticast(NetworkInterface anInterface) {
        if (anInterface == null) {
            return false;
        }
        if (isUpMethod != null && supportsMulticastMethod != null) {
            try {
                return (Boolean)isUpMethod.invoke((Object)anInterface, new Object[0]) != false && (Boolean)supportsMulticastMethod.invoke((Object)anInterface, new Object[0]) != false;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return false;
    }

    public static boolean isUp(NetworkInterface anInterface) {
        if (anInterface == null) {
            return false;
        }
        if (isUpMethod != null) {
            try {
                return (Boolean)isUpMethod.invoke((Object)anInterface, new Object[0]);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return false;
    }

    public static void writeIntToByteArray(byte[] bytes, int offset, int value) throws IllegalArgumentException {
        if (bytes == null) {
            return;
        }
        if (bytes.length < offset + 4) {
            throw new IllegalArgumentException("bytes' length is too small");
        }
        bytes[offset + 0] = (byte)(value >> 24 & 0xFF);
        bytes[offset + 1] = (byte)(value >> 16 & 0xFF);
        bytes[offset + 2] = (byte)(value >> 8 & 0xFF);
        bytes[offset + 3] = (byte)(value & 0xFF);
    }

    public static int getIntFromByteArray(byte[] bytes, int offset) throws IllegalArgumentException {
        if (bytes == null) {
            return 0;
        }
        if (bytes.length < offset + 4) {
            throw new IllegalArgumentException("bytes' length is too small");
        }
        int ch1 = bytes[offset] & 0xFF;
        int ch2 = bytes[offset + 1] & 0xFF;
        int ch3 = bytes[offset + 2] & 0xFF;
        int ch4 = bytes[offset + 3] & 0xFF;
        return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + ch4;
    }

    public static int serialize(ByteArrayOutputStream baos, Map<String, Serializable> messages) throws MessageIOException {
        return NetworkUtility.serialize(baos, messages, false);
    }

    public static int serialize(ByteArrayOutputStream baos, Map<String, Serializable> messages, boolean debug) throws MessageIOException {
        int count = 0;
        if (baos == null || messages == null) {
            return count;
        }
        String name = null;
        ObjectOutputStream oos = null;
        try {
            oos = debug ? new DebuggingObjectOutputStream(baos) : new ObjectOutputStream(baos);
            for (Map.Entry<String, Serializable> entry : messages.entrySet()) {
                name = entry.getKey();
                Serializable obj = entry.getValue();
                ++count;
                oos.writeObject(name);
                oos.writeObject(obj);
            }
            oos.flush();
        }
        catch (Throwable t) {
            throw new MessageIOException("failed to serialize a message : name = " + name + "." + (debug ? " path to bad object: " + ((DebuggingObjectOutputStream)oos).getStack() : ""), t);
        }
        finally {
            if (oos != null) {
                try {
                    oos.close();
                }
                catch (IOException e) {}
            }
        }
        return count;
    }

    public static void deserialize(InputStream is, int count, Map<String, Serializable> messages) throws MessageIOException {
        if (is == null || count <= 0 || messages == null) {
            return;
        }
        String name = null;
        ObjectInputStream ois = null;
        try {
            ois = new ObjectInputStream(is);
            Object obj = null;
            for (int i = 0; i < count; ++i) {
                name = (String)ois.readObject();
                obj = ois.readObject();
                if (!(obj instanceof Serializable)) continue;
                messages.put(name, (Serializable)obj);
            }
        }
        catch (Throwable t) {
            LOG.log(Level.WARNING, "netutil.deserialize.failure", new Object[]{messages.toString(), name, Thread.currentThread().getName()});
            throw new MessageIOException("failed to deserialize a message : name = " + name, t);
        }
        finally {
            if (ois != null) {
                try {
                    ois.close();
                }
                catch (IOException e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isBindAddressValid(String addressString) {
        ServerSocket socket = null;
        try {
            InetAddress ia = Inet4Address.getByName(addressString);
            socket = new ServerSocket(0, 0, ia);
            boolean retVal = socket.isBound();
            if (!retVal) {
                LOG.log(Level.WARNING, "netutil.validate.bind.not.bound", addressString);
            }
            boolean bl = retVal;
            return bl;
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "netutil.validate.bind.address.exception", new Object[]{addressString, e.toString()});
            boolean bl = false;
            return bl;
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException ioe) {
                    LOG.log(Level.FINE, "Could not close socket used to validate address.");
                }
            }
        }
    }

    public static void main(String[] args) throws IOException {
        System.out.println("AllLocalAddresses() = " + NetworkUtility.getAllLocalAddresses());
        System.out.println("getFirstNetworkInterface() = " + NetworkUtility.getFirstNetworkInterface());
        System.out.println("getFirstInetAddress( true ) = " + NetworkUtility.getFirstInetAddress(true));
        System.out.println("getFirstInetAddress( false ) = " + NetworkUtility.getFirstInetAddress(false));
        System.out.println("getFirstNetworkInteface() = " + NetworkUtility.getFirstNetworkInterface());
        System.out.println("getFirstInetAddress(firstNetworkInteface, true) = " + NetworkUtility.getFirstInetAddress(NetworkUtility.getFirstNetworkInterface(), true));
        System.out.println("getFirstInetAddress(firstNetworkInteface, false) = " + NetworkUtility.getFirstInetAddress(NetworkUtility.getFirstNetworkInterface(), false));
    }

    static {
        InetAddress GET_ADDRESS;
        block20: {
            block19: {
                block18: {
                    block17: {
                        LOG = GMSLogDomain.getLogger("ShoalLogger");
                        GET_ADDRESS = null;
                        try {
                            GET_ADDRESS = InetAddress.getByName(IPV4ANYADDRESS);
                        }
                        catch (Exception ignored) {
                            if (!LOG.isLoggable(Level.FINE)) break block17;
                            LOG.log(Level.FINE, "failed to intialize ANYADDRESSV4. Not fatal", ignored);
                        }
                    }
                    ANYADDRESSV4 = GET_ADDRESS;
                    GET_ADDRESS = null;
                    try {
                        GET_ADDRESS = InetAddress.getByName(IPV6ANYADDRESS);
                    }
                    catch (Exception ignored) {
                        if (!LOG.isLoggable(Level.FINE)) break block18;
                        LOG.log(Level.FINE, "failed to intialize IPV6ANYADDRESS. Not fatal", ignored);
                    }
                }
                ANYADDRESSV6 = GET_ADDRESS;
                ANYADDRESS = ANYADDRESSV4 == null ? ANYADDRESSV6 : ANYADDRESSV4;
                GET_ADDRESS = null;
                try {
                    GET_ADDRESS = InetAddress.getByName(IPV4LOOPBACK);
                }
                catch (Exception ignored) {
                    if (!LOG.isLoggable(Level.FINE)) break block19;
                    LOG.log(Level.FINE, "failed to intialize IPV4LOOPBACK. Not fatal", ignored);
                }
            }
            LOOPBACKV4 = GET_ADDRESS;
            GET_ADDRESS = null;
            try {
                GET_ADDRESS = InetAddress.getByName(IPV6LOOPBACK);
            }
            catch (Exception ignored) {
                if (!LOG.isLoggable(Level.FINE)) break block20;
                LOG.log(Level.FINE, "failed to intialize ANYADDRESSV4. Not fatal", ignored);
            }
        }
        LOOPBACKV6 = GET_ADDRESS;
        InetAddress inetAddress = LOOPBACK = LOOPBACKV4 == null ? LOOPBACKV6 : LOOPBACKV4;
        if (LOOPBACK == null || ANYADDRESS == null) {
            throw new IllegalStateException("failure initializing statics. Neither IPV4 nor IPV6 seem to work");
        }
        isLoopbackMethod = null;
        isUpMethod = null;
        supportsMulticastMethod = null;
        try {
            isLoopbackMethod = NetworkInterface.class.getMethod("isLoopback", new Class[0]);
        }
        catch (Throwable t) {
            isLoopbackMethod = null;
        }
        try {
            isUpMethod = NetworkInterface.class.getMethod("isUp", new Class[0]);
        }
        catch (Throwable t) {
            isUpMethod = null;
        }
        try {
            supportsMulticastMethod = NetworkInterface.class.getMethod("supportsMulticast", new Class[0]);
        }
        catch (Throwable t) {
            supportsMulticastMethod = null;
        }
        try {
            DEPTH_FIELD = ObjectOutputStream.class.getDeclaredField("depth");
            DEPTH_FIELD.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static class DebuggingObjectOutputStream
    extends ObjectOutputStream {
        final List<Object> stack = new ArrayList<Object>();
        boolean broken = false;

        public DebuggingObjectOutputStream(OutputStream out) throws IOException {
            super(out);
            this.enableReplaceObject(true);
        }

        @Override
        protected Object replaceObject(Object o) {
            int currentDepth = this.currentDepth();
            if (o instanceof IOException && currentDepth == 0) {
                this.broken = true;
            }
            if (!this.broken) {
                this.truncate(currentDepth);
                this.stack.add(o);
            }
            return o;
        }

        private void truncate(int depth) {
            while (this.stack.size() > depth) {
                this.pop();
            }
        }

        private Object pop() {
            return this.stack.remove(this.stack.size() - 1);
        }

        private int currentDepth() {
            try {
                Integer oneBased = (Integer)DEPTH_FIELD.get(this);
                return oneBased - 1;
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)e);
            }
        }

        public List<Object> getStack() {
            return this.stack;
        }
    }
}

