/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.universal.collections;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionUtils {
    private static final String EOL = System.getProperty("line.separator");

    private CollectionUtils() {
    }

    public static Map<String, String> propertiesToStringMap(Properties p) {
        HashMap<String, String> map = new HashMap<String, String>();
        Set<Object> names = p.keySet();
        for (Object name : names) {
            if (name == null) continue;
            Object value = p.get(name);
            if (value == null) {
                map.put(name.toString(), null);
                continue;
            }
            map.put(name.toString(), value.toString());
        }
        return map;
    }

    public static String toString(Map<String, String> map) {
        String[] arr = CollectionUtils.toStringArray(map);
        StringBuilder sb = new StringBuilder();
        for (String s : arr) {
            sb.append(s);
            sb.append(EOL);
        }
        return sb.toString();
    }

    public static String toString(String[] arr) {
        StringBuilder sb = new StringBuilder();
        for (String s : arr) {
            sb.append(s);
            sb.append(' ');
        }
        return sb.toString();
    }

    public static String toStringLines(String[] arr) {
        StringBuilder sb = new StringBuilder();
        for (String s : arr) {
            sb.append(s);
            sb.append('\n');
        }
        return sb.toString();
    }

    public static String toString(List<String> list) {
        StringBuilder sb = new StringBuilder();
        for (String s : list) {
            sb.append(s);
            sb.append(' ');
        }
        return sb.toString();
    }

    public static String[] toStringArray(Map<String, String> map) {
        Set<String> set = map.keySet();
        String[] ss = new String[map.size()];
        int i = 0;
        for (String name : set) {
            String value = map.get(name);
            String s = name;
            if (value != null) {
                s = s + "=" + value;
            }
            ss[i++] = s;
        }
        return ss;
    }
}

