/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.component.internal.runlevel;

import com.sun.hk2.component.AbstractInhabitantImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jvnet.hk2.annotations.RunLevel;
import org.jvnet.hk2.component.ComponentException;
import org.jvnet.hk2.component.Inhabitant;
import org.jvnet.hk2.component.InhabitantListener;

class Recorder
implements InhabitantListener {
    private final Logger logger = Logger.getLogger(Recorder.class.getName());
    private final int runLevel;
    private final Stack<Inhabitant<?>> activations = new Stack();
    private final String targetEnv;

    Recorder(int runLevel, String targetEnv) {
        this(new ArrayList(), runLevel, targetEnv);
    }

    Recorder(List<Inhabitant<?>> list, int runLevel) {
        this(new ArrayList(), runLevel, Void.class.getName());
    }

    Recorder(List<Inhabitant<?>> list, int runLevel, String targetEnv) {
        this.activations.addAll(list);
        this.runLevel = runLevel;
        this.targetEnv = targetEnv;
    }

    public int getRunLevel() {
        return this.runLevel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<Inhabitant<?>> getActivations() {
        Stack<Inhabitant<?>> stack = this.activations;
        synchronized (stack) {
            return Collections.unmodifiableList(this.activations);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void push(Inhabitant<?> inhabitant) {
        this.logger.log(Level.FINE, "pushing {0}", inhabitant);
        Stack<Inhabitant<?>> stack = this.activations;
        synchronized (stack) {
            this.activations.add(inhabitant);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Inhabitant<?> pop() {
        Inhabitant<?> inhabitant;
        Stack<Inhabitant<?>> stack = this.activations;
        synchronized (stack) {
            inhabitant = this.activations.isEmpty() ? null : this.activations.pop();
        }
        this.logger.log(Level.FINE, "popping {0}", inhabitant);
        return inhabitant;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "-" + System.identityHashCode(this) + "(" + this.runLevel + ", " + this.activations + ")\n";
    }

    @Override
    public synchronized boolean inhabitantChanged(InhabitantListener.EventType eventType, Inhabitant<?> inhabitant) {
        if (InhabitantListener.EventType.INHABITANT_ACTIVATED == eventType) {
            assert (inhabitant.isInstantiated());
            assert (AbstractInhabitantImpl.class.isInstance(inhabitant));
            RunLevel rl = ((AbstractInhabitantImpl)inhabitant).getAnnotation(RunLevel.class);
            if (null != rl && this.targetEnv.equals(rl.environment().getName())) {
                this.push(inhabitant);
                if (rl.value() > this.runLevel) {
                    throw new ComponentException("Invalid RunLevel dependency to: " + inhabitant);
                }
            }
        }
        return true;
    }
}

