/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import com.sun.grizzly.util.buf.MessageBytes;
import java.io.IOException;
import java.util.logging.Level;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Context;
import org.apache.catalina.HttpRequest;
import org.apache.catalina.Logger;
import org.apache.catalina.Request;
import org.apache.catalina.Response;
import org.apache.catalina.connector.ClientAbortException;
import org.apache.catalina.connector.RequestFacade;
import org.apache.catalina.core.ApplicationFilterChain;
import org.apache.catalina.core.ApplicationFilterFactory;
import org.apache.catalina.core.StandardWrapper;
import org.apache.catalina.util.StringManager;
import org.apache.catalina.valves.ValveBase;

final class StandardWrapperValve
extends ValveBase {
    private static final java.util.logging.Logger log = java.util.logging.Logger.getLogger(StandardWrapperValve.class.getName());
    private static final StringManager sm = StringManager.getManager("org.apache.catalina.core");

    StandardWrapperValve() {
    }

    public int invoke(Request request, Response response) throws IOException, ServletException {
        block41: {
            StandardWrapper wrapper;
            Servlet servlet;
            Throwable throwable;
            block40: {
                block39: {
                    boolean unavailable = false;
                    throwable = null;
                    servlet = null;
                    wrapper = (StandardWrapper)this.getContainer();
                    Context context = (Context)wrapper.getParent();
                    HttpRequest hrequest = (HttpRequest)request;
                    RequestFacade hreq = (RequestFacade)request.getRequest(true);
                    HttpServletResponse hres = (HttpServletResponse)response.getResponse();
                    if (!context.getAvailable()) {
                        hres.sendError(503);
                        response.setDetailMessage(sm.getString("standardContext.isUnavailable"));
                        unavailable = true;
                    }
                    if (!unavailable && wrapper.isUnavailable()) {
                        this.log(sm.getString("standardWrapper.isUnavailable", wrapper.getName()));
                        if (hres != null) {
                            long available = wrapper.getAvailable();
                            if (available > 0L && available < Long.MAX_VALUE) {
                                hres.setDateHeader("Retry-After", available);
                                hres.sendError(503);
                                response.setDetailMessage(sm.getString("standardWrapper.isUnavailable", wrapper.getName()));
                            } else if (available == Long.MAX_VALUE) {
                                hres.sendError(404);
                                response.setDetailMessage(sm.getString("standardWrapper.notFound", wrapper.getName()));
                            }
                        }
                        unavailable = true;
                    }
                    try {
                        if (!unavailable) {
                            servlet = wrapper.allocate();
                        }
                    }
                    catch (UnavailableException e) {
                        if (e.isPermanent()) {
                            hres.sendError(404);
                            response.setDetailMessage(sm.getString("standardWrapper.notFound", wrapper.getName()));
                        } else {
                            hres.setDateHeader("Retry-After", e.getUnavailableSeconds());
                            hres.sendError(503);
                            response.setDetailMessage(sm.getString("standardWrapper.isUnavailable", wrapper.getName()));
                        }
                    }
                    catch (ServletException e) {
                        this.log(sm.getString("standardWrapper.allocateException", wrapper.getName()), StandardWrapper.getRootCause(e));
                        throwable = e;
                        this.exception(request, response, e);
                        servlet = null;
                    }
                    catch (Throwable e) {
                        this.log(sm.getString("standardWrapper.allocateException", wrapper.getName()), e);
                        throwable = e;
                        this.exception(request, response, e);
                        servlet = null;
                    }
                    try {
                        response.sendAcknowledgement();
                    }
                    catch (IOException e) {
                        this.log(sm.getString("standardWrapper.acknowledgeException", wrapper.getName()), e);
                        throwable = e;
                        this.exception(request, response, e);
                    }
                    catch (Throwable e) {
                        this.log(sm.getString("standardWrapper.acknowledgeException", wrapper.getName()), e);
                        throwable = e;
                        this.exception(request, response, e);
                        servlet = null;
                    }
                    MessageBytes requestPathMB = hrequest.getRequestPathMB();
                    hreq.setAttribute("org.apache.catalina.core.DISPATCHER_REQUEST_PATH", requestPathMB);
                    ApplicationFilterFactory factory = ApplicationFilterFactory.getInstance();
                    ApplicationFilterChain filterChain = factory.createFilterChain((ServletRequest)((Object)request), wrapper, servlet);
                    try {
                        String jspFile = wrapper.getJspFile();
                        if (jspFile != null) {
                            hreq.setAttribute("org.apache.catalina.jsp_file", jspFile);
                        }
                        if (servlet != null) {
                            if (filterChain != null) {
                                filterChain.setRequestFacade(hreq);
                                filterChain.setWrapper(wrapper);
                                filterChain.doFilter(hreq, hres);
                            } else {
                                wrapper.service(hreq, hres, servlet, hreq);
                            }
                        }
                    }
                    catch (ClientAbortException e) {
                        throwable = e;
                        this.exception(request, response, e);
                    }
                    catch (IOException e) {
                        this.log(sm.getString("standardWrapper.serviceException", wrapper.getName()), e);
                        throwable = e;
                        this.exception(request, response, e);
                    }
                    catch (UnavailableException e) {
                        this.log(sm.getString("standardWrapper.serviceException", wrapper.getName()), e);
                        wrapper.unavailable(e);
                        long available = wrapper.getAvailable();
                        if (available > 0L && available < Long.MAX_VALUE) {
                            hres.setDateHeader("Retry-After", available);
                            hres.sendError(503);
                            response.setDetailMessage(sm.getString("standardWrapper.isUnavailable", wrapper.getName()));
                        } else if (available == Long.MAX_VALUE) {
                            hres.sendError(404);
                            response.setDetailMessage(sm.getString("standardWrapper.notFound", wrapper.getName()));
                        }
                    }
                    catch (ServletException e) {
                        Throwable rootCause = StandardWrapper.getRootCause(e);
                        if (!(rootCause instanceof ClientAbortException)) {
                            this.log(sm.getString("standardWrapper.serviceException", wrapper.getName()), rootCause);
                        }
                        throwable = e;
                        this.exception(request, response, e);
                    }
                    catch (Throwable e) {
                        this.log(sm.getString("standardWrapper.serviceException", wrapper.getName()), e);
                        throwable = e;
                        this.exception(request, response, e);
                    }
                    try {
                        if (filterChain != null) {
                            filterChain.release();
                        }
                    }
                    catch (Throwable e) {
                        this.log(sm.getString("standardWrapper.releaseFilters", wrapper.getName()), e);
                        if (throwable != null) break block39;
                        throwable = e;
                        this.exception(request, response, e);
                    }
                }
                try {
                    if (servlet != null) {
                        wrapper.deallocate(servlet);
                    }
                }
                catch (Throwable e) {
                    this.log(sm.getString("standardWrapper.deallocateException", wrapper.getName()), e);
                    if (throwable != null) break block40;
                    throwable = e;
                    this.exception(request, response, e);
                }
            }
            try {
                if (servlet != null && wrapper.getAvailable() == Long.MAX_VALUE) {
                    wrapper.unload();
                }
            }
            catch (Throwable e) {
                this.log(sm.getString("standardWrapper.unloadException", wrapper.getName()), e);
                if (throwable != null) break block41;
                throwable = e;
                this.exception(request, response, e);
            }
        }
        return 2;
    }

    public void invoke(org.apache.catalina.connector.Request request, org.apache.catalina.connector.Response response) throws IOException, ServletException {
        this.invoke((Request)request, (Response)response);
    }

    private void log(String message) {
        Logger logger = null;
        String containerName = null;
        if (this.container != null) {
            logger = this.container.getLogger();
            containerName = this.container.getName();
        }
        if (logger != null) {
            logger.log("StandardWrapperValve[" + containerName + "]: " + message);
        } else if (log.isLoggable(Level.INFO)) {
            log.info("StandardWrapperValve[" + containerName + "]: " + message);
        }
    }

    private void log(String message, Throwable t) {
        Logger logger = null;
        String containerName = null;
        if (this.container != null) {
            logger = this.container.getLogger();
            containerName = this.container.getName();
        }
        if (logger != null) {
            logger.log("StandardWrapperValve[" + containerName + "]: " + message, t, 2);
        } else {
            log.log(Level.WARNING, "StandardWrapperValve[" + containerName + "]: " + message, t);
        }
    }

    private void exception(Request request, Response response, Throwable exception) {
        ServletRequest sreq = request.getRequest();
        sreq.setAttribute("javax.servlet.error.exception", exception);
        ServletResponse sresponse = response.getResponse();
        ((HttpServletResponse)sresponse).setStatus(500);
    }

    public ObjectName createObjectName(String domain, ObjectName parent) throws MalformedObjectNameException {
        return null;
    }
}

