/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.osgiweb;

import java.util.HashMap;
import org.glassfish.osgijavaeebase.AbstractOSGiDeployer;
import org.glassfish.osgiweb.ContextPathCollisionException;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;

class WABEventPublisher {
    WABEventPublisher() {
    }

    void raiseEvent(AbstractOSGiDeployer.State state, Bundle appBundle, Bundle extenderBundle, Throwable e) {
        Event event = this.prepareEvent(state, appBundle, extenderBundle, e);
        if (event != null) {
            this.postEvent(event, extenderBundle.getBundleContext());
        }
    }

    private Event prepareEvent(AbstractOSGiDeployer.State state, Bundle appBundle, Bundle extenderBundle, Throwable e) {
        String topic;
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("bundle.symbolicName", appBundle.getHeaders().get("Bundle-SymbolicName"));
        props.put("bundle.id", appBundle.getBundleId());
        props.put("bundle.version", appBundle.getHeaders().get("Bundle-Version"));
        props.put("context.path", appBundle.getHeaders().get("Web-ContextPath"));
        props.put("timestamp", System.currentTimeMillis());
        props.put("bundle", appBundle);
        props.put("extender.bundle", extenderBundle);
        props.put("extender.bundle.id", extenderBundle.getBundleId());
        props.put("extender.bundle.symbolicName", extenderBundle.getHeaders().get("Bundle-SymbolicName"));
        props.put("extender.bundle.version", extenderBundle.getHeaders().get("Bundle-Version"));
        switch (state) {
            case DEPLOYING: {
                topic = "org/osgi/service/web/DEPLOYING";
                break;
            }
            case DEPLOYED: {
                topic = "org/osgi/service/web/DEPLOYED";
                break;
            }
            case FAILED: {
                topic = "org/osgi/service/web/FAILED";
                props.put("exception", e);
                if (!(e instanceof ContextPathCollisionException)) break;
                ContextPathCollisionException ce = (ContextPathCollisionException)ContextPathCollisionException.class.cast(e);
                Long[] ids = ce.getExistingWabIds();
                props.put("collision.bundles", ids);
                break;
            }
            case UNDEPLOYING: {
                topic = "org/osgi/service/web/UNDEPLOYING";
                break;
            }
            case UNDEPLOYED: {
                topic = "org/osgi/service/web/UNDEPLOYED";
                break;
            }
            default: {
                return null;
            }
        }
        Event event = new Event(topic, props);
        return event;
    }

    private void postEvent(Event event, BundleContext bc) {
        ServiceReference ref = (ServiceReference)ServiceReference.class.cast(bc.getServiceReference(EventAdmin.class.getName()));
        if (ref != null) {
            EventAdmin ea = (EventAdmin)bc.getService(ref);
            if (ea != null) {
                ea.postEvent(event);
            }
            bc.ungetService(ref);
        }
    }
}

