/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admingui.common.handlers;

import com.sun.jsftemplating.layout.LayoutDefinitionManager;
import com.sun.jsftemplating.layout.ViewRootUtil;
import com.sun.jsftemplating.layout.descriptors.LayoutElement;
import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import com.sun.jsftemplating.layout.descriptors.handler.HandlerDefinition;
import com.sun.jsftemplating.util.FileUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import javax.faces.component.UIViewRoot;
import org.glassfish.admingui.common.util.GuiUtil;
import org.glassfish.admingui.common.util.JSONUtil;
import org.glassfish.admingui.common.util.RestUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UtilHandlers {
    private static final String PATH_SEPARATOR = "${path.separator}";

    public static void calendarAdd(HandlerContext handlerCtx) {
        int field = (Integer)handlerCtx.getInputValue("Field");
        int amount = (Integer)handlerCtx.getInputValue("Amount");
        GregorianCalendar cal = new GregorianCalendar();
        cal.add(field, amount);
        handlerCtx.setOutputValue("Date", (Object)cal.getTime());
    }

    public static void getFile(HandlerContext handlerCtx) {
        String pathname = (String)handlerCtx.getInputValue("Pathname");
        handlerCtx.setOutputValue("File", (Object)(pathname != null ? new File(pathname) : null));
    }

    public static void serveResource(HandlerContext ctx) throws IOException {
        URL url;
        String path = (String)ctx.getInputValue("path");
        int idx = path.lastIndexOf("://");
        String port = null;
        if (idx != -1 && (idx = (path = path.substring(idx + 3)).indexOf(58)) != -1 && (idx = (path = path.substring(idx + 1)).indexOf(47)) != -1) {
            port = path.substring(0, idx);
            path = path.substring(idx);
        }
        if ((url = FileUtil.searchForFile((String)path, null)) == null && port != null) {
            path = "http://localhost:" + port + path;
            try {
                url = new URL(path);
            }
            catch (MalformedURLException ex) {
                url = null;
            }
        }
        String content = "";
        if (url != null) {
            try {
                content = new String(FileUtil.readFromURL((URL)url));
            }
            catch (FileNotFoundException fnfe) {
                // empty catch block
            }
        }
        ctx.setOutputValue("content", (Object)content);
    }

    public static void fileGetName(HandlerContext handlerCtx) {
        File file = (File)handlerCtx.getInputValue("File");
        handlerCtx.setOutputValue("Name", (Object)(file == null ? "" : file.getName()));
    }

    public static void mapGet(HandlerContext handlerCtx) {
        Map map = (Map)handlerCtx.getInputValue("Map");
        Object key = handlerCtx.getInputValue("Key");
        handlerCtx.setOutputValue("Value", map.get(key));
    }

    public static void mapJoin(HandlerContext handlerCtx) {
        Map map = (Map)handlerCtx.getInputValue("map");
        String sep = (String)handlerCtx.getInputValue("sep");
        Boolean skipBlankValues = (Boolean)handlerCtx.getInputValue("skipBlankValues");
        String sepHolder = "";
        assert (map != null);
        StringBuilder result = new StringBuilder();
        for (Map.Entry entry : map.entrySet()) {
            Object value = entry.getValue();
            if (skipBlankValues.booleanValue() && (value == null || value.toString().isEmpty())) continue;
            result.append(sepHolder).append(entry.getKey()).append("=").append(entry.getValue());
            sepHolder = sep;
        }
        handlerCtx.setOutputValue("result", (Object)result.toString());
    }

    public static void mapValueNullToFalse(HandlerContext handlerCtx) {
        Map map = (Map)handlerCtx.getInputValue("map");
        List keys = (List)handlerCtx.getInputValue("keys");
        HashMap<String, String> result = new HashMap<String, String>(map);
        for (String key : keys) {
            if (map.get(key) != null) continue;
            result.put(key, "false");
        }
        handlerCtx.setOutputValue("result", result);
    }

    public static void getMapKeys(HandlerContext handlerCtx) {
        HashMap map = (HashMap)handlerCtx.getInputValue("Map");
        ArrayList keyList = new ArrayList();
        if (map == null) {
            map = new HashMap();
        }
        keyList.addAll(map.keySet());
        handlerCtx.setOutputValue("Keys", keyList);
    }

    public static void listAdd(HandlerContext handlerCtx) {
        ArrayList<Object> list = (ArrayList<Object>)handlerCtx.getInputValue("list");
        Integer index = (Integer)handlerCtx.getInputValue("index");
        if (list == null) {
            list = new ArrayList<Object>();
        }
        if (index == null) {
            list.add(handlerCtx.getInputValue("value"));
        } else {
            list.add(index, handlerCtx.getInputValue("value"));
        }
        handlerCtx.setOutputValue("result", list);
    }

    public static void listRemove(HandlerContext handlerCtx) {
        ArrayList list = (ArrayList)handlerCtx.getInputValue("list");
        if (list == null) {
            list = new ArrayList();
        }
        list.remove(handlerCtx.getInputValue("value"));
        handlerCtx.setOutputValue("result", list);
    }

    public static void listSort(HandlerContext handlerCtx) {
        List list = (List)handlerCtx.getInputValue("list");
        Collections.sort(list);
    }

    public static void listCombine(HandlerContext handlerCtx) {
        ArrayList list = (ArrayList)handlerCtx.getInputValue("list");
        List list2 = (List)handlerCtx.getInputValue("list2");
        if (list == null) {
            list = new ArrayList();
        }
        if (list2 != null) {
            for (Object one : list2) {
                list.add(one);
            }
        }
        handlerCtx.setOutputValue("result", list);
    }

    public static void containedIn(HandlerContext handlerCtx) {
        List list = (List)handlerCtx.getInputValue("list");
        boolean contain = list == null ? false : list.contains(handlerCtx.getInputValue("testStr"));
        handlerCtx.setOutputValue("contain", (Object)contain);
    }

    public static void compare(HandlerContext handlerCtx) {
        boolean ret = false;
        Object obj1 = handlerCtx.getInputValue("obj1");
        Object obj2 = handlerCtx.getInputValue("obj2");
        if (obj1 != null) {
            ret = obj1.equals(obj2);
        } else if (obj2 == null) {
            ret = true;
        }
        handlerCtx.setOutputValue("objEqual", (Object)ret);
    }

    public static void prepareSuccessful(HandlerContext handlerCtx) {
        GuiUtil.prepareSuccessful(handlerCtx);
    }

    public static void prepareAlertMsg(HandlerContext handlerCtx) {
        String summary = (String)handlerCtx.getInputValue("summary");
        String type = (String)handlerCtx.getInputValue("type");
        String detail = (String)handlerCtx.getInputValue("detail");
        GuiUtil.prepareAlert(type, summary, detail);
    }

    public static void startsWith(HandlerContext handlerCtx) {
        String testStr = (String)handlerCtx.getInputValue("testStr");
        String pattern = (String)handlerCtx.getInputValue("pattern");
        handlerCtx.setOutputValue("result", (Object)testStr.startsWith(pattern));
    }

    public static void decodeString(HandlerContext handlerCtx) {
        block4: {
            String str = (String)handlerCtx.getInputValue("str");
            String scheme = (String)handlerCtx.getInputValue("scheme");
            if (GuiUtil.isEmpty(str)) {
                handlerCtx.setOutputValue("output", (Object)"");
                return;
            }
            if (GuiUtil.isEmpty(scheme)) {
                scheme = "UTF-8";
            }
            try {
                String output = URLDecoder.decode(str, scheme);
                handlerCtx.setOutputValue("output", (Object)output);
            }
            catch (UnsupportedEncodingException ex) {
                handlerCtx.setOutputValue("output", (Object)str);
                GuiUtil.getLogger().info(GuiUtil.getCommonMessage("log.error.decodeString") + ex.getLocalizedMessage());
                if (!GuiUtil.getLogger().isLoggable(Level.FINE)) break block4;
                ex.printStackTrace();
            }
        }
    }

    public static void roundTo2DecimalPoint(HandlerContext handlerCtx) {
        block2: {
            DecimalFormat df = new DecimalFormat();
            df.setMaximumFractionDigits(2);
            try {
                Double input = (Double)handlerCtx.getInputValue("input");
                String output = input == null ? "" : df.format(input);
                handlerCtx.setOutputValue("output", (Object)output);
            }
            catch (Exception ex) {
                handlerCtx.setOutputValue("output", (Object)"");
                GuiUtil.getLogger().info(GuiUtil.getCommonMessage("log.error.roundTo2DecimalPoint") + ex.getLocalizedMessage());
                if (!GuiUtil.getLogger().isLoggable(Level.FINE)) break block2;
                ex.printStackTrace();
            }
        }
    }

    public static void addEmptyFirstElement(HandlerContext handlerCtx) {
        List in = (List)handlerCtx.getInputValue("in");
        ArrayList<String> ar = null;
        ar = in == null ? new ArrayList<String>() : new ArrayList(in);
        ar.add(0, "");
        handlerCtx.setOutputValue("out", ar);
    }

    public static void getListBoxOptions(HandlerContext handlerCtx) {
        String selectedCommaString = (String)handlerCtx.getInputValue("selectedCommaString");
        ArrayList<String> availableList = (ArrayList<String>)handlerCtx.getInputValue("availableList");
        String addEmptyFirstChoice = (String)handlerCtx.getInputValue("addEmptyFirstChoice");
        String[] selectedOptions = null;
        if (addEmptyFirstChoice != null) {
            if (availableList == null) {
                availableList = new ArrayList<String>();
            }
            availableList.add(0, "");
        }
        if (availableList != null && availableList.size() > 0 && (selectedOptions = GuiUtil.stringToArray(selectedCommaString, ",")) != null && selectedOptions.length <= 0) {
            selectedOptions = new String[]{(String)availableList.get(0)};
        }
        handlerCtx.setOutputValue("availableListResult", availableList);
        handlerCtx.setOutputValue("selectedOptions", (Object)selectedOptions);
    }

    public static void convertArrayToCommaString(HandlerContext handlerCtx) {
        String[] array = (String[])handlerCtx.getInputValue("array");
        String commaString = "";
        if (array != null && array.length > 0) {
            commaString = GuiUtil.arrayToString(array, ",");
        }
        handlerCtx.setOutputValue("commaString", (Object)commaString);
    }

    public static void convertListToCommaString(HandlerContext handlerCtx) {
        List list = (List)handlerCtx.getInputValue("list");
        String commaString = "";
        if (list != null && list.size() > 0) {
            commaString = GuiUtil.listToString(list, ",");
        }
        handlerCtx.setOutputValue("commaString", (Object)commaString);
    }

    public static void resolveTokens(HandlerContext handlerCtx) {
        List tokens = (List)handlerCtx.getInputValue("tokens");
        ArrayList<String> resolvedTokens = new ArrayList<String>();
        String endPoint = (String)handlerCtx.getInputValue("endPoint");
        for (String token : tokens) {
            resolvedTokens.add(RestUtil.resolveToken(endPoint, token));
        }
        handlerCtx.setOutputValue("resolvedTokens", resolvedTokens);
    }

    public static void convertListToArray(HandlerContext handlerCtx) {
        List list = (List)handlerCtx.getInputValue("list");
        handlerCtx.setOutputValue("array", (Object)list.toArray(new String[list.size()]));
    }

    public static void convertStringtoListHandler(HandlerContext handlerCtx) {
        List<String> result = UtilHandlers.convertStringToList((String)handlerCtx.getInputValue("str"), (String)handlerCtx.getInputValue("delimiter"));
        handlerCtx.setOutputValue("result", result);
    }

    private static List<String> convertStringToList(String str, String delimiter) {
        ArrayList<String> result = new ArrayList<String>();
        if (str != null) {
            if (delimiter == null) {
                delimiter = ",";
            }
            StringTokenizer tokens = new StringTokenizer(str, delimiter);
            while (tokens.hasMoreTokens()) {
                String token = tokens.nextToken().trim();
                result.add(token);
            }
        }
        return result;
    }

    public static void convertStringToMap(HandlerContext handlerCtx) {
        HashMap<String, String> output = new HashMap<String, String>();
        List<String> list = UtilHandlers.convertStringToList((String)handlerCtx.getInputValue("str"), (String)handlerCtx.getInputValue("delimiter"));
        for (String item : list) {
            String[] parts = item.split("=");
            String key = parts[0];
            String value = "";
            if (parts.length > 1) {
                value = parts[1];
            }
            output.put(key, value);
        }
        handlerCtx.setOutputValue("result", output);
    }

    public static void formatStringsforDisplay(HandlerContext handlerCtx) {
        String values = (String)handlerCtx.getInputValue("string");
        if (values == null || GuiUtil.isEmpty(values.trim())) {
            handlerCtx.setOutputValue("formattedString", (Object)"");
        } else {
            String s1 = values.trim().replaceAll("\\.jar:", "\\.jar\\$\\{path.separator\\}");
            String s2 = s1.replaceAll("\\.jar;", "\\.jar\\$\\{path.separator\\}");
            String[] strArray = s2.split("\\$\\{path.separator\\}");
            StringBuilder result = new StringBuilder("");
            for (String s : strArray) {
                result.append(s).append("\n");
            }
            handlerCtx.setOutputValue("formattedString", (Object)result.toString().trim());
        }
    }

    public static void formatPathSeperatorStringsforSaving(HandlerContext handlerCtx) {
        String values = (String)handlerCtx.getInputValue("string");
        StringBuilder token = new StringBuilder("");
        String sep = "";
        if (values != null && values.trim().length() != 0) {
            List strList = GuiUtil.parseStringList(values, "\t\n\r\f");
            for (String nextToken : strList) {
                token.append(sep).append(nextToken);
                sep = PATH_SEPARATOR;
            }
        }
        handlerCtx.setOutputValue("formattedString", (Object)token.toString());
    }

    public static void addHandler(HandlerContext handlerCtx) {
        String id = (String)handlerCtx.getInputValue("id");
        String desc = (String)handlerCtx.getInputValue("desc");
        String cls = (String)handlerCtx.getInputValue("class");
        String meth = (String)handlerCtx.getInputValue("method");
        HandlerDefinition def = new HandlerDefinition(id);
        def.setHandlerMethod(cls, meth);
        if (desc != null) {
            def.setDescription(desc);
        }
        LayoutDefinitionManager.addGlobalHandlerDefinition((HandlerDefinition)def);
    }

    public static boolean forLoop(HandlerContext handlerCtx) {
        String startInt = (String)handlerCtx.getInputValue("start");
        int start = startInt == null ? 0 : Integer.parseInt(startInt);
        int end = (Integer)handlerCtx.getInputValue("end");
        String varName = (String)handlerCtx.getInputValue("varName");
        List handlers = handlerCtx.getHandler().getChildHandlers();
        if (handlers.size() > 0) {
            LayoutElement elt = handlerCtx.getLayoutElement();
            Map<String, Object> requestMap = handlerCtx.getFacesContext().getExternalContext().getRequestMap();
            for (int ix = start; ix <= end; ++ix) {
                requestMap.put(varName, ix);
                elt.dispatchHandlers(handlerCtx, handlers);
            }
        }
        return false;
    }

    public static boolean foreach(HandlerContext handlerCtx) {
        String var = (String)handlerCtx.getInputValue("var");
        Collection list = (Collection)handlerCtx.getInputValue("list");
        List handlers = handlerCtx.getHandler().getChildHandlers();
        if (handlers.size() > 0) {
            LayoutElement elt = handlerCtx.getLayoutElement();
            Map<String, Object> requestMap = handlerCtx.getFacesContext().getExternalContext().getRequestMap();
            if (list != null) {
                for (Object obj : list) {
                    requestMap.put(var, obj);
                    elt.dispatchHandlers(handlerCtx, handlers);
                }
            }
        }
        return false;
    }

    public static void mapEntrySet(HandlerContext handlerCtx) {
        Map map = (Map)handlerCtx.getInputValue("map");
        handlerCtx.setOutputValue("set", map.entrySet());
    }

    public static void mapValues(HandlerContext handlerCtx) {
        Map map = (Map)handlerCtx.getInputValue("map");
        Collection xx = map.values();
        handlerCtx.setOutputValue("values", xx);
    }

    public static void convertStrToBoolean(HandlerContext handlerCtx) {
        String str = (String)handlerCtx.getInputValue("str");
        handlerCtx.setOutputValue("out", (Object)"true".equals(str));
    }

    public static void createDefaultViewRoot(HandlerContext handlerCtx) {
        UIViewRoot oldVR = handlerCtx.getFacesContext().getViewRoot();
        UIViewRoot newVR = new UIViewRoot();
        newVR.setViewId(oldVR.getViewId());
        ViewRootUtil.setLayoutDefinitionKey((UIViewRoot)newVR, (String)ViewRootUtil.getLayoutDefinitionKey((UIViewRoot)oldVR));
        newVR.setLocale(oldVR.getLocale());
        newVR.setRenderKitId(oldVR.getRenderKitId());
        handlerCtx.setOutputValue("viewRoot", (Object)newVR);
    }

    public static void encodeId(HandlerContext handlerCtx) {
        String id = (String)handlerCtx.getInputValue("id");
        handlerCtx.setOutputValue("result", (Object)GuiUtil.genId(id));
    }

    public static void javaToJSON(HandlerContext handlerCtx) {
        Object obj = handlerCtx.getInputValue("obj");
        int depth = (Integer)handlerCtx.getInputValue("depth");
        handlerCtx.setOutputValue("json", (Object)JSONUtil.javaToJSON(obj, depth));
    }

    public static void createPropertyString(HandlerContext handlerCtx) {
        StringBuilder sb = new StringBuilder();
        String sep = "";
        List properties = (List)handlerCtx.getInputValue("properties");
        for (Map property : properties) {
            sb.append(sep).append((String)property.get("name")).append("=").append(UtilHandlers.escapePropertyValue((String)property.get("value")));
            sep = ":";
        }
        handlerCtx.setOutputValue("string", (Object)sb.toString());
    }

    public static String escapePropertyValue(String value) {
        String[] chars;
        for (String c : chars = new String[]{":"}) {
            value = value.replaceAll(c, "\\\\" + c);
        }
        return value;
    }
}

