/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admingui.common.util;

import com.sun.enterprise.config.serverbeans.SecureAdmin;
import com.sun.enterprise.security.SecurityServicesUtil;
import com.sun.enterprise.security.ssl.SSLUtils;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.client.urlconnection.HTTPSProperties;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.context.FacesContext;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.MultivaluedMap;
import javax.xml.parsers.ParserConfigurationException;
import org.glassfish.admingui.common.util.GuiUtil;
import org.glassfish.admingui.common.util.MiscUtil;
import org.glassfish.admingui.common.util.RestResponse;
import org.glassfish.api.ActionReport;
import org.jvnet.hk2.component.Habitat;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RestUtil {
    public static final String FORM_ENCODING = "application/x-www-form-urlencoded";
    public static final String RESPONSE_TYPE = "application/json";
    public static final String GUI_TOKEN_FOR_EMPTY_PROPERTY_VALUE = "()";
    public static final Client JERSEY_CLIENT = Client.create();
    private static final String REST_TOKEN_COOKIE = "gfresttoken";

    public static String getPropValue(String endpoint, String propName, HandlerContext handlerCtx) {
        Map<String, Object> responseMap = RestUtil.restRequest(endpoint + "/property.json", null, "GET", handlerCtx, false);
        Map extraPropertiesMap = (Map)((Map)responseMap.get("data")).get("extraProperties");
        if (extraPropertiesMap != null) {
            List props = (List)extraPropertiesMap.get("properties");
            for (Map oneProp : props) {
                if (!oneProp.get("name").equals(propName)) continue;
                return (String)oneProp.get("value");
            }
        }
        return "";
    }

    public static String resolveToken(String endpoint, String token) {
        String tokenStartMarker = "${";
        String tokenEndMarker = "}";
        if (!token.trim().startsWith(tokenStartMarker)) {
            return token;
        }
        int start = token.indexOf(tokenStartMarker);
        if (start < 0) {
            return token;
        }
        int end = token.lastIndexOf(tokenEndMarker);
        if (end < 0) {
            return token;
        }
        HashMap<String, Object> attrMap = new HashMap<String, Object>();
        String str = token.substring(start + tokenStartMarker.length(), end - tokenEndMarker.length() + 1);
        attrMap.put("tokens", str);
        try {
            Map<String, Object> result = RestUtil.restRequest(endpoint + "/resolve-tokens.json", attrMap, "GET", null, true);
            return (String)GuiUtil.getMapValue(result, "data,extraProperties,tokens," + str);
        }
        catch (Exception ex) {
            GuiUtil.getLogger().info(ex.getMessage());
            return token;
        }
    }

    public static Map<String, Object> restRequest(String endpoint, Map<String, Object> attrs, String method, HandlerContext handlerCtx, boolean quiet) {
        return RestUtil.restRequest(endpoint, attrs, method, handlerCtx, quiet, true);
    }

    public static Map<String, Object> restRequest(String endpoint, Map<String, Object> attrs, String method, HandlerContext handlerCtx, boolean quiet, boolean throwException) {
        boolean useData = false;
        Object data = null;
        if (attrs == null) {
            try {
                data = handlerCtx == null ? null : handlerCtx.getInputValue("data");
            }
            catch (Exception e) {
                // empty catch block
            }
            if (data != null) {
                useData = true;
            } else {
                attrs = new HashMap<String, Object>();
            }
        }
        method = method.toLowerCase(GuiUtil.guiLocale);
        Logger logger = GuiUtil.getLogger();
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, GuiUtil.getCommonMessage("LOG_REST_REQUEST_INFO", new Object[]{endpoint, useData && "post".equals(method) ? data : attrs, method}));
        }
        RestResponse response = null;
        if ("post".equals(method)) {
            response = useData ? RestUtil.post(endpoint, data, (String)handlerCtx.getInputValue("contentType")) : RestUtil.post(endpoint, attrs);
        } else if ("put".equals(method)) {
            response = RestUtil.put(endpoint, attrs);
        } else if ("get".equals(method)) {
            response = RestUtil.get(endpoint, attrs);
        } else if ("delete".equals(method)) {
            response = RestUtil.delete(endpoint, attrs);
        }
        return RestUtil.parseResponse(response, handlerCtx, endpoint, useData && "post".equals(method) ? data : attrs, quiet, throwException);
    }

    public static Map<String, String> buildDefaultValueMap(String endpoint) throws ParserConfigurationException, SAXException, IOException {
        HashMap<String, String> defaultValues = new HashMap<String, String>();
        RestResponse response = RestUtil.options(endpoint, RESPONSE_TYPE);
        Map data = (Map)response.getResponse().get("data");
        List methods = null;
        Map extraProperties = (Map)data.get("extraProperties");
        methods = (List)extraProperties.get("methods");
        for (Map method : methods) {
            Map messageParameters;
            if (!"POST".equals(method.get("name")) || (messageParameters = (Map)method.get("messageParameters")) == null) continue;
            for (Map.Entry entry : messageParameters.entrySet()) {
                String param = (String)entry.getKey();
                String defaultValue = (String)((Map)entry.getValue()).get("defaultValue");
                if ("".equals(defaultValue) || defaultValue == null) continue;
                defaultValues.put(param, defaultValue);
            }
        }
        return defaultValues;
    }

    public static Map getAttributesMap(String endpoint) {
        RestResponse response = RestUtil.get(endpoint);
        if (!response.isSuccess()) {
            return new HashMap();
        }
        return RestUtil.getEntityAttrs(endpoint, "entity");
    }

    public static Map<String, Object> getEntityAttrs(String endpoint, String key) {
        Map<String, Object> valueMap = new HashMap<String, Object>();
        try {
            Map<String, Object> result = RestUtil.restRequest(endpoint, null, "get", null, false);
            int responseCode = (Integer)result.get("responseCode");
            if (responseCode < 200 || responseCode > 299) {
                throw new RuntimeException((String)result.get("responseBody"));
            }
            Map data = (Map)result.get("data");
            Map extraProperties = (Map)data.get("extraProperties");
            if (extraProperties.containsKey(key)) {
                valueMap = (Map)extraProperties.get(key);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        return valueMap;
    }

    private static String getMessage(Map aMap) {
        String message = "";
        if (aMap != null) {
            message = (String)aMap.get("message");
        }
        return message == null ? "" : message;
    }

    public static Map<String, Object> parseResponse(RestResponse response, HandlerContext handlerCtx, String endpoint, Object attrs, boolean quiet, boolean throwException) {
        String message = "";
        ActionReport.ExitCode exitCode = ActionReport.ExitCode.FAILURE;
        if (response != null) {
            try {
                int status = response.getResponseCode();
                Map<String, Object> responseMap = response.getResponse();
                if (responseMap.get("data") != null) {
                    String exitCodeStr = (String)((Map)responseMap.get("data")).get("exit_code");
                    ActionReport.ExitCode exitCode2 = exitCode = exitCodeStr != null ? ActionReport.ExitCode.valueOf((String)exitCodeStr) : ActionReport.ExitCode.SUCCESS;
                }
                if (exitCode != ActionReport.ExitCode.SUCCESS) {
                    Map dataMap = (Map)responseMap.get("data");
                    if (dataMap != null) {
                        message = RestUtil.getMessage(dataMap);
                        List subReports = (List)dataMap.get("subReports");
                        if (subReports != null) {
                            StringBuilder sb = new StringBuilder("");
                            for (Map oneSubReport : subReports) {
                                sb.append(" ").append(RestUtil.getMessage(oneSubReport));
                            }
                            message = message + sb.toString();
                        }
                    } else {
                        Object msgs = responseMap.get("message");
                        if (msgs == null) {
                            message = "REST Request '" + endpoint + "' failed with response code '" + status + "'.";
                        } else if (msgs instanceof List) {
                            StringBuilder builder = new StringBuilder("");
                            for (Object obj : (List)msgs) {
                                if (obj instanceof Map && ((Map)obj).containsKey("message")) {
                                    obj = ((Map)obj).get("message");
                                }
                                builder.append(obj.toString());
                            }
                            message = builder.toString();
                        } else if (msgs instanceof Map) {
                            message = ((Map)msgs).get("message").toString();
                        } else {
                            throw new RuntimeException("Unexpected message type.");
                        }
                    }
                }
                switch (exitCode) {
                    case FAILURE: {
                        if (throwException) {
                            if (handlerCtx != null) {
                                GuiUtil.handleError(handlerCtx, message);
                                if (!quiet) {
                                    GuiUtil.getLogger().severe(GuiUtil.getCommonMessage("LOG_REQUEST_RESULT", new Object[]{exitCode, endpoint, attrs}));
                                    GuiUtil.getLogger().finest("response.getResponseBody(): " + response.getResponseBody());
                                }
                                return new HashMap<String, Object>();
                            }
                            throw new RuntimeException(message);
                        }
                        if (!quiet) {
                            GuiUtil.getLogger().severe(GuiUtil.getCommonMessage("LOG_REQUEST_RESULT", new Object[]{exitCode, endpoint, attrs}));
                            GuiUtil.getLogger().finest("response.getResponseBody(): " + response.getResponseBody());
                        }
                        return responseMap;
                    }
                    case WARNING: {
                        GuiUtil.prepareAlert("warning", GuiUtil.getCommonMessage("msg.command.warning"), message);
                        GuiUtil.getLogger().warning(GuiUtil.getCommonMessage("LOG_REQUEST_RESULT", new Object[]{exitCode, endpoint, attrs}));
                        return responseMap;
                    }
                    case SUCCESS: {
                        return responseMap;
                    }
                }
            }
            catch (Exception ex) {
                if (!quiet) {
                    GuiUtil.getLogger().severe(GuiUtil.getCommonMessage("LOG_REQUEST_RESULT", new Object[]{exitCode, endpoint, attrs}));
                    GuiUtil.getLogger().finest("response.getResponseBody(): " + response.getResponseBody());
                }
                if (handlerCtx != null) {
                    if (throwException) {
                        if (message == null) {
                            GuiUtil.handleException(handlerCtx, ex);
                        } else {
                            GuiUtil.handleError(handlerCtx, message);
                        }
                    }
                }
                if (message == null) {
                    throw new RuntimeException(ex);
                }
                throw new RuntimeException(message, ex);
            }
        }
        return null;
    }

    public static boolean hasWarning(Map responseMap) {
        if (responseMap.get("data") != null) {
            String exitCodeStr = (String)((Map)responseMap.get("data")).get("exit_code");
            ActionReport.ExitCode exitCode = exitCodeStr != null ? ActionReport.ExitCode.valueOf((String)exitCodeStr) : ActionReport.ExitCode.SUCCESS;
            return exitCode == ActionReport.ExitCode.WARNING;
        }
        return false;
    }

    public static String appendEncodedSegment(String base, String segment) {
        String encodedUrl = JERSEY_CLIENT.resource(base).getUriBuilder().segment(new String[]{segment}).build(new Object[0]).toASCIIString();
        return encodedUrl;
    }

    protected static MultivaluedMap buildMultivalueMap(Map<String, Object> payload) {
        MultivaluedMapImpl formData = new MultivaluedMapImpl();
        for (Map.Entry<String, Object> entry : payload.entrySet()) {
            Object value = entry.getValue();
            String key = entry.getKey();
            if (value instanceof Collection) {
                for (Object obj : (Collection)value) {
                    try {
                        formData.add((Object)key, obj);
                    }
                    catch (ClassCastException ex) {
                        Logger logger = GuiUtil.getLogger();
                        if (!logger.isLoggable(Level.FINEST)) continue;
                        logger.log(Level.FINEST, GuiUtil.getCommonMessage("LOG_BUILD_MULTI_VALUE_MAP_ERROR", new Object[]{key, obj}));
                    }
                }
                continue;
            }
            try {
                formData.putSingle((Object)key, value);
            }
            catch (ClassCastException ex) {
                Logger logger = GuiUtil.getLogger();
                if (!logger.isLoggable(Level.FINEST)) continue;
                logger.log(Level.FINEST, GuiUtil.getCommonMessage("LOG_BUILD_MULTI_VALUE_MAP_ERROR", new Object[]{key, value}));
            }
        }
        return formData;
    }

    public static RestResponse sendCreateRequest(String endpoint, Map<String, Object> attrs, List<String> skipAttrs, List<String> onlyUseAttrs, List<String> convertToFalse) {
        RestUtil.removeSpecifiedAttrs(attrs, skipAttrs);
        attrs = RestUtil.buildUseOnlyAttrMap(attrs, onlyUseAttrs);
        attrs = RestUtil.convertNullValuesToFalse(attrs, convertToFalse);
        attrs = RestUtil.fixKeyNames(attrs);
        return RestUtil.post(endpoint, attrs);
    }

    public static RestResponse sendUpdateRequest(String endpoint, Map<String, Object> attrs, List<String> skipAttrs, List<String> onlyUseAttrs, List<String> convertToFalse) {
        RestUtil.removeSpecifiedAttrs(attrs, skipAttrs);
        attrs = RestUtil.buildUseOnlyAttrMap(attrs, onlyUseAttrs);
        attrs = RestUtil.convertNullValuesToFalse(attrs, convertToFalse);
        attrs = RestUtil.fixKeyNames(attrs);
        return RestUtil.post(endpoint, attrs);
    }

    protected static Map<String, Object> fixKeyNames(Map<String, Object> map) {
        HashMap<String, Object> results = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String key = entry.getKey().substring(0, 1).toLowerCase(GuiUtil.guiLocale) + entry.getKey().substring(1);
            Object value = entry.getValue();
            results.put(key, value);
        }
        return results;
    }

    protected static void removeSpecifiedAttrs(Map<String, Object> attrs, List<String> removeList) {
        if (removeList == null || removeList.size() <= 0) {
            return;
        }
        Set<Map.Entry<String, Object>> attrSet = attrs.entrySet();
        Iterator<Map.Entry<String, Object>> iter = attrSet.iterator();
        while (iter.hasNext()) {
            Map.Entry<String, Object> oneEntry = iter.next();
            if (!removeList.contains(oneEntry.getKey())) continue;
            iter.remove();
        }
    }

    protected static Map buildUseOnlyAttrMap(Map<String, Object> attrs, List<String> onlyUseAttrs) {
        if (onlyUseAttrs != null) {
            HashMap<String, Object> newAttrs = new HashMap<String, Object>();
            for (String key : onlyUseAttrs) {
                if (!attrs.keySet().contains(key)) continue;
                newAttrs.put(key, attrs.get(key));
            }
            return newAttrs;
        }
        return attrs;
    }

    protected static Map<String, Object> convertNullValuesToFalse(Map<String, Object> attrs, List<String> convertToFalse) {
        if (convertToFalse != null) {
            HashMap<String, Object> newAttrs = new HashMap<String, Object>();
            for (Map.Entry<String, Object> entry : attrs.entrySet()) {
                String key = entry.getKey();
                if (convertToFalse.contains(key) && (entry.getValue() == null || "null".equals(entry.getValue()))) {
                    newAttrs.put(key, "false");
                    continue;
                }
                newAttrs.put(key, entry.getValue());
            }
            return newAttrs;
        }
        return attrs;
    }

    public static String upperCaseFirstLetter(String string) {
        if (string == null || string.length() <= 0) {
            return string;
        }
        return string.substring(0, 1).toUpperCase(GuiUtil.guiLocale) + string.substring(1);
    }

    public static List<String> getChildResourceList(String document) throws SAXException, IOException, ParserConfigurationException {
        ArrayList<String> children = new ArrayList<String>();
        Document doc = MiscUtil.getDocument(document);
        Element root = doc.getDocumentElement();
        NodeList nl = root.getElementsByTagName("childResource");
        if (nl.getLength() > 0) {
            for (int i = 0; i < nl.getLength(); ++i) {
                Node child = nl.item(i);
                if (child.getNodeType() != 1) continue;
                children.add(child.getTextContent());
            }
        }
        return children;
    }

    public static List<Map> buildChildEntityList(String parent, String childType, List skipList, List includeList, String id) throws Exception {
        String endpoint = parent.endsWith("/") ? parent + childType : parent + "/" + childType;
        boolean hasSkip = skipList != null;
        boolean hasInclude = includeList != null;
        boolean convert = childType.equals("property");
        ArrayList<Map> childElements = new ArrayList<Map>();
        List<String> childUrls = RestUtil.getChildList(endpoint);
        for (String childUrl : childUrls) {
            Map<String, Object> entity = RestUtil.getEntityAttrs(childUrl, "entity");
            HashMap<String, Object> oneRow = new HashMap<String, Object>();
            if (hasSkip && skipList.contains(entity.get(id)) || hasInclude && !includeList.contains(entity.get(id))) continue;
            oneRow.put("selected", false);
            for (Map.Entry<String, Object> e : entity.entrySet()) {
                oneRow.put(e.getKey(), RestUtil.getA(entity, e.getKey(), convert));
            }
            oneRow.put("encodedName", URLEncoder.encode(entity.get(id).toString(), "UTF-8"));
            oneRow.put("name", entity.get(id));
            childElements.add(oneRow);
        }
        return childElements;
    }

    private static String getA(Map<String, Object> attrs, String key, boolean convert) {
        Object val = attrs.get(key);
        if (val == null) {
            return "";
        }
        return convert && val.equals("") ? GUI_TOKEN_FOR_EMPTY_PROPERTY_VALUE : val.toString();
    }

    public static List<String> getChildList(String endpoint) throws Exception {
        ArrayList<String> childElements = new ArrayList<String>();
        Map<String, String> childResources = RestUtil.getChildMap(endpoint);
        if (childResources != null) {
            childElements.addAll(childResources.values());
        }
        Collections.sort(childElements);
        return childElements;
    }

    public static Map<String, String> getChildMap(String endpoint) throws Exception {
        Map extraProperties;
        Map<String, Object> responseMap;
        Map data;
        Map<String, String> childElements = new TreeMap<String, String>();
        if (RestUtil.doesProxyExist(endpoint).booleanValue() && (data = (Map)(responseMap = RestUtil.restRequest(endpoint, new HashMap<String, Object>(), "get", null, false)).get("data")) != null && (extraProperties = (Map)data.get("extraProperties")) != null && (childElements = (Map)extraProperties.get("childResources")) == null) {
            childElements = new TreeMap();
        }
        return childElements;
    }

    public static Boolean doesProxyExist(String endpoint) {
        try {
            if (RestUtil.get(endpoint).isSuccess()) {
                return true;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    private static String getRestToken() {
        String token = null;
        FacesContext ctx = FacesContext.getCurrentInstance();
        if (ctx != null) {
            token = (String)ctx.getExternalContext().getSessionMap().get("__rTkn__");
        }
        return token;
    }

    public static RestResponse get(String address) {
        return RestUtil.get(address, new HashMap<String, Object>());
    }

    public static RestResponse get(String address, Map<String, Object> payload) {
        WebResource webResource = JERSEY_CLIENT.resource(address).queryParams(RestUtil.buildMultivalueMap(payload));
        ClientResponse resp = (ClientResponse)((WebResource.Builder)webResource.cookie(new Cookie(REST_TOKEN_COOKIE, RestUtil.getRestToken())).accept(new String[]{RESPONSE_TYPE})).get(ClientResponse.class);
        return RestResponse.getRestResponse(resp);
    }

    public static RestResponse post(String address, Object payload, String contentType) {
        WebResource webResource = JERSEY_CLIENT.resource(address);
        if (contentType == null) {
            contentType = RESPONSE_TYPE;
        }
        if (payload instanceof Map) {
            payload = RestUtil.buildMultivalueMap((Map)payload);
        }
        ClientResponse cr = (ClientResponse)((WebResource.Builder)((WebResource.Builder)webResource.header("Content-Type", (Object)contentType).cookie(new Cookie(REST_TOKEN_COOKIE, RestUtil.getRestToken()))).accept(new String[]{RESPONSE_TYPE})).post(ClientResponse.class, payload);
        RestResponse rr = RestResponse.getRestResponse(cr);
        return rr;
    }

    public static RestResponse post(String address, Map<String, Object> payload) {
        WebResource webResource = JERSEY_CLIENT.resource(address);
        MultivaluedMap formData = RestUtil.buildMultivalueMap(payload);
        ClientResponse cr = (ClientResponse)((WebResource.Builder)webResource.cookie(new Cookie(REST_TOKEN_COOKIE, RestUtil.getRestToken())).accept(new String[]{RESPONSE_TYPE})).post(ClientResponse.class, (Object)formData);
        RestResponse rr = RestResponse.getRestResponse(cr);
        return rr;
    }

    public static RestResponse put(String address, Map<String, Object> payload) {
        WebResource webResource = JERSEY_CLIENT.resource(address);
        MultivaluedMap formData = RestUtil.buildMultivalueMap(payload);
        ClientResponse cr = (ClientResponse)((WebResource.Builder)webResource.cookie(new Cookie(REST_TOKEN_COOKIE, RestUtil.getRestToken())).accept(new String[]{RESPONSE_TYPE})).put(ClientResponse.class, (Object)formData);
        RestResponse rr = RestResponse.getRestResponse(cr);
        return rr;
    }

    public static RestResponse delete(String address, Map<String, Object> payload) {
        WebResource webResource = JERSEY_CLIENT.resource(address);
        ClientResponse cr = (ClientResponse)((WebResource.Builder)webResource.queryParams(RestUtil.buildMultivalueMap(payload)).cookie(new Cookie(REST_TOKEN_COOKIE, RestUtil.getRestToken())).accept(new String[]{RESPONSE_TYPE})).delete(ClientResponse.class);
        RestUtil.checkStatusForSuccess(cr);
        return RestResponse.getRestResponse(cr);
    }

    public static RestResponse options(String address, String responseType) {
        WebResource webResource = JERSEY_CLIENT.resource(address);
        ClientResponse cr = (ClientResponse)((WebResource.Builder)webResource.cookie(new Cookie(REST_TOKEN_COOKIE, RestUtil.getRestToken())).accept(new String[]{responseType})).options(ClientResponse.class);
        RestUtil.checkStatusForSuccess(cr);
        return RestResponse.getRestResponse(cr);
    }

    public static void checkStatusForSuccess(ClientResponse cr) {
        int status = cr.getStatus();
        if (status < 200 || status > 299) {
            throw new RuntimeException(cr.toString());
        }
    }

    public static void initialize(Client client) {
        block3: {
            if (client == null) {
                client = JERSEY_CLIENT;
            }
            try {
                Habitat habitat = SecurityServicesUtil.getInstance().getHabitat();
                SecureAdmin secureAdmin = (SecureAdmin)habitat.getComponent(SecureAdmin.class);
                HTTPSProperties httpsProperties = new HTTPSProperties((HostnameVerifier)new BasicHostnameVerifier(), ((SSLUtils)habitat.getComponent(SSLUtils.class)).getAdminSSLContext(SecureAdmin.Util.DASAlias((SecureAdmin)secureAdmin), null));
                client.getProperties().put("com.sun.jersey.client.impl.urlconnection.httpsProperties", httpsProperties);
            }
            catch (Exception ex) {
                GuiUtil.getLogger().warning("RestUtil.initialize() failed");
                if (!GuiUtil.getLogger().isLoggable(Level.FINE)) break block3;
                ex.printStackTrace();
            }
        }
    }

    private static class BasicHostnameVerifier
    implements HostnameVerifier {
        final HostnameVerifier defaultVerifier = HttpsURLConnection.getDefaultHostnameVerifier();

        public boolean verify(String host, SSLSession sslSession) {
            if (host.equals("localhost")) {
                return true;
            }
            boolean result = this.defaultVerifier.verify(host, sslSession);
            return result ? true : host.equals(sslSession.getPeerHost());
        }
    }
}

