/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.jvnet.hk2.component.ComponentException;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.Inhabitant;
import org.jvnet.hk2.component.MultiMap;
import org.jvnet.hk2.config.ConfigInjector;
import org.jvnet.hk2.config.ConfigModel;
import org.jvnet.hk2.config.Configured;
import org.jvnet.hk2.config.DataType;
import org.jvnet.hk2.config.Dom;
import org.jvnet.hk2.config.InjectionTarget;
import org.jvnet.hk2.config.PrimitiveDataType;
import org.jvnet.hk2.config.Translator;

public class DomDocument<T extends Dom> {
    private volatile Translator translator = Translator.NOOP;
    protected final Map<Inhabitant<? extends ConfigInjector>, ConfigModel> models = new HashMap<Inhabitant<? extends ConfigInjector>, ConfigModel>();
    private final MultiMap<Class, List<ConfigModel>> implementorsOf = new MultiMap();
    final Habitat habitat;
    T root;
    private final Map<String, DataType> validators = new HashMap<String, DataType>();
    static final List<String> PRIMS = Collections.unmodifiableList(Arrays.asList("boolean", "char", "int", "java.lang.Boolean", "java.lang.Character", "java.lang.Integer"));

    public DomDocument(Habitat habitat) {
        this.habitat = habitat;
        for (String prim : PRIMS) {
            this.validators.put(prim, new PrimitiveDataType(prim));
        }
    }

    public Dom getRoot() {
        return this.root;
    }

    public Translator getTranslator() {
        return this.translator;
    }

    public void setTranslator(Translator translator) {
        this.translator = translator;
    }

    ConfigModel buildModel(Inhabitant<? extends ConfigInjector> i) {
        ConfigModel m = this.models.get(i);
        if (m == null) {
            m = new ConfigModel(this, i, (MultiMap<String, String>)i.metadata());
        }
        return m;
    }

    public ConfigModel buildModel(Class<?> clazz) {
        return this.buildModel(clazz.getName());
    }

    public ConfigModel buildModel(String fullyQualifiedClassName) {
        Inhabitant i = this.habitat.getInhabitantByAnnotation(InjectionTarget.class, fullyQualifiedClassName);
        if (i == null) {
            throw new ComponentException("ConfigInjector for %s is not found, is it annotated with @Configured", new Object[]{fullyQualifiedClassName});
        }
        return this.buildModel((Inhabitant<ConfigInjector>)i);
    }

    public ConfigModel getModelByElementName(String elementName) {
        Inhabitant i = this.habitat.getInhabitant(ConfigInjector.class, elementName);
        if (i == null) {
            return null;
        }
        return this.buildModel((Inhabitant<ConfigInjector>)i);
    }

    public synchronized List<ConfigModel> getAllModelsImplementing(Class intf) throws ClassNotFoundException {
        if (this.implementorsOf.size() == 0) {
            this.initXRef();
        }
        return (List)this.implementorsOf.getOne((Object)intf);
    }

    private void initXRef() throws ClassNotFoundException {
        for (Inhabitant i : this.habitat.getInhabitants(ConfigInjector.class)) {
            this.buildModel((Inhabitant<ConfigInjector>)i);
        }
        ArrayList result = new ArrayList();
        for (ConfigModel cm : this.models.values()) {
            Class<?> targetType = ((ClassLoader)cm.classLoaderHolder.get()).loadClass(cm.targetTypeName);
            do {
                Class<?>[] intfs;
                for (Class<?> intf : intfs = targetType.getInterfaces()) {
                    if (!intf.isAnnotationPresent(Configured.class)) continue;
                    ArrayList<ConfigModel> models = (ArrayList<ConfigModel>)this.implementorsOf.getOne(intf);
                    if (models == null) {
                        models = new ArrayList<ConfigModel>();
                        this.implementorsOf.add(intf, models);
                    }
                    models.add(cm);
                }
            } while ((targetType = targetType.getSuperclass()) != null);
        }
    }

    @Deprecated
    public ConfigModel getModel(Class c) {
        return this.buildModel(c);
    }

    public Dom make(Habitat habitat, XMLStreamReader in, T parent, ConfigModel model) {
        return new Dom(habitat, this, (Dom)parent, model, in);
    }

    public void writeTo(XMLStreamWriter w) throws XMLStreamException {
        ((Dom)this.root).writeTo(null, w);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DataType getValidator(String dataType) {
        Map<String, DataType> map = this.validators;
        synchronized (map) {
            DataType validator = this.validators.get(dataType);
            if (validator != null) {
                return validator;
            }
        }
        Collection dtfh = this.habitat.getAllByContract(DataType.class);
        Map<String, DataType> map2 = this.validators;
        synchronized (map2) {
            for (DataType dt : dtfh) {
                this.validators.put(dt.getClass().getName(), dt);
            }
            return this.validators.get(dataType);
        }
    }
}

