/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.config;

import com.sun.grizzly.Context;
import com.sun.grizzly.config.ConfigAwareElement;
import com.sun.grizzly.config.GrizzlyEmbeddedHttp;
import com.sun.grizzly.config.SSLConfigHolder;
import com.sun.grizzly.config.dom.Protocol;
import com.sun.grizzly.config.dom.ProtocolFinder;
import com.sun.grizzly.config.dom.Ssl;
import com.sun.grizzly.portunif.PUProtocolRequest;
import com.sun.grizzly.util.SSLUtils;
import com.sun.grizzly.util.ThreadAttachment;
import com.sun.grizzly.util.WorkerThread;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import org.jvnet.hk2.component.Habitat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpProtocolFinder
extends com.sun.grizzly.http.portunif.HttpProtocolFinder
implements ConfigAwareElement<ProtocolFinder> {
    private static final Logger logger = GrizzlyEmbeddedHttp.logger();
    private final Object sync = new Object();
    private volatile boolean isSecured;
    private volatile Ssl ssl;
    private volatile SSLConfigHolder sslConfigHolder;
    private final AtomicBoolean isConfigured = new AtomicBoolean();

    @Override
    public void configure(Habitat habitat, ProtocolFinder configuration) {
        Protocol protocol = configuration.findProtocol();
        this.isSecured = Boolean.parseBoolean(protocol.getSecurityEnabled());
        if (this.isSecured) {
            this.ssl = protocol.getSsl();
            try {
                this.sslConfigHolder = new SSLConfigHolder(habitat, this.ssl);
            }
            catch (SSLException e) {
                throw new IllegalStateException(e);
            }
            if (!SSLConfigHolder.isAllowLazyInit(this.ssl) && !this.isConfigured.getAndSet(true)) {
                this.sslConfigHolder.configureSSL();
            }
        }
    }

    @Override
    public String find(Context context, PUProtocolRequest protocolRequest) throws IOException {
        if (this.isSecured) {
            if (!this.isConfigured.getAndSet(true)) {
                this.sslConfigHolder.configureSSL();
            }
            SelectionKey key = context.getSelectionKey();
            SelectableChannel channel = key.channel();
            SSLEngine sslEngine = this.sslConfigHolder.createSSLEngine();
            boolean isloglevelfine = logger.isLoggable(Level.FINE);
            if (isloglevelfine) {
                logger.log(Level.FINE, "sslEngine: {0}", sslEngine);
            }
            ByteBuffer inputBB = protocolRequest.getSecuredInputByteBuffer();
            ByteBuffer outputBB = protocolRequest.getSecuredOutputByteBuffer();
            ByteBuffer byteBuffer = protocolRequest.getByteBuffer();
            int securedBBSize = sslEngine.getSession().getPacketBufferSize();
            if (inputBB == null || inputBB != null && securedBBSize > inputBB.capacity()) {
                inputBB = ByteBuffer.allocate(securedBBSize * 2);
                protocolRequest.setSecuredInputByteBuffer(inputBB);
            }
            if (outputBB == null || outputBB != null && securedBBSize > outputBB.capacity()) {
                outputBB = ByteBuffer.allocate(securedBBSize * 2);
                protocolRequest.setSecuredOutputByteBuffer(outputBB);
            }
            int applicationBBSize = sslEngine.getSession().getApplicationBufferSize();
            if (byteBuffer == null || applicationBBSize > byteBuffer.capacity()) {
                ByteBuffer newBB = ByteBuffer.allocate(securedBBSize);
                byteBuffer.flip();
                newBB.put(byteBuffer);
                byteBuffer = newBB;
                protocolRequest.setByteBuffer(byteBuffer);
            }
            inputBB.clear();
            outputBB.position(0);
            outputBB.limit(0);
            inputBB.put((ByteBuffer)byteBuffer.flip());
            byteBuffer.clear();
            WorkerThread workerThread = (WorkerThread)Thread.currentThread();
            boolean isHandshakeDone = false;
            SSLEngineResult.HandshakeStatus handshakeStatus = SSLEngineResult.HandshakeStatus.NEED_UNWRAP;
            try {
                byteBuffer = SSLUtils.doHandshake(channel, byteBuffer, inputBB, outputBB, sslEngine, handshakeStatus, this.sslConfigHolder.getSslInactivityTimeout(), inputBB.position() > 0);
                if (isloglevelfine) {
                    logger.log(Level.FINE, "handshake is done");
                }
                protocolRequest.setSSLEngine(sslEngine);
                workerThread.setSSLEngine(sslEngine);
                workerThread.setInputBB(inputBB);
                workerThread.setOutputBB(outputBB);
                ThreadAttachment attachment = workerThread.updateAttachment(ThreadAttachment.Mode.SSL_ENGINE);
                key.attach(attachment);
                outputBB.limit(outputBB.position());
                isHandshakeDone = true;
            }
            catch (EOFException ex) {
                if (isloglevelfine) {
                    logger.log(Level.FINE, "handshake failed", ex);
                }
            }
            catch (Exception ex) {
                if (isloglevelfine) {
                    logger.log(Level.FINE, "handshake failed", ex);
                }
                inputBB.flip();
                byteBuffer.put(inputBB);
            }
            if (isloglevelfine) {
                logger.log(Level.FINE, "after handshake. isComplete: " + isHandshakeDone);
            }
            if (isHandshakeDone) {
                String protocol;
                int byteRead = -1;
                if (isloglevelfine) {
                    logger.log(Level.FINE, "secured bytebuffer: " + inputBB);
                }
                long startTime = System.currentTimeMillis();
                if (inputBB.position() > 0) {
                    byteBuffer = SSLUtils.unwrapAll(byteBuffer, inputBB, sslEngine);
                    protocolRequest.setByteBuffer(byteBuffer);
                    workerThread.setByteBuffer(byteBuffer);
                }
                int timeout = this.sslConfigHolder.getSslInactivityTimeout();
                while ((protocol = super.find(context, protocolRequest)) == null && System.currentTimeMillis() - startTime < (long)timeout) {
                    byteRead = SSLUtils.doRead((SelectableChannel)channel, (ByteBuffer)inputBB, (SSLEngine)sslEngine, (int)timeout).bytesRead;
                    if (byteRead == -1) {
                        logger.log(Level.FINE, "EOF");
                        throw new EOFException();
                    }
                    byteBuffer = SSLUtils.unwrapAll(byteBuffer, inputBB, sslEngine);
                    protocolRequest.setByteBuffer(byteBuffer);
                    workerThread.setByteBuffer(byteBuffer);
                }
                context.setAttribute("SSLReadFilter.preread", (Object)Boolean.TRUE);
                if (isloglevelfine) {
                    logger.log(Level.FINE, "protocol: " + protocol);
                }
                return protocol;
            }
            return null;
        }
        return super.find(context, protocolRequest);
    }
}

