/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.node;

import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.WebService;
import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.enterprise.deployment.WebServicesDescriptor;
import com.sun.enterprise.deployment.node.BundleNode;
import com.sun.enterprise.deployment.node.WebServiceNode;
import com.sun.enterprise.deployment.node.XMLElement;
import com.sun.enterprise.deployment.util.DOLUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebServicesDescriptorNode
extends BundleNode {
    public static final XMLElement ROOT_ELEMENT = new XMLElement("webservices");
    public static final String SCHEMA_ID = "javaee_web_services_1_3.xsd";
    public static final String SCHEMA_ID_12 = "javaee_web_services_1_2.xsd";
    public static final String SPEC_VERSION = "1.3";
    private static final List<String> systemIDs = WebServicesDescriptorNode.initSystemIDs();
    private BundleDescriptor bundleDescriptor;

    private static final List<String> initSystemIDs() {
        ArrayList<String> systemIDs = new ArrayList<String>();
        systemIDs.add(SCHEMA_ID);
        systemIDs.add(SCHEMA_ID_12);
        return Collections.unmodifiableList(systemIDs);
    }

    public WebServicesDescriptorNode(BundleDescriptor descriptor) {
        this.bundleDescriptor = descriptor;
        this.registerElementHandler(new XMLElement("webservice-description"), WebServiceNode.class);
    }

    public WebServicesDescriptorNode() {
        this(null);
    }

    @Override
    public String getDocType() {
        return null;
    }

    @Override
    public String getSystemID() {
        return SCHEMA_ID;
    }

    @Override
    public List<String> getSystemIDs() {
        return systemIDs;
    }

    @Override
    protected String getSchemaURL() {
        return "http://www.ibm.com/webservices/xsd/" + this.getSystemID();
    }

    @Override
    protected XMLElement getXMLRootTag() {
        return ROOT_ELEMENT;
    }

    @Override
    public void setElementValue(XMLElement element, String value) {
        if ("version".equals(element.getQName())) {
            this.bundleDescriptor.getWebServices().setSpecVersion(value);
        } else {
            super.setElementValue(element, value);
        }
    }

    @Override
    public void addDescriptor(Object descriptor) {
        WebServicesDescriptor webServicesDesc = this.bundleDescriptor.getWebServices();
        WebService webService = (WebService)descriptor;
        webServicesDesc.addWebService(webService);
        for (WebServiceEndpoint next : webService.getEndpoints()) {
            if (next.resolveComponentLink()) continue;
            DOLUtils.getDefaultLogger().info("Warning: Web service endpoint " + next.getEndpointName() + " component link " + next.getLinkName() + " is not valid");
        }
    }

    @Override
    public Object getDescriptor() {
        return this.bundleDescriptor;
    }

    @Override
    public Node writeDescriptor(Node parent, Descriptor descriptor) {
        Node topNode = parent;
        if (parent instanceof Document) {
            BundleDescriptor bundleDesc = (BundleDescriptor)descriptor;
            WebServicesDescriptor webServicesDesc = bundleDesc.getWebServices();
            topNode = super.writeDescriptor(parent, webServicesDesc);
            WebServiceNode wsNode = new WebServiceNode();
            for (WebService next : webServicesDesc.getWebServices()) {
                wsNode.writeDescriptor(topNode, "webservice-description", next);
            }
        }
        return parent;
    }

    @Override
    public String getSpecVersion() {
        return SPEC_VERSION;
    }
}

