/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ejb.deployment.annotation.handlers;

import com.sun.enterprise.deployment.DummyEjbDescriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.deployment.annotation.context.EjbBundleContext;
import com.sun.enterprise.deployment.annotation.context.EjbContext;
import com.sun.enterprise.deployment.annotation.handlers.AbstractHandler;
import java.io.Externalizable;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.logging.Level;
import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;
import javax.ejb.Local;
import javax.ejb.LocalHome;
import javax.ejb.Remote;
import javax.ejb.RemoteHome;
import javax.ejb.TimedObject;
import javax.ejb.Timeout;
import org.glassfish.apf.AnnotatedElementHandler;
import org.glassfish.apf.AnnotationInfo;
import org.glassfish.apf.AnnotationProcessorException;
import org.glassfish.apf.HandlerProcessingResult;

public abstract class AbstractEjbHandler
extends AbstractHandler {
    protected abstract String getAnnotatedName(Annotation var1);

    protected abstract boolean isValidEjbDescriptor(EjbDescriptor var1, Annotation var2);

    protected abstract EjbDescriptor createEjbDescriptor(String var1, AnnotationInfo var2) throws AnnotationProcessorException;

    protected abstract HandlerProcessingResult setEjbDescriptorInfo(EjbDescriptor var1, AnnotationInfo var2) throws AnnotationProcessorException;

    public HandlerProcessingResult processAnnotation(AnnotationInfo ainfo) throws AnnotationProcessorException {
        String elementName;
        AnnotatedElementHandler aeHandler;
        Class ejbClass = (Class)ainfo.getAnnotatedElement();
        Annotation annotation = ainfo.getAnnotation();
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.finer("@ process ejb annotation " + annotation + " in " + ejbClass);
        }
        if ((aeHandler = ainfo.getProcessingContext().getHandler()) != null && aeHandler instanceof EjbContext) {
            EjbContext context = (EjbContext)aeHandler;
            EjbDescriptor desc = context.getDescriptor();
            if (this.isValidEjbDescriptor(desc, annotation)) {
                return this.getDefaultProcessedResult();
            }
            this.log(Level.SEVERE, ainfo, localStrings.getLocalString("enterprise.deployment.annotation.handlers.notcompsuperclass", "The annotation symbol defined in super-class is not compatible with {0} ejb {1}.", new Object[]{desc.getType(), desc.getName()}));
            return this.getDefaultFailedResult();
        }
        if (aeHandler == null || !(aeHandler instanceof EjbBundleContext)) {
            return this.getInvalidAnnotatedElementHandlerResult(ainfo.getProcessingContext().getHandler(), ainfo);
        }
        EjbBundleContext ctx = (EjbBundleContext)aeHandler;
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("My context is " + ctx);
        }
        if ((elementName = this.getAnnotatedName(annotation)).length() == 0) {
            elementName = ejbClass.getSimpleName();
        }
        EjbBundleDescriptor currentBundle = ctx.getDescriptor();
        EjbDescriptor ejbDesc = null;
        try {
            ejbDesc = currentBundle.getEjbByName(elementName);
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        if (ejbDesc != null && !(ejbDesc instanceof DummyEjbDescriptor)) {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("Overriding rules apply for " + ejbClass.getName());
            }
            if (!this.isValidEjbDescriptor(ejbDesc, annotation)) {
                this.log(Level.SEVERE, ainfo, localStrings.getLocalString("enterprise.deployment.annotation.handlers.wrongejbtype", "Wrong annotation symbol for ejb {1}", new Object[]{ejbDesc}));
                return this.getDefaultFailedResult();
            }
            String descriptorEjbClass = ejbDesc.getEjbClassName();
            if (descriptorEjbClass == null) {
                ejbDesc.setEjbClassName(ejbClass.getName());
                ejbDesc.applyDefaultClassToLifecycleMethods();
            } else if (!descriptorEjbClass.equals(ejbClass.getName())) {
                this.log(Level.SEVERE, ainfo, localStrings.getLocalString("enterprise.deployment.annotation.handlers.ejbclsmismatch", "", new Object[]{descriptorEjbClass, elementName, ejbClass.getName()}));
                return this.getDefaultFailedResult();
            }
        } else {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("Creating a new descriptor for " + ejbClass.getName());
            }
            EjbDescriptor dummyEjbDesc = ejbDesc;
            ejbDesc = this.createEjbDescriptor(elementName, ainfo);
            if (dummyEjbDesc != null && dummyEjbDesc instanceof DummyEjbDescriptor) {
                currentBundle.removeEjb(dummyEjbDesc);
                ejbDesc.addEjbDescriptor(dummyEjbDesc);
                ejbDesc.setEjbClassName(ejbClass.getName());
            }
            currentBundle.addEjb(ejbDesc);
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("New " + this.getAnnotationType().getName() + " bean " + elementName);
            }
        }
        HandlerProcessingResult procResult = this.setEjbDescriptorInfo(ejbDesc, ainfo);
        this.doTimedObjectProcessing(ejbClass, ejbDesc);
        EjbContext ejbContext = new EjbContext(ejbDesc, ejbClass);
        ctx.getProcessingContext().pushHandler((AnnotatedElementHandler)ejbContext);
        return procResult;
    }

    private void doTimedObjectProcessing(Class ejbClass, EjbDescriptor ejbDesc) {
        MethodDescriptor timeoutMethodDesc = null;
        block0: for (Class nextClass = ejbClass; nextClass != Object.class && nextClass != null && timeoutMethodDesc == null; nextClass = nextClass.getSuperclass()) {
            Method[] methods;
            for (Method m : methods = nextClass.getDeclaredMethods()) {
                if (m.getAnnotation(Timeout.class) == null) continue;
                timeoutMethodDesc = new MethodDescriptor(m, "Bean");
                continue block0;
            }
        }
        if (timeoutMethodDesc == null && TimedObject.class.isAssignableFrom(ejbClass)) {
            timeoutMethodDesc = new MethodDescriptor("ejbTimeout", "@Timeout method", new String[]{"javax.ejb.Timer"}, "Bean");
        }
        if (timeoutMethodDesc != null) {
            ejbDesc.setEjbTimeoutMethod(timeoutMethodDesc);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected HandlerProcessingResult setBusinessAndHomeInterfaces(EjbDescriptor ejbDesc, AnnotationInfo ainfo) throws AnnotationProcessorException {
        LocalHome localHome;
        RemoteHome remoteHomeAnn;
        void var12_21;
        Local localBusAnn;
        HashSet<String> localIntfNames = new HashSet<String>();
        HashSet<String> remoteIntfNames = new HashSet<String>();
        Class ejbClass = (Class)ainfo.getAnnotatedElement();
        Remote remoteBusAnn = ejbClass.getAnnotation(Remote.class);
        boolean emptyRemoteBusAnn = false;
        if (remoteBusAnn != null) {
            for (Class next : remoteBusAnn.value()) {
                remoteIntfNames.add(next.getName());
            }
            emptyRemoteBusAnn = remoteIntfNames.isEmpty();
        }
        if ((localBusAnn = ejbClass.getAnnotation(Local.class)) != null) {
            for (Class clazz : localBusAnn.value()) {
                localIntfNames.add(clazz.getName());
            }
        }
        LinkedList eligibleInterfaces = new LinkedList();
        Class<?>[] arr$ = ejbClass.getInterfaces();
        int len$ = arr$.length;
        boolean bl = false;
        while (var12_21 < len$) {
            Class<?> next = arr$[var12_21];
            if (!this.excludedFromImplementsClause(next)) {
                eligibleInterfaces.add(next);
            }
            ++var12_21;
        }
        int nonImplementsClauseBusinessInterfaceCount = remoteIntfNames.size() + localIntfNames.size() + ejbDesc.getRemoteBusinessClassNames().size() + ejbDesc.getLocalBusinessClassNames().size();
        for (Class clazz : eligibleInterfaces) {
            String nextIntfName = clazz.getName();
            if (remoteIntfNames.contains(nextIntfName) || localIntfNames.contains(nextIntfName) || ejbDesc.getRemoteBusinessClassNames().contains(nextIntfName) || ejbDesc.getLocalBusinessClassNames().contains(nextIntfName)) continue;
            if (clazz.getAnnotation(Local.class) != null) {
                localIntfNames.add(nextIntfName);
                continue;
            }
            if (clazz.getAnnotation(Remote.class) != null) {
                remoteIntfNames.add(nextIntfName);
                continue;
            }
            if (nonImplementsClauseBusinessInterfaceCount != 0) continue;
            if (emptyRemoteBusAnn) {
                remoteIntfNames.add(nextIntfName);
                continue;
            }
            localIntfNames.add(nextIntfName);
        }
        if (localIntfNames.size() > 0) {
            for (String string : localIntfNames) {
                ejbDesc.addLocalBusinessClassName(string);
            }
        }
        if (remoteIntfNames.size() > 0) {
            for (String string : remoteIntfNames) {
                ejbDesc.addRemoteBusinessClassName(string);
            }
        }
        if ((remoteHomeAnn = ejbClass.getAnnotation(RemoteHome.class)) != null) {
            Class clazz = remoteHomeAnn.value();
            Class remoteIntf = this.getComponentIntfFromHome(clazz);
            if (EJBHome.class.isAssignableFrom(clazz) && remoteIntf != null) {
                ejbDesc.setHomeClassName(clazz.getName());
                ejbDesc.setRemoteClassName(remoteIntf.getName());
            } else {
                this.log(Level.SEVERE, ainfo, localStrings.getLocalString("enterprise.deployment.annotation.handlers.invalidremotehome", "Encountered invalid @RemoteHome interface {0}.", new Object[]{clazz}));
                return this.getDefaultFailedResult();
            }
        }
        if ((localHome = ejbClass.getAnnotation(LocalHome.class)) != null) {
            Class localHome2 = localHome.value();
            Class localIntf = this.getComponentIntfFromHome(localHome2);
            if (EJBLocalHome.class.isAssignableFrom(localHome2) && localIntf != null) {
                ejbDesc.setLocalHomeClassName(localHome2.getName());
                ejbDesc.setLocalClassName(localIntf.getName());
            } else {
                this.log(Level.SEVERE, ainfo, localStrings.getLocalString("enterprise.deployment.annotation.handlers.invalidlocalhome", "Encountered invalid @LocalHome interface {0}.", new Object[]{localHome2}));
                return this.getDefaultFailedResult();
            }
        }
        return this.getDefaultProcessedResult();
    }

    private Class getComponentIntfFromHome(Class homeIntf) {
        Method[] methods;
        Class<?> componentIntf = null;
        for (Method m : methods = homeIntf.getMethods()) {
            if (!m.getName().startsWith("create")) continue;
            componentIntf = m.getReturnType();
            break;
        }
        return componentIntf;
    }

    protected boolean excludedFromImplementsClause(Class intf) {
        return intf == Serializable.class || intf == Externalizable.class || intf.getPackage() != null && intf.getPackage().getName().equals("javax.ejb");
    }

    protected void doDescriptionProcessing(String description, EjbDescriptor ejbDescriptor) {
        if (description != null && !description.equals("")) {
            ejbDescriptor.setDescription(description);
        }
    }

    protected void doMappedNameProcessing(String mappedName, EjbDescriptor ejbDesc) {
        if (ejbDesc.getMappedName().equals("") && !mappedName.equals("")) {
            ejbDesc.setMappedName(mappedName);
        }
    }
}

