/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.containers;

import com.sun.ejb.Container;
import com.sun.ejb.containers.BaseContainer;
import com.sun.ejb.containers.EJBObjectImpl;
import com.sun.ejb.containers.EjbContainerUtilImpl;
import com.sun.ejb.portable.HomeHandleImpl;
import java.lang.reflect.Method;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.CreateException;
import javax.ejb.EJBHome;
import javax.ejb.EJBMetaData;
import javax.ejb.EJBObject;
import javax.ejb.Handle;
import javax.ejb.HomeHandle;
import javax.ejb.RemoveException;

public abstract class EJBHomeImpl
implements EJBHome {
    private static final Logger _logger = EjbContainerUtilImpl.getInstance().getLogger();
    private BaseContainer container;

    protected EJBHomeImpl() throws RemoteException {
    }

    protected final Container getContainer() {
        return this.container;
    }

    final void setContainer(BaseContainer c) {
        this.container = c;
    }

    protected EJBHome getEJBHome() {
        return this;
    }

    public final EJBObjectImpl createEJBObjectImpl() throws RemoteException, CreateException {
        return this.container.createEJBObjectImpl();
    }

    public EJBObjectImpl createRemoteBusinessObjectImpl() throws RemoteException, CreateException {
        return this.container.createRemoteBusinessObjectImpl();
    }

    public final void remove(Handle handle) throws RemoteException, RemoveException {
        EJBObject ejbo;
        this.container.authorizeRemoteMethod(0);
        try {
            ejbo = handle.getEJBObject();
        }
        catch (RemoteException ex) {
            _logger.log(Level.FINE, "Exception in method remove()", ex);
            NoSuchObjectException nsoe = new NoSuchObjectException(ex.toString());
            nsoe.initCause(ex);
            throw nsoe;
        }
        ejbo.remove();
    }

    public final void remove(Object primaryKey) throws RemoteException, RemoveException {
        if (this.container.getContainerType() == BaseContainer.ContainerType.ENTITY) {
            throw new RemoveException("Invalid remove operation.");
        }
        this.container.authorizeRemoteMethod(1);
        Method method = null;
        try {
            method = EJBHome.class.getMethod("remove", Object.class);
        }
        catch (NoSuchMethodException e) {
            _logger.log(Level.FINE, "Exception in method remove()", e);
        }
        this.container.doEJBHomeRemove(primaryKey, method, false);
    }

    public final EJBMetaData getEJBMetaData() throws RemoteException {
        this.container.authorizeRemoteMethod(2);
        return this.container.getEJBMetaData();
    }

    public final HomeHandle getHomeHandle() throws RemoteException {
        this.container.authorizeRemoteMethod(3);
        return new HomeHandleImpl(this.container.getEJBHomeStub());
    }
}

