/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.containers;

import com.sun.ejb.EjbInvocation;
import com.sun.ejb.containers.BaseContainer;
import com.sun.ejb.containers.EJBContextImpl;
import com.sun.ejb.containers.EJBTimerService;
import com.sun.ejb.containers.EJBTimerServiceWrapper;
import com.sun.ejb.containers.EjbContainerUtilImpl;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.ejb.EJBException;
import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;
import javax.ejb.SessionContext;
import javax.ejb.TimerService;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.transaction.UserTransaction;
import javax.xml.rpc.handler.MessageContext;
import org.glassfish.api.invocation.ComponentInvocation;
import org.glassfish.api.invocation.InvocationManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SessionContextImpl
extends EJBContextImpl
implements SessionContext {
    private Object instanceKey;
    private boolean completedTxStatus;
    private boolean afterCompletionDelayed = false;
    private boolean committing = false;
    private boolean inAfterCompletion = false;
    private boolean isStateless = false;
    private boolean isStateful = false;
    private boolean existsInSessionStore = false;
    private transient int refCount = 0;
    private boolean txCheckpointDelayed;
    private String ejbName;
    private long lastPersistedAt;
    private long version;
    private transient Map<EntityManagerFactory, EntityManager> extendedEntityManagerMap;
    private transient Set<EntityManagerFactory> emfsRegisteredWithTx;

    SessionContextImpl(Object ejb, BaseContainer container) {
        super(ejb, container);
        EjbSessionDescriptor sessionDesc = (EjbSessionDescriptor)this.getContainer().getEjbDescriptor();
        this.isStateless = sessionDesc.isStateless();
        this.isStateful = sessionDesc.isStateful();
        this.ejbName = sessionDesc.getName();
    }

    public String toString() {
        return this.ejbName + "; id: " + this.instanceKey;
    }

    public Map<EntityManagerFactory, EntityManager> getExtendedEntityManagerMap() {
        if (this.extendedEntityManagerMap == null) {
            this.extendedEntityManagerMap = new HashMap<EntityManagerFactory, EntityManager>();
        }
        return this.extendedEntityManagerMap;
    }

    public EntityManager getExtendedEntityManager(EntityManagerFactory emf) {
        return this.getExtendedEntityManagerMap().get(emf);
    }

    public Collection<EntityManager> getExtendedEntityManagers() {
        return this.getExtendedEntityManagerMap().values();
    }

    private Set<EntityManagerFactory> getEmfsRegisteredWithTx() {
        if (this.emfsRegisteredWithTx == null) {
            this.emfsRegisteredWithTx = new HashSet<EntityManagerFactory>();
        }
        return this.emfsRegisteredWithTx;
    }

    public void setEmfRegisteredWithTx(EntityManagerFactory emf, boolean flag) {
        if (flag) {
            this.getEmfsRegisteredWithTx().add(emf);
        } else {
            this.getEmfsRegisteredWithTx().remove(emf);
        }
    }

    public boolean isEmfRegisteredWithTx(EntityManagerFactory emf) {
        return this.getEmfsRegisteredWithTx().contains(emf);
    }

    public TimerService getTimerService() throws IllegalStateException {
        if (this.isStateful) {
            throw new IllegalStateException("EJBTimer Service is not accessible to Stateful Session ejbs");
        }
        if (this.instanceKey == null) {
            throw new IllegalStateException("Operation not allowed");
        }
        EJBTimerService timerService = EjbContainerUtilImpl.getInstance().getEJBTimerService();
        if (timerService == null) {
            throw new EJBException("EJB Timer service not available");
        }
        return new EJBTimerServiceWrapper(timerService, this);
    }

    @Override
    public UserTransaction getUserTransaction() throws IllegalStateException {
        if (this.state == EJBContextImpl.BeanState.CREATED && this.instanceKey == null) {
            throw new IllegalStateException("Operation not allowed");
        }
        return ((BaseContainer)this.getContainer()).getUserTransaction();
    }

    public MessageContext getMessageContext() {
        if (this.isStateless) {
            InvocationManager invManager = EjbContainerUtilImpl.getInstance().getInvocationManager();
            try {
                ComponentInvocation inv = invManager.getCurrentInvocation();
                if (inv != null && this.isWebServiceInvocation(inv)) {
                    return ((EjbInvocation)inv).messageContext;
                }
                throw new IllegalStateException("Attempt to access MessageContext outside of a web service invocation");
            }
            catch (Exception e) {
                IllegalStateException ise = new IllegalStateException();
                ise.initCause(e);
                throw ise;
            }
        }
        throw new IllegalStateException("Attempt to access MessageContext from stateful session ejb");
    }

    public <T> T getBusinessObject(Class<T> businessInterface) throws IllegalStateException {
        if (this.instanceKey == null) {
            throw new IllegalStateException("Operation not allowed");
        }
        Object businessObject = null;
        EjbDescriptor ejbDesc = this.container.getEjbDescriptor();
        if (businessInterface != null) {
            String intfName = businessInterface.getName();
            if (this.ejbLocalBusinessObjectImpl != null && ejbDesc.getLocalBusinessClassNames().contains(intfName)) {
                businessObject = this.ejbLocalBusinessObjectImpl.getClientObject(intfName);
            } else if (this.ejbRemoteBusinessObjectImpl == null || ejbDesc.getRemoteBusinessClassNames().contains(intfName)) {
                // empty if block
            }
        }
        if (businessObject == null) {
            throw new IllegalStateException("Invalid business interface : " + businessInterface + " for ejb " + ejbDesc.getName());
        }
        return (T)businessObject;
    }

    public Class getInvokedBusinessInterface() throws IllegalStateException {
        Class businessInterface = null;
        try {
            ComponentInvocation inv = EjbContainerUtilImpl.getInstance().getCurrentInvocation();
            if (inv != null && inv instanceof EjbInvocation) {
                EjbInvocation invocation = (EjbInvocation)inv;
                if (invocation.isBusinessInterface) {
                    businessInterface = invocation.clientInterface;
                }
            }
        }
        catch (Exception e) {
            IllegalStateException ise = new IllegalStateException();
            ise.initCause(e);
            throw ise;
        }
        if (businessInterface == null) {
            throw new IllegalStateException("Attempt to call getInvokedBusinessInterface outside the scope of a business method");
        }
        return businessInterface;
    }

    @Override
    protected void checkAccessToCallerSecurity() throws IllegalStateException {
        if (this.isStateless ? this.state == EJBContextImpl.BeanState.CREATED || this.inEjbRemove : this.state == EJBContextImpl.BeanState.CREATED) {
            throw new IllegalStateException("Operation not allowed");
        }
    }

    @Override
    public void checkTimerServiceMethodAccess() throws IllegalStateException {
        ComponentInvocation compInv = this.getCurrentComponentInvocation();
        if (this.isStateful && (this.inStatefulSessionEjbCreate(compInv) || this.inActivatePassivate(compInv) || this.inAfterCompletion)) {
            throw new IllegalStateException("EJB Timer methods for stateful session beans cannot be  called in this context");
        }
        if (this.state == EJBContextImpl.BeanState.CREATED || this.inEjbRemove) {
            throw new IllegalStateException("EJB Timer method calls cannot be called in this context");
        }
    }

    public Object getInstanceKey() {
        return this.instanceKey;
    }

    public void setInstanceKey(Object instanceKey) {
        this.instanceKey = instanceKey;
    }

    boolean getCompletedTxStatus() {
        return this.completedTxStatus;
    }

    void setCompletedTxStatus(boolean s) {
        this.completedTxStatus = s;
    }

    boolean isAfterCompletionDelayed() {
        return this.afterCompletionDelayed;
    }

    void setAfterCompletionDelayed(boolean s) {
        this.afterCompletionDelayed = s;
    }

    boolean isTxCompleting() {
        return this.committing;
    }

    void setTxCompleting(boolean s) {
        this.committing = s;
    }

    void setInAfterCompletion(boolean flag) {
        this.inAfterCompletion = flag;
    }

    private ComponentInvocation getCurrentComponentInvocation() {
        BaseContainer container = (BaseContainer)this.getContainer();
        return container.invocationManager.getCurrentInvocation();
    }

    private boolean isWebServiceInvocation(ComponentInvocation inv) {
        return inv instanceof EjbInvocation && ((EjbInvocation)inv).isWebService;
    }

    private boolean inStatefulSessionEjbCreate(ComponentInvocation inv) {
        boolean inEjbCreate = false;
        if (inv instanceof EjbInvocation) {
            Class clientIntf = ((EjbInvocation)inv).clientInterface;
            inEjbCreate = ((EjbInvocation)inv).isHome && (EJBHome.class.isAssignableFrom(clientIntf) || EJBLocalHome.class.isAssignableFrom(clientIntf));
        }
        return inEjbCreate;
    }

    void setTxCheckpointDelayed(boolean val) {
        this.txCheckpointDelayed = val;
    }

    boolean isTxCheckpointDelayed() {
        return this.txCheckpointDelayed;
    }

    long getLastPersistedAt() {
        return this.lastPersistedAt;
    }

    void setLastPersistedAt(long val) {
        this.lastPersistedAt = val;
    }

    public long getVersion() {
        return this.version;
    }

    public long incrementAndGetVersion() {
        return ++this.version;
    }

    public void setVersion(long newVersion) {
        this.version = newVersion;
    }

    public long getLastAccessTime() {
        return this.getLastTimeUsed();
    }

    public boolean canBePassivated() {
        return this.state == EJBContextImpl.BeanState.READY;
    }

    public boolean hasExtendedPC() {
        return this.getExtendedEntityManagerMap().size() != 0;
    }

    public SessionContext getSessionContext() {
        return this;
    }

    public boolean existsInStore() {
        return this.existsInSessionStore;
    }

    public void setExistsInStore(boolean val) {
        this.existsInSessionStore = val;
    }

    public final void incrementRefCount() {
        ++this.refCount;
    }

    public final void decrementRefCount() {
        --this.refCount;
    }

    public final int getRefCount() {
        return this.refCount;
    }
}

