/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.containers;

import com.sun.ejb.containers.BaseContainer;
import com.sun.ejb.containers.ContainerSynchronization;
import com.sun.ejb.containers.EJBContextImpl;
import com.sun.ejb.containers.EJBTimerService;
import com.sun.ejb.containers.EjbContainerUtil;
import com.sun.ejb.containers.EjbContainerUtilImpl;
import com.sun.ejb.containers.TimerLocal;
import com.sun.ejb.containers.TimerPrimaryKey;
import com.sun.ejb.containers.TimerState;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.logging.LogDomains;
import java.io.IOException;
import java.io.Serializable;
import java.sql.Connection;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.CreateException;
import javax.ejb.EJBContext;
import javax.ejb.EntityContext;
import javax.ejb.FinderException;
import javax.ejb.SessionContext;
import javax.ejb.Stateless;
import javax.naming.InitialContext;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.sql.DataSource;
import javax.transaction.Synchronization;
import javax.transaction.Transaction;
import org.glassfish.api.invocation.ComponentInvocation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Stateless
public class TimerBean
implements TimerLocal {
    private static final Logger logger = LogDomains.getLogger(TimerBean.class, (String)"javax.enterprise.system.container.ejb");
    private EJBContextImpl context_;
    @PersistenceContext(unitName="__EJB__Timer__App")
    private EntityManager em;
    private boolean blobLoaded_;
    private Object timedObjectPrimaryKey_;
    private transient Serializable info_;

    @Override
    public TimerState findTimer(TimerPrimaryKey timerId) {
        return (TimerState)this.em.find(TimerState.class, (Object)timerId);
    }

    @Override
    public Set findTimerIdsByContainer(long containerId) {
        Query q = this.em.createNamedQuery("findTimerIdsByContainer");
        q.setParameter(1, (Object)containerId);
        return this.toPKeys(q.getResultList());
    }

    public Set findTimerIdsByContainerAndState(long containerId, int state) {
        Query q = this.em.createNamedQuery("findTimerIdsByContainerAndState");
        q.setParameter(1, (Object)containerId);
        q.setParameter(2, (Object)state);
        return this.toPKeys(q.getResultList());
    }

    public Set findTimerIdsByContainerAndOwner(long containerId, String ownerId) {
        Query q = this.em.createNamedQuery("findTimerIdsByContainerAndOwner");
        q.setParameter(1, (Object)containerId);
        q.setParameter(2, (Object)ownerId);
        return this.toPKeys(q.getResultList());
    }

    public Set findTimerIdsByContainerAndOwnerAndState(long containerId, String ownerId, int state) {
        Query q = this.em.createNamedQuery("findTimerIdsByContainerAndOwnerAndState");
        q.setParameter(1, (Object)containerId);
        q.setParameter(2, (Object)ownerId);
        q.setParameter(3, (Object)state);
        return this.toPKeys(q.getResultList());
    }

    public Set findTimerIdsByOwner(String ownerId) {
        Query q = this.em.createNamedQuery("findTimerIdsByOwner");
        q.setParameter(1, (Object)ownerId);
        return this.toPKeys(q.getResultList());
    }

    public Set findTimerIdsByOwnerAndState(String ownerId, int state) {
        Query q = this.em.createNamedQuery("findTimerIdsByOwnerAndState");
        q.setParameter(1, (Object)ownerId);
        q.setParameter(2, (Object)state);
        return this.toPKeys(q.getResultList());
    }

    @Override
    public Set findTimersByContainer(long containerId) {
        Query q = this.em.createNamedQuery("findTimersByContainer");
        q.setParameter(1, (Object)containerId);
        return new HashSet(q.getResultList());
    }

    public Set findTimersByContainerAndState(long containerId, int state) {
        Query q = this.em.createNamedQuery("findTimersByContainerAndState");
        q.setParameter(1, (Object)containerId);
        q.setParameter(2, (Object)state);
        return new HashSet(q.getResultList());
    }

    public Set findTimersByContainerAndOwner(long containerId, String ownerId) {
        Query q = this.em.createNamedQuery("findTimersByContainerAndOwner");
        q.setParameter(1, (Object)containerId);
        q.setParameter(2, (Object)ownerId);
        return new HashSet(q.getResultList());
    }

    public Set findTimersByContainerAndOwnerAndState(long containerId, String ownerId, int state) {
        Query q = this.em.createNamedQuery("findTimersByContainerAndOwnerAndState");
        q.setParameter(1, (Object)containerId);
        q.setParameter(2, (Object)ownerId);
        q.setParameter(3, (Object)state);
        return new HashSet(q.getResultList());
    }

    private Set findTimersByOwner(String ownerId) {
        Query q = this.em.createNamedQuery("findTimersByOwner");
        q.setParameter(1, (Object)ownerId);
        return new HashSet(q.getResultList());
    }

    public Set findTimersByOwnerAndState(String ownerId, int state) {
        Query q = this.em.createNamedQuery("findTimersByOwnerAndState");
        q.setParameter(1, (Object)ownerId);
        q.setParameter(2, (Object)state);
        return new HashSet(q.getResultList());
    }

    @Override
    public int countTimersByContainer(long containerId) {
        Query q = this.em.createNamedQuery("countTimersByContainer");
        q.setParameter(1, (Object)containerId);
        return ((Number)q.getSingleResult()).intValue();
    }

    public int countTimersByContainerAndState(long containerId, int state) {
        Query q = this.em.createNamedQuery("countTimersByContainerAndState");
        q.setParameter(1, (Object)containerId);
        q.setParameter(2, (Object)state);
        return ((Number)q.getSingleResult()).intValue();
    }

    public int countTimersByContainerAndOwner(long containerId, String ownerId) {
        Query q = this.em.createNamedQuery("countTimersByContainerAndOwner");
        q.setParameter(1, (Object)containerId);
        q.setParameter(2, (Object)ownerId);
        return ((Number)q.getSingleResult()).intValue();
    }

    public int countTimersByContainerAndOwnerAndState(long containerId, String ownerId, int state) {
        Query q = this.em.createNamedQuery("countTimersByContainerAndOwnerAndState");
        q.setParameter(1, (Object)containerId);
        q.setParameter(2, (Object)ownerId);
        q.setParameter(3, (Object)state);
        return ((Number)q.getSingleResult()).intValue();
    }

    public int countTimersByOwner(String ownerId) {
        Query q = this.em.createNamedQuery("countTimersByOwner");
        q.setParameter(1, (Object)ownerId);
        return ((Number)q.getSingleResult()).intValue();
    }

    public int countTimersByOwnerAndState(String ownerId, int state) {
        Query q = this.em.createNamedQuery("countTimersByOwnerAndState");
        q.setParameter(1, (Object)ownerId);
        q.setParameter(2, (Object)state);
        return ((Number)q.getSingleResult()).intValue();
    }

    @Override
    public TimerState createTimer(String timerId, long containerId, String ownerId, Object timedObjectPrimaryKey, Date initialExpiration, long intervalDuration, Serializable info) throws CreateException {
        TimerState timer = null;
        try {
            timer = new TimerState(timerId, containerId, ownerId, timedObjectPrimaryKey, initialExpiration, intervalDuration, info);
        }
        catch (IOException ioe) {
            CreateException ce = new CreateException();
            ce.initCause((Throwable)ioe);
            throw ce;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "TimerBean.createTimer() ::timerId=" + timer.getTimerId() + " ::containerId=" + timer.getContainerId() + " ::timedObjectPK=" + timedObjectPrimaryKey + " ::info=" + info + " ::initialExpiration=" + initialExpiration + " ::intervalDuration=" + intervalDuration + " :::state=" + timer.stateToString() + " :::creationTime=" + timer.getCreationTime() + " :::ownerId=" + timer.getOwnerId());
        }
        if (this.timerOwnedByThisServer(timer)) {
            TimerSynch timerSynch = new TimerSynch(new TimerPrimaryKey(timer.getTimerId()), 0, timer.getInitialExpiration(), TimerBean.getContainer(containerId));
            try {
                ContainerSynchronization containerSynch = this.getContainerSynch(timer);
                containerSynch.addTimerSynchronization(new TimerPrimaryKey(timer.getTimerId()), timerSynch);
            }
            catch (Exception e) {
                CreateException ce = new CreateException();
                ce.initCause((Throwable)e);
                throw ce;
            }
        }
        this.em.persist((Object)timer);
        return timer;
    }

    private boolean timerOwnedByThisServer(TimerState timer) {
        String ownerIdOfThisServer = this.getOwnerIdOfThisServer();
        return ownerIdOfThisServer != null && ownerIdOfThisServer.equals(timer.getOwnerId());
    }

    private String getOwnerIdOfThisServer() {
        return TimerBean.getEJBTimerService().getOwnerIdOfThisServer();
    }

    private static String txStatusToString(int txStatus) {
        String txStatusStr = "UNMATCHED TX STATUS";
        switch (txStatus) {
            case 0: {
                txStatusStr = "TX_STATUS_ACTIVE";
                break;
            }
            case 3: {
                txStatusStr = "TX_STATUS_COMMITTED";
                break;
            }
            case 8: {
                txStatusStr = "TX_STATUS_COMMITTING";
                break;
            }
            case 1: {
                txStatusStr = "TX_STATUS_MARKED_ROLLBACK";
                break;
            }
            case 6: {
                txStatusStr = "TX_STATUS_NO_TRANSACTION";
                break;
            }
            case 2: {
                txStatusStr = "TX_STATUS_PREPARED";
                break;
            }
            case 7: {
                txStatusStr = "TX_STATUS_PREPARING";
                break;
            }
            case 4: {
                txStatusStr = "TX_STATUS_ROLLEDBACK";
                break;
            }
            case 9: {
                txStatusStr = "TX_STATUS_ROLLING_BACK";
                break;
            }
            case 5: {
                txStatusStr = "TX_STATUS_UNKNOWN";
                break;
            }
            default: {
                txStatusStr = "UNMATCHED TX STATUS";
            }
        }
        return txStatusStr;
    }

    private ContainerSynchronization getContainerSynch(TimerState timer) throws Exception {
        ComponentInvocation i;
        Transaction transaction = this.context_.getTransaction();
        EjbContainerUtil ejbContainerUtil = EjbContainerUtilImpl.getInstance();
        if (transaction == null && (transaction = (Transaction)(i = ejbContainerUtil.getCurrentInvocation()).getTransaction()) != null) {
            logger.log(Level.WARNING, "Context transaction = null. Using invocation instead.", new Throwable());
        }
        if (transaction == null) {
            throw new Exception("transaction = null in getContainerSynch for timerId = " + timer.getTimerId());
        }
        return ejbContainerUtil.getContainerSync(transaction);
    }

    private static EJBTimerService getEJBTimerService() {
        return EjbContainerUtilImpl.getInstance().getEJBTimerService();
    }

    public void setSessionContext(SessionContext context) {
        this.context_ = (EJBContextImpl)context;
    }

    @Override
    public void remove(TimerPrimaryKey timerId) {
        TimerState timer = (TimerState)this.em.find(TimerState.class, (Object)timerId);
        if (timer != null) {
            this.em.remove((Object)timer);
        }
    }

    @Override
    public void remove(Set<TimerPrimaryKey> timerIds) {
        for (TimerPrimaryKey timerId : timerIds) {
            try {
                this.remove(timerId);
            }
            catch (Exception e) {
                logger.log(Level.FINE, "Cannot remove timer " + timerId + " for unknown container ", e);
            }
        }
    }

    @Override
    public void cancel(TimerPrimaryKey timerId) throws FinderException, Exception {
        TimerState timer = (TimerState)this.em.find(TimerState.class, (Object)timerId);
        if (timer == null) {
            throw new FinderException("timer " + timerId + " does not exist");
        }
        if (timer.getState() == 1) {
            return;
        }
        timer.setState(1);
        if (this.timerOwnedByThisServer(timer)) {
            Date nextTimeout = TimerBean.getEJBTimerService().cancelTask(timerId);
            ContainerSynchronization containerSynch = this.getContainerSynch(timer);
            Synchronization timerSynch = containerSynch.getTimerSynchronization(timerId);
            if (timerSynch != null) {
                containerSynch.removeTimerSynchronization(timerId);
                TimerBean.getEJBTimerService().expungeTimer(timerId);
            } else {
                timerSynch = new TimerSynch(timerId, 1, nextTimeout, TimerBean.getContainer(timer.getContainerId()));
                containerSynch.addTimerSynchronization(timerId, timerSynch);
            }
        }
        this.em.remove((Object)timer);
    }

    @Override
    public void cancelTimers(Collection<TimerState> timers) {
        for (TimerState timer : timers) {
            try {
                this.em.remove((Object)timer);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "ejb.cancel_entity_timer", new Object[]{timer.getTimerId()});
                logger.log(Level.WARNING, "", e);
            }
        }
    }

    private Set toPKeys(Collection ids) {
        HashSet<TimerPrimaryKey> pkeys = new HashSet<TimerPrimaryKey>();
        Iterator iter = ids.iterator();
        while (iter.hasNext()) {
            pkeys.add(new TimerPrimaryKey((String)iter.next()));
        }
        return pkeys;
    }

    @Override
    public Set findActiveTimerIdsByContainer(long containerId) {
        return this.findTimerIdsByContainerAndState(containerId, 0);
    }

    @Override
    public Set findCancelledTimerIdsByContainer(long containerId) {
        return this.findTimerIdsByContainerAndState(containerId, 1);
    }

    @Override
    public Set findTimerIdsOwnedByThisServerByContainer(long containerId) {
        return this.findTimerIdsByContainerAndOwner(containerId, this.getOwnerIdOfThisServer());
    }

    @Override
    public Set findActiveTimerIdsOwnedByThisServerByContainer(long containerId) {
        return this.findTimerIdsByContainerAndOwnerAndState(containerId, this.getOwnerIdOfThisServer(), 0);
    }

    @Override
    public Set findCancelledTimerIdsOwnedByThisServerByContainer(long containerId) {
        return this.findTimerIdsByContainerAndOwnerAndState(containerId, this.getOwnerIdOfThisServer(), 1);
    }

    @Override
    public Set findTimerIdsOwnedByThisServer() {
        return this.findTimerIdsByOwner(this.getOwnerIdOfThisServer());
    }

    @Override
    public Set findActiveTimerIdsOwnedByThisServer() {
        return this.findTimerIdsByOwnerAndState(this.getOwnerIdOfThisServer(), 0);
    }

    @Override
    public Set findCancelledTimerIdsOwnedByThisServer() {
        return this.findTimerIdsByOwnerAndState(this.getOwnerIdOfThisServer(), 1);
    }

    @Override
    public Set findTimerIdsOwnedBy(String ownerId) {
        return this.findTimerIdsByOwner(ownerId);
    }

    @Override
    public Set findActiveTimerIdsOwnedBy(String ownerId) {
        return this.findTimerIdsByOwnerAndState(ownerId, 0);
    }

    @Override
    public Set findCancelledTimerIdsOwnedBy(String ownerId) {
        return this.findTimerIdsByOwnerAndState(ownerId, 1);
    }

    @Override
    public Set findActiveTimersByContainer(long containerId) {
        return this.findTimersByContainerAndState(containerId, 0);
    }

    @Override
    public Set findCancelledTimersByContainer(long containerId) {
        return this.findTimersByContainerAndState(containerId, 1);
    }

    @Override
    public Set findTimersOwnedByThisServerByContainer(long containerId) {
        return this.findTimersByContainerAndOwner(containerId, this.getOwnerIdOfThisServer());
    }

    @Override
    public Set findActiveTimersOwnedByThisServerByContainer(long containerId) {
        return this.findTimersByContainerAndOwnerAndState(containerId, this.getOwnerIdOfThisServer(), 0);
    }

    @Override
    public Set findCancelledTimersOwnedByThisServerByContainer(long containerId) {
        return this.findTimersByContainerAndOwnerAndState(containerId, this.getOwnerIdOfThisServer(), 1);
    }

    @Override
    public Set findTimersOwnedByThisServer() {
        return this.findTimersByOwner(this.getOwnerIdOfThisServer());
    }

    @Override
    public Set findActiveTimersOwnedByThisServer() {
        return this.findTimersByOwnerAndState(this.getOwnerIdOfThisServer(), 0);
    }

    @Override
    public Set findCancelledTimersOwnedByThisServer() {
        return this.findTimersByOwnerAndState(this.getOwnerIdOfThisServer(), 1);
    }

    @Override
    public Set findTimersOwnedBy(String ownerId) {
        return this.findTimersByOwner(ownerId);
    }

    @Override
    public Set findActiveTimersOwnedBy(String ownerId) {
        return this.findTimersByOwnerAndState(ownerId, 0);
    }

    @Override
    public Set findCancelledTimersOwnedBy(String ownerId) {
        return this.findTimersByOwnerAndState(ownerId, 1);
    }

    @Override
    public int countActiveTimersByContainer(long containerId) {
        return this.countTimersByContainerAndState(containerId, 0);
    }

    @Override
    public int countCancelledTimersByContainer(long containerId) {
        return this.countTimersByContainerAndState(containerId, 1);
    }

    @Override
    public int countTimersOwnedByThisServerByContainer(long containerId) {
        return this.countTimersByContainerAndOwner(containerId, this.getOwnerIdOfThisServer());
    }

    @Override
    public int countActiveTimersOwnedByThisServerByContainer(long containerId) {
        return this.countTimersByContainerAndOwnerAndState(containerId, this.getOwnerIdOfThisServer(), 0);
    }

    @Override
    public int countCancelledTimersOwnedByThisServerByContainer(long containerId) {
        return this.countTimersByContainerAndOwnerAndState(containerId, this.getOwnerIdOfThisServer(), 1);
    }

    @Override
    public int countTimersOwnedByThisServer() {
        return this.countTimersByOwner(this.getOwnerIdOfThisServer());
    }

    @Override
    public String[] countTimersOwnedByServerIds(String[] serverIds) {
        String[] totalTimers = new String[serverIds.length];
        int i = 0;
        for (String serverId : serverIds) {
            totalTimers[i] = Integer.toString(this.countTimersOwnedBy(serverId));
            ++i;
        }
        return totalTimers;
    }

    @Override
    public int countActiveTimersOwnedByThisServer() {
        return this.countTimersByOwnerAndState(this.getOwnerIdOfThisServer(), 0);
    }

    @Override
    public int countCancelledTimersOwnedByThisServer() {
        return this.countTimersByOwnerAndState(this.getOwnerIdOfThisServer(), 1);
    }

    @Override
    public int countTimersOwnedBy(String ownerId) {
        return this.countTimersByOwner(ownerId);
    }

    @Override
    public int countActiveTimersOwnedBy(String ownerId) {
        return this.countTimersByOwnerAndState(ownerId, 0);
    }

    @Override
    public int countCancelledTimersOwnedBy(String ownerId) {
        return this.countTimersByOwnerAndState(ownerId, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean checkStatus(String resourceJndiName, boolean checkDatabase) {
        boolean success = false;
        Connection connection = null;
        InitialContext ic = new InitialContext();
        DataSource dataSource = (DataSource)ic.lookup(resourceJndiName);
        if (checkDatabase) {
            connection = dataSource.getConnection();
            connection.close();
            connection = null;
            this.countTimersByContainer(0L);
        }
        success = true;
        Object var8_8 = null;
        if (connection == null) return success;
        try {
            connection.close();
            return success;
        }
        catch (Exception e2) {
            logger.log(Level.FINE, "timer connection close exception", e2);
        }
        return success;
        {
            catch (Exception e) {
                logger.log(Level.WARNING, "ejb.timer_service_init_error", "");
                logger.log(Level.FINE, "ejb.timer_service_init_error", e);
                Object var8_9 = null;
                if (connection == null) return success;
                try {
                    connection.close();
                    return success;
                }
                catch (Exception e2) {
                    logger.log(Level.FINE, "timer connection close exception", e2);
                }
                return success;
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            if (connection == null) throw throwable;
            try {
                connection.close();
                throw throwable;
            }
            catch (Exception e2) {
                logger.log(Level.FINE, "timer connection close exception", e2);
            }
            throw throwable;
        }
    }

    @Override
    public int migrateTimers(String fromOwnerId, String toOwnerId) {
        Query q = this.em.createNamedQuery("updateTimersFromOwnerToNewOwner");
        q.setParameter("fromOwner", (Object)fromOwnerId);
        q.setParameter("toOwner", (Object)toOwnerId);
        return q.executeUpdate();
    }

    public static void testCreate(String timerId, EJBContext context, String ownerId, Date initialExpiration, long intervalDuration, Serializable info) throws CreateException {
        TimerLocal timerLocal = TimerBean.getEJBTimerService().getTimerLocal();
        EjbDescriptor ejbDesc = ((EJBContextImpl)context).getContainer().getEjbDescriptor();
        long containerId = ejbDesc.getUniqueId();
        Object timedObjectPrimaryKey = context instanceof EntityContext ? ((EntityContext)context).getPrimaryKey() : null;
        timerLocal.createTimer(timerId, containerId, ownerId, timedObjectPrimaryKey, initialExpiration, intervalDuration, info);
    }

    public static void testMigrate(String fromOwnerId) {
        EJBTimerService ejbTimerService = TimerBean.getEJBTimerService();
        ejbTimerService.migrateTimers(fromOwnerId);
    }

    public static BaseContainer getContainer(long containerId) {
        return EjbContainerUtilImpl.getInstance().getContainer(containerId);
    }

    private static class TimerSynch
    implements Synchronization {
        private TimerPrimaryKey timerId_;
        private int state_;
        private Date timeout_;
        private BaseContainer container_;

        public TimerSynch(TimerPrimaryKey timerId, int state, Date timeout, BaseContainer container) {
            this.timerId_ = timerId;
            this.state_ = state;
            this.timeout_ = timeout;
            this.container_ = container;
        }

        public void afterCompletion(int status) {
            EJBTimerService timerService = TimerBean.getEJBTimerService();
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "TimerSynch::afterCompletion. timer state = " + TimerState.stateToString(this.state_) + " , " + "timer id = " + this.timerId_ + " , JTA TX status = " + TimerBean.txStatusToString(status) + " , " + "timeout = " + this.timeout_);
            }
            switch (this.state_) {
                case 0: {
                    if (status == 3) {
                        timerService.scheduleTask(this.timerId_, this.timeout_);
                        break;
                    }
                    timerService.expungeTimer(this.timerId_);
                    break;
                }
                case 1: {
                    if (status == 4) {
                        if (this.timeout_ != null) {
                            timerService.scheduleTask(this.timerId_, this.timeout_);
                            break;
                        }
                        timerService.restoreTaskToDelivered(this.timerId_);
                        break;
                    }
                    timerService.expungeTimer(this.timerId_);
                }
            }
        }

        public void beforeCompletion() {
        }
    }
}

