/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.containers.interceptors;

import com.sun.ejb.EjbInvocation;
import com.sun.ejb.containers.EJBContextImpl;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.ejb.EJBException;

class AroundInvokeInterceptor {
    protected int index;
    protected Method method;

    AroundInvokeInterceptor(int index, Method method) {
        this.index = index;
        this.method = method;
        try {
            final Method finalM = method;
            if (System.getSecurityManager() == null) {
                if (!finalM.isAccessible()) {
                    finalM.setAccessible(true);
                }
            } else {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        if (!finalM.isAccessible()) {
                            finalM.setAccessible(true);
                        }
                        return null;
                    }
                });
            }
        }
        catch (Exception e) {
            throw new EJBException(e);
        }
    }

    Object intercept(final EjbInvocation invCtx) throws Throwable {
        try {
            final Object[] interceptors = ((EJBContextImpl)invCtx.context).getInterceptorInstances();
            if (System.getSecurityManager() != null) {
                return AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        return AroundInvokeInterceptor.this.method.invoke(interceptors[AroundInvokeInterceptor.this.index], new Object[]{invCtx});
                    }
                });
            }
            return this.method.invoke(interceptors[this.index], new Object[]{invCtx});
        }
        catch (InvocationTargetException invEx) {
            throw invEx.getCause();
        }
        catch (PrivilegedActionException paEx) {
            Throwable th = paEx.getCause();
            if (th.getCause() != null) {
                throw th.getCause();
            }
            throw th;
        }
    }

    public String toString() {
        return "[" + this.index + "]: " + this.method;
    }
}

