/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ejb.deployment.annotation.handlers;

import com.sun.enterprise.deployment.EjbDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import javax.ejb.DependsOn;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import org.glassfish.apf.AnnotationInfo;
import org.glassfish.apf.AnnotationProcessorException;
import org.glassfish.apf.HandlerProcessingResult;
import org.glassfish.ejb.deployment.EjbSingletonDescriptor;
import org.glassfish.ejb.deployment.annotation.handlers.AbstractEjbHandler;
import org.jvnet.hk2.annotations.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class SingletonHandler
extends AbstractEjbHandler {
    public SingletonHandler() {
        System.out.println("Created SingletonHandler......");
    }

    public Class<? extends Annotation> getAnnotationType() {
        return Singleton.class;
    }

    @Override
    protected String getAnnotatedName(Annotation annotation) {
        Singleton slAn = (Singleton)annotation;
        return slAn.name();
    }

    @Override
    protected boolean isValidEjbDescriptor(EjbDescriptor ejbDesc, Annotation annotation) {
        return "Session".equals(ejbDesc.getType());
    }

    @Override
    protected EjbDescriptor createEjbDescriptor(String elementName, AnnotationInfo ainfo) throws AnnotationProcessorException {
        AnnotatedElement ae = ainfo.getAnnotatedElement();
        Class ejbClass = (Class)ae;
        EjbSingletonDescriptor newDescriptor = new EjbSingletonDescriptor();
        newDescriptor.setName(elementName);
        newDescriptor.setEjbClassName(ejbClass.getName());
        newDescriptor.setSingletonClass(ejbClass);
        this.doSingletonSpecificProcessing(newDescriptor);
        return newDescriptor;
    }

    @Override
    protected HandlerProcessingResult setEjbDescriptorInfo(EjbDescriptor ejbDesc, AnnotationInfo ainfo) throws AnnotationProcessorException {
        EjbSingletonDescriptor ejbSingletonDescriptor = (EjbSingletonDescriptor)ejbDesc;
        Singleton singleton = (Singleton)ainfo.getAnnotation();
        this.doDescriptionProcessing(singleton.description(), ejbDesc);
        this.doMappedNameProcessing(singleton.mappedName(), ejbDesc);
        this.doSingletonSpecificProcessing(ejbSingletonDescriptor);
        return this.setBusinessAndHomeInterfaces(ejbDesc, ainfo);
    }

    private void doSingletonSpecificProcessing(EjbSingletonDescriptor desc) {
        DependsOn dep;
        Class clz = desc.getSingletonClass();
        Startup st = clz.getAnnotation(Startup.class);
        if (st != null) {
            desc.setStartup();
        }
        if ((dep = clz.getAnnotation(DependsOn.class)) != null) {
            desc.setDepends(dep.value());
        }
    }
}

