/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ejb.startup;

import com.sun.ejb.Container;
import com.sun.ejb.ContainerFactory;
import com.sun.ejb.containers.ContainerFactoryImpl;
import com.sun.ejb.containers.EJBTimerService;
import com.sun.ejb.containers.EjbContainerUtilImpl;
import com.sun.ejb.containers.SingletonContainer;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import org.glassfish.api.deployment.ApplicationContainer;
import org.glassfish.api.deployment.ApplicationContext;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.ejb.security.application.EJBSecurityManager;
import org.glassfish.ejb.security.factory.EJBSecurityManagerFactory;
import org.glassfish.ejb.startup.SingletonLifeCycleManager;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(name="ejb")
@Scoped(value=PerLookup.class)
public class EjbApplication
implements ApplicationContainer<Collection<EjbDescriptor>> {
    String appName;
    ContainerFactory ejbContainerFactory;
    Collection<EjbDescriptor> ejbs;
    Collection<Container> containers = new ArrayList<Container>();
    ClassLoader ejbAppClassLoader;
    DeploymentContext dc;
    @Inject
    EJBSecurityManagerFactory ejbSMF;
    SingletonLifeCycleManager singletonLCM;
    private static boolean restored = false;
    private static Object lock = new Object();
    private static final char NAME_PART_SEPARATOR = '_';
    private static final char NAME_CONCATENATOR = ' ';

    public EjbApplication(Collection<EjbDescriptor> bundleDesc, DeploymentContext dc, ClassLoader cl) {
        this.ejbContainerFactory = new ContainerFactoryImpl();
        this.ejbs = bundleDesc;
        this.ejbAppClassLoader = cl;
        this.appName = "";
        this.dc = dc;
    }

    public Collection<EjbDescriptor> getDescriptor() {
        return this.ejbs;
    }

    public boolean start(ApplicationContext startupContext) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean loadAndStartContainers(ApplicationContext startupContext) {
        boolean counter = false;
        this.singletonLCM = new SingletonLifeCycleManager();
        for (EjbDescriptor desc : this.ejbs) {
            desc.setUniqueId(this.getUniqueId(desc));
            try {
                EJBSecurityManager ejbSM = null;
                Container container = this.ejbContainerFactory.createContainer(desc, this.ejbAppClassLoader, ejbSM, this.dc);
                this.containers.add(container);
                if (!(container instanceof SingletonContainer)) continue;
                this.singletonLCM.addSingletonContainer((SingletonContainer)container);
            }
            catch (Throwable th) {
                throw new RuntimeException("Error during EjbApplication.start() ", th);
            }
        }
        for (Container container : this.containers) {
            container.doAfterApplicationDeploy();
        }
        this.singletonLCM.doStartup();
        Object object = lock;
        synchronized (object) {
            EJBTimerService ejbTimerService;
            System.out.println("==> Restore Timers? == " + restored);
            if (!restored && (ejbTimerService = EjbContainerUtilImpl.getInstance().getEJBTimerService()) != null) {
                restored = ejbTimerService.restoreEJBTimers();
                System.out.println("==> Restored Timers? == " + restored);
            }
        }
        return true;
    }

    public boolean stop(ApplicationContext stopContext) {
        for (Container container : this.containers) {
            container.onShutdown();
        }
        return true;
    }

    public boolean suspend() {
        return false;
    }

    public boolean resume() {
        return false;
    }

    public ClassLoader getClassLoader() {
        return this.ejbAppClassLoader;
    }

    private long getUniqueId(EjbDescriptor desc) {
        EjbBundleDescriptor bundle = desc.getEjbBundleDescriptor();
        Application application = bundle.getApplication();
        StringBuffer rc = new StringBuffer().append(desc.getName()).append(' ').append(application.getRegistrationName());
        if (!application.isVirtual()) {
            rc.append(' ').append(bundle.getModuleDescriptor().getArchiveUri());
        }
        return rc.toString().hashCode();
    }

    protected void undeploy() {
        for (Container container : this.containers) {
            container.undeploy();
        }
        this.containers.clear();
    }
}

