/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ejb.startup;

import com.sun.ejb.Container;
import com.sun.ejb.containers.SingletonContainer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.StringTokenizer;
import org.glassfish.ejb.deployment.EjbSingletonDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SingletonLifeCycleManager {
    Set<String> names = new HashSet<String>();
    Map<String, Set<String>> initialDependency = new HashMap<String, Set<String>>();
    Map<String, Integer> name2Index = new HashMap<String, Integer>();
    Map<Integer, String> index2Name = new HashMap<Integer, String>();
    Set<String> leafNodes = new HashSet<String>();
    int maxIndex = 0;
    boolean[][] adj;
    Set<Container> initializedSingletons = new HashSet<Container>();
    private Map<String, SingletonContainer> name2Container = new HashMap<String, SingletonContainer>();

    public void addSingletonContainer(SingletonContainer c) {
        c.setSingletonLifeCycleManager(this);
        EjbSingletonDescriptor sdesc = (EjbSingletonDescriptor)c.getEjbDescriptor();
        String modName = sdesc.getEjbBundleDescriptor().getName();
        String src = sdesc.getName();
        String[] depends = sdesc.getDepends();
        this.addDependency(src, depends);
        this.name2Container.put(src, c);
    }

    public void doStartup() {
        EjbSingletonDescriptor sdesc;
        int i;
        SingletonContainer[] partialOrder = this.getPartiallyOrderedSingletonDescriptors();
        int orderSz = partialOrder.length;
        StringBuilder sb = new StringBuilder("[**]Singleton partial order: ");
        for (i = 0; i < orderSz; ++i) {
            sdesc = (EjbSingletonDescriptor)partialOrder[i].getEjbDescriptor();
            String name = sdesc.getName();
            sb.append(name).append(sdesc.isStartup() ? "* " : " ");
        }
        System.out.println(sb.toString());
        for (i = 0; i < orderSz; ++i) {
            sdesc = (EjbSingletonDescriptor)partialOrder[i].getEjbDescriptor();
            String s = sdesc.getName();
            if (!sdesc.isStartup()) continue;
            this.initializeSingleton(this.name2Container.get(s));
        }
    }

    public void initializeSingleton(SingletonContainer c) {
        if (!this.initializedSingletons.contains(c)) {
            List<String> computedDeps = this.computeDependencies(c.getEjbDescriptor().getName());
            int sz = computedDeps.size();
            SingletonContainer[] deps = new SingletonContainer[sz];
            for (int i = 0; i < sz; ++i) {
                deps[i] = this.name2Container.get(computedDeps.get(i));
                this.initializeSingleton(deps[i]);
            }
            c.instantiateSingletonInstance();
            this.initializedSingletons.add(c);
        }
    }

    public void addDependency(String src, String[] depends) {
        if (depends != null && depends.length > 0) {
            for (String s : depends) {
                this.addDependency(src, s);
            }
        } else {
            this.addDependency(src, "");
        }
    }

    public void addDependency(String src, List<String> depends) {
        if (depends != null) {
            for (String s : depends) {
                this.addDependency(src, s);
            }
        } else {
            this.addDependency(src, "");
        }
    }

    public void addDependency(String src, String depends) {
        src = src.trim();
        Set<String> deps = this.getExistingDependecyList(src);
        StringTokenizer tok = new StringTokenizer(depends, " ,");
        while (tok.hasMoreTokens()) {
            String dep = tok.nextToken();
            deps.add(dep);
            this.getExistingDependecyList(dep);
        }
    }

    public String[] getPartialOrdering() {
        if (this.adj == null) {
            this.fillAdjacencyMatrix();
        }
        boolean[][] tempAdj = new boolean[this.maxIndex][this.maxIndex];
        for (int i = 0; i < this.maxIndex; ++i) {
            for (int j = 0; j < this.maxIndex; ++j) {
                tempAdj[i][j] = this.adj[i][j];
            }
        }
        ArrayList<String> dependencies = new ArrayList<String>();
        do {
            String src = null;
            boolean foundAtLeastOneLeaf = false;
            for (int i = 0; i < this.maxIndex; ++i) {
                src = this.index2Name.get(i);
                if (dependencies.contains(src)) continue;
                boolean hasDep = false;
                for (int j = 0; j < this.maxIndex; ++j) {
                    if (!tempAdj[i][j]) continue;
                    hasDep = true;
                    break;
                }
                if (hasDep || dependencies.contains(src)) continue;
                dependencies.add(src);
                for (int k = 0; k < this.maxIndex; ++k) {
                    tempAdj[k][i] = false;
                }
                foundAtLeastOneLeaf = true;
            }
            if (foundAtLeastOneLeaf || dependencies.size() >= this.name2Index.size()) continue;
            throw new IllegalArgumentException("Circular dependency: " + this.getCyclicString(tempAdj));
        } while (dependencies.size() < this.name2Index.size());
        return dependencies.toArray(new String[0]);
    }

    public SingletonContainer[] getPartiallyOrderedSingletonDescriptors() {
        String[] computedDeps = this.getPartialOrdering();
        int sz = computedDeps.length;
        SingletonContainer[] deps = new SingletonContainer[sz];
        for (int i = 0; i < sz; ++i) {
            deps[i] = this.name2Container.get(computedDeps[i]);
        }
        return deps;
    }

    public List<String> computeDependencies(String root) {
        if (this.adj == null) {
            this.fillAdjacencyMatrix();
        }
        Stack<String> stk = new Stack<String>();
        stk.push(root);
        ArrayList<String> dependencies = new ArrayList<String>();
        do {
            String top = (String)stk.peek();
            int topIndex = this.name2Index.get(top);
            boolean hasDep = false;
            for (int j = 0; j < this.maxIndex; ++j) {
                if (!this.adj[topIndex][j]) continue;
                String name = this.index2Name.get(j);
                if (stk.contains(name)) {
                    String str = "Cyclic dependency: " + top + " => " + name + "? ";
                    throw new IllegalArgumentException(str + this.getCyclicString(this.adj));
                }
                if (dependencies.contains(name)) continue;
                if (this.leafNodes.contains(name)) {
                    dependencies.add(name);
                    continue;
                }
                hasDep = true;
                stk.push(name);
            }
            if (hasDep) continue;
            stk.pop();
            if (dependencies.contains(top)) continue;
            dependencies.add(top);
        } while (!stk.empty());
        dependencies.remove(dependencies.size() - 1);
        return dependencies;
    }

    private Set<String> getExistingDependecyList(String src) {
        Set<String> existingDeps = this.initialDependency.get(src);
        if (existingDeps == null) {
            existingDeps = new HashSet<String>();
            this.initialDependency.put(src, existingDeps);
            this.name2Index.put(src, this.maxIndex);
            this.index2Name.put(this.maxIndex, src);
            ++this.maxIndex;
        }
        return existingDeps;
    }

    private void fillAdjacencyMatrix() {
        this.adj = new boolean[this.maxIndex][this.maxIndex];
        for (int i = 0; i < this.maxIndex; ++i) {
            String src = this.index2Name.get(i);
            for (int j = 0; j < this.maxIndex; ++j) {
                this.adj[i][j] = false;
            }
            boolean isLeaf = true;
            Set<String> deps = this.initialDependency.get(src);
            for (String d : deps) {
                int k = this.name2Index.get(d);
                this.adj[i][k] = true;
                isLeaf = false;
            }
            if (!isLeaf) continue;
            this.leafNodes.add(src);
        }
    }

    private String getCyclicString(boolean[][] a) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.maxIndex; ++i) {
            StringBuilder sb2 = new StringBuilder("");
            String delim = "";
            for (int j = 0; j < this.maxIndex; ++j) {
                if (!a[i][j]) continue;
                sb2.append(delim).append(this.index2Name.get(j));
                delim = ", ";
            }
            String dep = sb2.toString();
            if (dep.length() <= 0) continue;
            sb.append(" ").append(this.index2Name.get(i)).append(" => ").append(sb2.toString()).append("; ");
        }
        return sb.toString();
    }

    public void printAdjacencyMatrix() {
        int i;
        if (this.adj == null) {
            this.fillAdjacencyMatrix();
        }
        System.out.print(" ");
        for (i = 0; i < this.maxIndex; ++i) {
            System.out.print(" " + this.index2Name.get(i));
        }
        System.out.println();
        for (i = 0; i < this.maxIndex; ++i) {
            System.out.print(this.index2Name.get(i) + " ");
            for (int j = 0; j < this.maxIndex; ++j) {
                System.out.print(this.adj[i][j] ? "1 " : "0 ");
            }
            System.out.println();
        }
    }

    public static void main(String[] args) {
    }

    private static void test1() {
        SingletonLifeCycleManager ts = new SingletonLifeCycleManager();
        ts.addDependency("A", "B, C");
        ts.addDependency("B", "C, D");
        ts.addDependency("D", "E");
        ts.addDependency("C", "D, E, G");
        ts.addDependency("E", "D");
        ts.getPartialOrdering();
        SingletonLifeCycleManager t = new SingletonLifeCycleManager();
        t.addDependency("C", ts.computeDependencies("C"));
        t.addDependency("D", ts.computeDependencies("D"));
        t.printAdjacencyMatrix();
        for (String s : t.computeDependencies("C")) {
            System.out.print(s + " ");
        }
        System.out.println();
        for (String s : t.getPartialOrdering()) {
            System.out.print(s + " ");
        }
    }

    private static void test2() {
        SingletonLifeCycleManager ts = new SingletonLifeCycleManager();
        ts.addDependency("A", "D, E");
        ts.addDependency("B", "F");
        ts.addDependency("C", "G, H");
        ts.addDependency("D", "I");
        ts.addDependency("E", "J");
        ts.addDependency("F", "J, K");
        ts.addDependency("H", "L");
        ts.addDependency("I", "M, N");
        ts.addDependency("J", "U");
        ts.addDependency("K", "U");
        ts.addDependency("L", "O");
        ts.addDependency("U", "N, O");
        ts.addDependency("N", "P, Q");
        ts.addDependency("O", "Q, R");
        ts.addDependency("Q", "S, T");
        ts.addDependency("E", "X, W");
        ts.addDependency("X", "Y");
        ts.addDependency("W", "Y");
        ts.addDependency("Y", "Z");
        ts.addDependency("Z", "O");
        String[] dep = ts.getPartialOrdering();
        for (String s : ts.getPartialOrdering()) {
            System.out.print(s + " ");
        }
        System.out.println();
        SingletonLifeCycleManager ts2 = new SingletonLifeCycleManager();
        ts2.addDependency("E", ts.computeDependencies("E"));
        ts2.addDependency("U", ts.computeDependencies("U"));
        ts2.addDependency("H", ts.computeDependencies("H"));
        String[] dep2 = ts2.getPartialOrdering();
        for (String s : ts2.getPartialOrdering()) {
            System.out.print(s + " ");
        }
    }

    private static void test3() {
        SingletonLifeCycleManager ts = new SingletonLifeCycleManager();
        ts.addDependency("A", (String)null);
        ts.addDependency("B", (String)null);
        ts.addDependency("C", (String)null);
        String[] dep = ts.getPartialOrdering();
        for (String s : ts.getPartialOrdering()) {
            System.out.print(s + " ");
        }
        System.out.println();
        for (String s : ts.computeDependencies("B")) {
            System.out.print(s + " ");
        }
        System.out.println();
    }

    private static void test4() {
        SingletonLifeCycleManager ts = new SingletonLifeCycleManager();
        ts.addDependency("A", "D, B, C");
        ts.addDependency("B", "F, I");
        ts.addDependency("C", "F, H, G");
        ts.addDependency("D", "E");
        ts.addDependency("E", (String)null);
        ts.addDependency("F", "E");
        ts.addDependency("G", "E, I, K");
        ts.addDependency("H", "J");
        ts.addDependency("I", "J");
        ts.addDependency("K", (List<String>)null);
        String[] dep = ts.getPartialOrdering();
        for (String s : ts.getPartialOrdering()) {
            System.out.print(s + " ");
        }
        System.out.println();
        for (String s : ts.computeDependencies("C")) {
            System.out.print(s + " ");
        }
        System.out.println();
    }
}

