/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.codegen;

import com.sun.ejb.EJBUtils;
import com.sun.ejb.codegen.ClassGeneratorFactory;
import com.sun.ejb.codegen.Generator;
import com.sun.ejb.codegen.GeneratorException;
import com.sun.ejb.codegen.IndentingWriter;
import com.sun.ejb.codegen.InvalidBean;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;

public class SerializableBeanGenerator
extends Generator
implements ClassGeneratorFactory {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(SerializableBeanGenerator.class);
    private Class beanClass;
    private String generatedSerializableClassName;
    private ClassLoader loader;

    public String getGeneratedClass() {
        return this.generatedSerializableClassName;
    }

    public String className() {
        return this.getGeneratedClass();
    }

    public SerializableBeanGenerator(ClassLoader cl, String beanClassName) throws GeneratorException {
        this.loader = cl;
        try {
            this.beanClass = cl.loadClass(beanClassName);
        }
        catch (ClassNotFoundException ex) {
            throw new InvalidBean(localStrings.getLocalString("generator.remote_interface_not_found", "Remote interface not found "));
        }
        this.generatedSerializableClassName = EJBUtils.getGeneratedSerializableClassName(beanClassName);
    }

    public void generate(OutputStream out) throws GeneratorException, IOException {
        IndentingWriter p = new IndentingWriter(new OutputStreamWriter(out));
        String packageName = this.getPackageName(this.generatedSerializableClassName);
        String simpleName = this.getBaseName(this.generatedSerializableClassName);
        p.pln("");
        if (packageName != null) {
            p.pln("package " + packageName + ";");
        }
        p.pln("");
        p.plnI("public class " + simpleName + " extends " + this.beanClass.getName() + " implements java.io.Serializable { ");
        p.pln("");
        p.plnI("private void writeObject(java.io.ObjectOutputStream oos) throws java.io.IOException {");
        p.pln("    com.sun.ejb.EJBUtils.serializeObjectFields(" + this.beanClass.getName() + ".class, this, oos);");
        p.pln("}");
        p.plnI("private void readObject(java.io.ObjectInputStream ois) throws java.io.IOException, java.lang.ClassNotFoundException {");
        p.pln("    com.sun.ejb.EJBUtils.deserializeObjectFields(" + this.beanClass.getName() + ".class, this, ois);");
        p.pln("}");
        p.pOln("}");
        p.close();
    }
}

