/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ejb.security.factory;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.security.SecurityManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.glassfish.api.invocation.InvocationManager;
import org.glassfish.ejb.security.application.EJBSecurityManager;
import org.glassfish.ejb.security.factory.AbstractSecurityManagerFactory;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.Singleton;

@Service
@Scoped(value=Singleton.class)
public final class EJBSecurityManagerFactory
extends AbstractSecurityManagerFactory {
    private Map CONTEXT_ID = new HashMap();
    @Inject
    private Habitat habitat;
    @Inject
    InvocationManager invMgr;

    public SecurityManager getSecurityManager(String contextId) {
        if (this._poolHas(contextId)) {
            return this._poolGet(contextId);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EJBSecurityManager createSecurityManager(Descriptor descriptor) {
        EJBSecurityManager ejbSM = null;
        String contextId = null;
        String appName = null;
        try {
            if (descriptor == null || !(descriptor instanceof EjbDescriptor)) {
                throw new IllegalArgumentException("Illegal Deployment Descriptor Information.");
            }
            EjbDescriptor ejbdes = (EjbDescriptor)descriptor;
            ejbSM = new EJBSecurityManager(ejbdes, this.invMgr);
            appName = ejbdes.getApplication().getRegistrationName();
            contextId = EJBSecurityManager.getContextID(ejbdes);
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "[EJB-Security] EJB Security:Creating EJBSecurityManager for contextId = " + contextId);
            }
        }
        catch (Exception e) {
            _logger.log(Level.FINE, "[EJB-Security] FATAl Exception. Unable to create EJBSecurityManager: " + e.getMessage());
            throw new RuntimeException(e);
        }
        Map map = this.CONTEXT_ID;
        synchronized (map) {
            ArrayList<String> lst = (ArrayList<String>)this.CONTEXT_ID.get(appName);
            if (lst == null) {
                lst = new ArrayList<String>();
                this.CONTEXT_ID.put(appName, lst);
            }
            if (!lst.contains(contextId)) {
                lst.add(contextId);
            }
        }
        this._poolPut(contextId, ejbSM);
        return ejbSM;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getAndRemoveContextIdForEjbAppName(String appName) {
        Map map = this.CONTEXT_ID;
        synchronized (map) {
            List contextId = (List)this.CONTEXT_ID.get(appName);
            if (contextId == null) {
                return null;
            }
            String[] rvalue = new String[contextId.size()];
            rvalue = contextId.toArray(rvalue);
            this.CONTEXT_ID.remove(appName);
            return rvalue;
        }
    }
}

