/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ejb.startup;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.RootDeploymentDescriptor;
import com.sun.enterprise.deployment.archivist.Archivist;
import com.sun.enterprise.deployment.archivist.EjbInWarArchivist;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import org.glassfish.api.deployment.ApplicationContext;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.MetaData;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.ejb.startup.EjbApplication;
import org.glassfish.ejb.startup.EjbContainerStarter;
import org.glassfish.internal.api.ServerContext;
import org.glassfish.javaee.core.deployment.JavaEEDeployer;
import org.glassfish.server.ServerEnvironmentImpl;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class EjbDeployer
extends JavaEEDeployer<EjbContainerStarter, EjbApplication> {
    @Inject
    protected ServerContext sc;
    @Inject
    protected Domain domain;
    @Inject
    protected ServerEnvironmentImpl env;
    @Inject
    protected Habitat habitat;
    protected ThreadLocal<Application> tldApp = new ThreadLocal();
    protected ConcurrentHashMap<String, EjbApplication> ejbApps = new ConcurrentHashMap();

    protected String getModuleType() {
        return "ejb";
    }

    protected RootDeploymentDescriptor getDefaultBundleDescriptor() {
        return null;
    }

    public MetaData getMetaData() {
        return new MetaData(false, new Class[]{EjbBundleDescriptor.class}, new Class[]{Application.class});
    }

    public <V> V loadMetaData(Class<V> type, DeploymentContext dc) {
        try {
            Application app = this.parseModuleMetaData(dc);
            Set ejbBD = app.getEjbBundleDescriptors();
            EjbBundleDescriptor dummy = null;
            Application dcApp = (Application)dc.getModuleMetaData(Application.class);
            if (dcApp != null) {
                dcApp.setVirtual(false);
                Iterator i$ = ejbBD.iterator();
                while (i$.hasNext()) {
                    EjbBundleDescriptor desc;
                    dummy = desc = (EjbBundleDescriptor)i$.next();
                    dcApp.addBundleDescriptor((BundleDescriptor)desc);
                }
            } else {
                dc.addModuleMetaData((Object)app);
                dcApp = app;
            }
            dcApp.setPackagedAsSingleModule(true);
            return (V)dummy;
        }
        catch (Exception e) {
            dc.getLogger().log(Level.SEVERE, e.getMessage(), e);
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    protected Application parseModuleMetaData(DeploymentContext dc) throws Exception {
        ReadableArchive sourceArchive = dc.getSource();
        boolean isWar = sourceArchive.exists("WEB-INF");
        if (isWar) {
            ClassLoader cl = dc.getClassLoader();
            Properties props = dc.getCommandParameters();
            String name = props.getProperty("name");
            Archivist archivist = (Archivist)this.habitat.getComponent(EjbInWarArchivist.class);
            archivist.setClassLoader(cl);
            archivist.setAnnotationProcessingRequested(true);
            archivist.setXMLValidation(false);
            archivist.setRuntimeXMLValidation(false);
            archivist.setDefaultBundleDescriptor((RootDeploymentDescriptor)new EjbBundleDescriptor());
            Application application = this.applicationFactory.openArchive(name, archivist, sourceArchive, true);
            if (this.deploymentVisitor != null) {
                this.deploymentVisitor.accept(application);
            }
            return application;
        }
        return super.parseModuleMetaData(dc);
    }

    public EjbApplication load(EjbContainerStarter containerStarter, DeploymentContext dc) {
        Application app = (Application)dc.getModuleMetaData(Application.class);
        if (app == null) {
            app = this.tldApp.get();
        }
        Vector ebds = app.getEjbDescriptors();
        EjbApplication ejbApp = new EjbApplication(ebds, dc, dc.getClassLoader(), this.habitat);
        String appName = dc.getCommandParameters().getProperty("name");
        this.ejbApps.put(appName, ejbApp);
        ejbApp.loadAndStartContainers((ApplicationContext)dc);
        return ejbApp;
    }

    public void unload(EjbApplication ejbApplication, DeploymentContext dc) {
        Properties params = dc.getCommandParameters();
    }

    public void clean(DeploymentContext dc) {
        String appName = dc.getCommandParameters().getProperty("name");
        EjbApplication ejbApp = this.ejbApps.get(appName);
        if (ejbApp != null) {
            ejbApp.undeploy();
        } else {
            dc.getLogger().log(Level.WARNING, "EjbApplication is null for name " + appName);
        }
    }
}

