/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ejb.startup;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.RootDeploymentDescriptor;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import org.glassfish.api.deployment.ApplicationContext;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.MetaData;
import org.glassfish.ejb.startup.EjbApplication;
import org.glassfish.ejb.startup.EjbContainerStarter;
import org.glassfish.internal.api.ServerContext;
import org.glassfish.javaee.core.deployment.JavaEEDeployer;
import org.glassfish.server.ServerEnvironmentImpl;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class EjbDeployer
extends JavaEEDeployer<EjbContainerStarter, EjbApplication> {
    @Inject
    protected ServerContext sc;
    @Inject
    protected Domain domain;
    @Inject
    protected ServerEnvironmentImpl env;
    @Inject
    protected Habitat habitat;
    protected ThreadLocal<Application> tldApp = new ThreadLocal();
    protected ConcurrentHashMap<String, EjbApplication> ejbApps = new ConcurrentHashMap();

    protected String getModuleType() {
        return "ejb";
    }

    protected RootDeploymentDescriptor getDefaultBundleDescriptor() {
        return null;
    }

    public MetaData getMetaData() {
        return new MetaData(false, new Class[]{EjbBundleDescriptor.class}, new Class[]{Application.class});
    }

    public <V> V loadMetaData(Class<V> type, DeploymentContext dc) {
        Set bundles;
        Application app;
        if (type == EjbBundleDescriptor.class && (app = (Application)dc.getModuleMetaData(Application.class)) != null && (bundles = app.getEjbBundleDescriptors()) != null && !bundles.isEmpty()) {
            return type.cast(bundles.iterator().next());
        }
        return (V)super.loadMetaData(type, dc);
    }

    public EjbApplication load(EjbContainerStarter containerStarter, DeploymentContext dc) {
        Application app = (Application)dc.getModuleMetaData(Application.class);
        if (app == null) {
            app = this.tldApp.get();
        }
        Vector ebds = app.getEjbDescriptors();
        EjbApplication ejbApp = new EjbApplication(ebds, dc, dc.getClassLoader(), this.habitat);
        String appName = dc.getCommandParameters().getProperty("name");
        this.ejbApps.put(appName, ejbApp);
        ejbApp.loadAndStartContainers((ApplicationContext)dc);
        return ejbApp;
    }

    public void unload(EjbApplication ejbApplication, DeploymentContext dc) {
        Properties params = dc.getCommandParameters();
    }

    public void clean(DeploymentContext dc) {
        String appName = dc.getCommandParameters().getProperty("name");
        EjbApplication ejbApp = this.ejbApps.get(appName);
        if (ejbApp != null) {
            ejbApp.undeploy();
        } else {
            dc.getLogger().log(Level.WARNING, "EjbApplication is null for name " + appName);
        }
    }
}

