/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ejb.deployment;

import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.deployment.util.EjbVisitor;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import javax.ejb.AccessTimeout;
import javax.ejb.LockType;
import org.glassfish.ejb.deployment.MethodLockInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EjbSingletonDescriptor
extends EjbSessionDescriptor {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(EjbSingletonDescriptor.class);
    private static final String[] _emptyDepends = new String[0];
    private boolean startupFlag;
    private String[] depends = _emptyDepends;
    private Class singletonClass;
    private boolean isCMC = true;
    private String cmcInXML;
    private MethodLockInfo defaultMethodLockInfo = new MethodLockInfo(LockType.WRITE);
    private HashMap<MethodDescriptor, MethodLockInfo> methodContainerLocks = null;

    public EjbSingletonDescriptor() {
    }

    public EjbSingletonDescriptor(EjbDescriptor ejbDesc) {
        super(ejbDesc);
    }

    public void addEjbDescriptor(EjbSingletonDescriptor ejbDesc) {
        super.addEjbDescriptor((EjbDescriptor)ejbDesc);
        this.methodContainerLocks = new HashMap<MethodDescriptor, MethodLockInfo>(ejbDesc.getMethodContainerLocks());
    }

    public boolean isSingleton() {
        return true;
    }

    public boolean isStartup() {
        return this.startupFlag;
    }

    public void setStartup() {
        this.startupFlag = true;
    }

    public String[] getDepends() {
        return this.depends;
    }

    public void setDepends(String[] dep) {
        this.depends = dep;
    }

    public Class getSingletonClass() {
        return this.singletonClass;
    }

    public void setSingletonClass(Class singletonClass) {
        this.singletonClass = singletonClass;
    }

    public boolean isContainerManagedConcurrency() {
        return this.isCMC;
    }

    public void setContainerManagedConcurrency(boolean value) {
        this.isCMC = value;
    }

    public String getCMCInXML() {
        return this.cmcInXML;
    }

    public void setCMCInXML(String value) {
        this.cmcInXML = value;
    }

    public void setDefaultLockType(LockType type) {
        this.checkLockTypeAllowed();
        System.out.println("@@@@SETTING DEFAULT LockType TO: " + type);
        this.defaultMethodLockInfo.setLockType(type);
    }

    public void setDefaultAccessTimeout(AccessTimeout value) {
        this.checkLockTypeAllowed();
        System.out.println("@@@@SETTING DEFAULT AccessTimeout TO: " + value);
        this.defaultMethodLockInfo.setTimeout(value.value());
        this.defaultMethodLockInfo.setUnit(value.unit());
    }

    public MethodLockInfo getDefaultMethodLockInfo() {
        return this.defaultMethodLockInfo;
    }

    public LockType getDefaultLockType() {
        return this.defaultMethodLockInfo.getLockType();
    }

    public void setCMCAccessTimeoutFor(MethodDescriptor methodDescriptor, AccessTimeout value) {
        MethodLockInfo info = this.getCMCLockFor(methodDescriptor);
        long time = value.value();
        TimeUnit unit = value.unit();
        boolean changed = false;
        if (info == null) {
            this.checkLockTypeAllowed();
            info = new MethodLockInfo(time, unit);
            changed = true;
        } else if (info.getTimeout() != time || !info.getUnit().equals((Object)unit)) {
            info.setTimeout(time);
            info.setUnit(unit);
            changed = true;
        }
        if (changed) {
            System.out.println("@@@@put " + methodDescriptor + " " + info);
            this.getMethodContainerLocks().put(methodDescriptor, info);
        }
    }

    public void setCMCLockTypeFor(MethodDescriptor methodDescriptor, LockType lockType) {
        MethodLockInfo info = this.getCMCLockFor(methodDescriptor);
        boolean changed = false;
        if (info == null) {
            this.checkLockTypeAllowed();
            info = new MethodLockInfo(lockType);
            changed = true;
        } else if (info.getLockType() == null || !info.getLockType().equals((Object)lockType)) {
            info.setLockType(lockType);
            changed = true;
        }
        if (changed) {
            System.out.println("@@@@put " + methodDescriptor + " " + info);
            this.getMethodContainerLocks().put(methodDescriptor, info);
        }
    }

    public MethodLockInfo getCMCLockFor(MethodDescriptor methodDescriptor) {
        return this.getMethodContainerLocks().get(methodDescriptor);
    }

    public void print(StringBuffer toStringBuffer) {
        super.print(toStringBuffer);
        toStringBuffer.append("\n ContainerManagedConcurrency ").append(this.isContainerManagedConcurrency());
        if (this.isContainerManagedConcurrency()) {
            toStringBuffer.append("\n defaultMethodLockInfo ").append(this.defaultMethodLockInfo);
        }
        toStringBuffer.append("\n methodContainerLocks ").append(this.getMethodContainerLocks());
    }

    public void visit(EjbVisitor aVisitor) {
        super.visit(aVisitor);
        for (MethodDescriptor md : this.getMethodContainerLocks().keySet()) {
            MethodLockInfo lt = this.getMethodContainerLocks().get(md);
        }
    }

    private void removeCMCLockFor(MethodDescriptor methodDescriptor) {
        this.getMethodContainerTransactions().remove(methodDescriptor);
    }

    private HashMap<MethodDescriptor, MethodLockInfo> getMethodContainerLocks() {
        if (this.methodContainerLocks == null) {
            this.methodContainerLocks = new HashMap();
        }
        return this.methodContainerLocks;
    }

    private void checkLockTypeAllowed() {
        if (!this.isCMC) {
            throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.exceptionlocktypespecifiedinbeanwithbeanlocktype", "Lock attributes may not be specified on a bean with nean managed lock type"));
        }
    }
}

