/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.codegen;

import com.sun.ejb.EJBUtils;
import com.sun.ejb.codegen.ClassGeneratorFactory;
import com.sun.ejb.codegen.Generator;
import com.sun.ejb.codegen.GeneratorException;
import com.sun.ejb.codegen.IndentingWriter;
import com.sun.ejb.codegen.InvalidBean;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.Method;

public class RemoteGenerator
extends Generator
implements ClassGeneratorFactory {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(RemoteGenerator.class);
    private Class businessInterface;
    private Method[] bizMethods;
    private String remoteInterfacePackageName;
    private String remoteInterfaceSimpleName;
    private String remoteInterfaceName;

    public String getGeneratedClass() {
        return this.remoteInterfaceName;
    }

    public String className() {
        return this.getGeneratedClass();
    }

    public RemoteGenerator(ClassLoader cl, String businessIntf) throws GeneratorException {
        try {
            this.businessInterface = cl.loadClass(businessIntf);
        }
        catch (ClassNotFoundException ex) {
            throw new InvalidBean(localStrings.getLocalString("generator.remote_interface_not_found", "Remote interface not found "));
        }
        this.remoteInterfaceName = EJBUtils.getGeneratedRemoteIntfName(this.businessInterface.getName());
        this.remoteInterfacePackageName = this.getPackageName(this.remoteInterfaceName);
        this.remoteInterfaceSimpleName = this.getBaseName(this.remoteInterfaceName);
        this.bizMethods = this.removeDups(this.businessInterface.getMethods());
    }

    public void generate(OutputStream out) throws GeneratorException, IOException {
        IndentingWriter p = new IndentingWriter(new OutputStreamWriter(out));
        p.pln("");
        if (this.remoteInterfacePackageName != null) {
            p.pln("package " + this.remoteInterfacePackageName + ";");
        }
        p.pln("");
        p.plnI("public interface " + this.remoteInterfaceSimpleName + " extends " + "java.rmi.Remote , com.sun.ejb.containers.RemoteBusinessObject {");
        p.pln("");
        for (int i = 0; i < this.bizMethods.length; ++i) {
            this.printMethod(p, this.bizMethods[i]);
        }
        p.pOln("}");
        p.close();
    }

    private void printMethod(IndentingWriter p, Method m) throws IOException {
        p.pln("");
        p.p("public " + this.printType(m.getReturnType()) + " " + m.getName() + "(");
        Class<?>[] params = m.getParameterTypes();
        for (int i = 0; i < params.length; ++i) {
            if (i != 0) {
                p.p(", ");
            }
            p.p(this.printType(params[i]) + " param" + i);
        }
        p.p(") ");
        Class<?>[] exceptions = m.getExceptionTypes();
        boolean throwsRemoteException = false;
        for (int i = 0; i < exceptions.length; ++i) {
            if (i == 0) {
                p.p("throws ");
            } else {
                p.p(", ");
            }
            String nextEx = exceptions[i].getName();
            p.p(nextEx);
            if (!nextEx.equals("java.rmi.RemoteException")) continue;
            throwsRemoteException = true;
        }
        if (exceptions.length == 0) {
            p.p("throws java.rmi.RemoteException");
        } else if (!throwsRemoteException) {
            p.p(", java.rmi.RemoteException");
        }
        p.pln(";");
        p.pln("");
    }
}

