/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.containers;

import com.sun.ejb.EjbInvocation;
import com.sun.ejb.containers.EjbAsyncTask;
import com.sun.ejb.containers.EjbFutureTask;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.glassfish.api.invocation.ComponentInvocation;
import org.glassfish.api.invocation.InvocationManager;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class EjbAsyncInvocationManager
extends ThreadPoolExecutor {
    private AtomicLong invCounter = new AtomicLong();
    private ConcurrentHashMap<Long, EjbFutureTask> taskMap = new ConcurrentHashMap();
    @Inject
    InvocationManager invMgr;

    public EjbAsyncInvocationManager() {
        super(16, 32, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
        super.setThreadFactory(new EjbAsyncThreadFactory());
    }

    public boolean isCancelRequestedByCurrentInvocation() {
        EjbFutureTask task;
        boolean result = false;
        ComponentInvocation compInv = this.invMgr.getCurrentInvocation();
        if (compInv instanceof EjbInvocation && (task = this.taskMap.get(((EjbInvocation)compInv).getInvId())) != null) {
            result = task.isCancelled();
        }
        return result;
    }

    public FutureTask createFuture(EjbInvocation inv) {
        EjbFutureTask futureTask = new EjbFutureTask(new EjbAsyncTask());
        inv.setEjbFutureTask(futureTask);
        return futureTask;
    }

    public Future submit(EjbInvocation inv) {
        long invId = this.invCounter.incrementAndGet();
        inv.setInvId(invId);
        EjbInvocation asyncInv = inv.clone();
        inv.clearYetToSubmitStatus();
        asyncInv.clearYetToSubmitStatus();
        EjbFutureTask futureTask = asyncInv.getEjbFutureTask();
        futureTask.getEjbAsyncTask().initialize(asyncInv);
        this.taskMap.put(invId, futureTask);
        return super.submit(futureTask.getEjbAsyncTask());
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(Callable<T> callable) {
        FutureTask result = null;
        if (callable instanceof EjbAsyncTask) {
            EjbAsyncTask task = (EjbAsyncTask)callable;
            result = task.getFutureTask();
        } else {
            result = new FutureTask(callable);
        }
        return result;
    }

    private static class EjbAsyncThreadFactory
    implements ThreadFactory {
        private AtomicInteger threadId = new AtomicInteger(0);

        private EjbAsyncThreadFactory() {
        }

        public Thread newThread(Runnable r) {
            Thread th = new Thread(r, "Ejb-Async-Thread-" + this.threadId.incrementAndGet());
            th.setDaemon(true);
            System.out.println("Created thread: " + th);
            th.setContextClassLoader(null);
            return th;
        }
    }
}

