/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.containers;

import com.sun.ejb.containers.AbstractSessionContextImpl;
import com.sun.ejb.containers.BaseContainer;
import com.sun.ejb.containers.EJBTimerService;
import com.sun.ejb.containers.EJBTimerServiceWrapper;
import com.sun.ejb.containers.EjbContainerUtilImpl;
import com.sun.enterprise.transaction.api.JavaEETransactionManager;
import javax.ejb.EJBException;
import javax.ejb.SessionContext;
import javax.ejb.TimerService;

public final class SingletonContextImpl
extends AbstractSessionContextImpl
implements SessionContext {
    SingletonContextImpl(Object ejb, BaseContainer container) {
        super(ejb, container);
    }

    public TimerService getTimerService() throws IllegalStateException {
        if (this.instanceKey == null) {
            throw new IllegalStateException("Operation not allowed");
        }
        EJBTimerService timerService = EjbContainerUtilImpl.getInstance().getEJBTimerService();
        if (timerService == null) {
            throw new EJBException("EJB Timer service not available");
        }
        return new EJBTimerServiceWrapper(timerService, this);
    }

    public void setRollbackOnly() throws IllegalStateException {
        if (this.instanceKey == null) {
            throw new IllegalStateException("Singleton setRollbackOnly not allowed");
        }
        if (this.container.isBeanManagedTx()) {
            throw new IllegalStateException("Illegal operation for bean-managed transactions");
        }
        JavaEETransactionManager tm = EjbContainerUtilImpl.getInstance().getTransactionManager();
        try {
            if (tm.getStatus() == 6) {
                throw new IllegalStateException("No transaction context.");
            }
            tm.setRollbackOnly();
        }
        catch (Exception ex) {
            IllegalStateException illEx = new IllegalStateException(ex.toString());
            illEx.initCause(ex);
            throw illEx;
        }
    }

    public boolean getRollbackOnly() throws IllegalStateException {
        if (this.instanceKey == null) {
            throw new IllegalStateException("Singleton getRollbackOnly not allowed");
        }
        if (this.container.isBeanManagedTx()) {
            throw new IllegalStateException("Illegal operation for bean-managed transactions");
        }
        JavaEETransactionManager tm = EjbContainerUtilImpl.getInstance().getTransactionManager();
        try {
            int status = tm.getStatus();
            if (status == 6) {
                throw new IllegalStateException("No transaction context.");
            }
            return status == 1 || status == 4 || status == 9;
        }
        catch (Exception ex) {
            IllegalStateException illEx = new IllegalStateException(ex.toString());
            illEx.initCause(ex);
            throw illEx;
        }
    }

    public void checkTimerServiceMethodAccess() throws IllegalStateException {
        if (this.instanceKey == null) {
            throw new IllegalStateException("EJB Timer method calls cannot be called in this context");
        }
    }
}

