/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ejb.deployment.annotation.handlers;

import com.sun.ejb.containers.TimerSchedule;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.annotation.context.EjbContext;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.reflect.Method;
import java.util.Calendar;
import java.util.logging.Level;
import javax.ejb.Schedule;
import javax.ejb.Singleton;
import javax.ejb.Stateless;
import org.glassfish.apf.AnnotationInfo;
import org.glassfish.apf.AnnotationProcessorException;
import org.glassfish.apf.HandlerProcessingResult;
import org.glassfish.ejb.deployment.annotation.handlers.AbstractAttributeHandler;
import org.jvnet.hk2.annotations.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class ScheduleHandler
extends AbstractAttributeHandler {
    public Class<? extends Annotation> getAnnotationType() {
        return Schedule.class;
    }

    @Override
    protected HandlerProcessingResult processAnnotation(AnnotationInfo ainfo, EjbContext[] ejbContexts) throws AnnotationProcessorException {
        return this.processSchedule((Schedule)ainfo.getAnnotation(), ainfo, ejbContexts);
    }

    protected HandlerProcessingResult processSchedule(Schedule sch, AnnotationInfo ainfo, EjbContext[] ejbContexts) throws AnnotationProcessorException {
        for (EjbContext ejbContext : ejbContexts) {
            EjbDescriptor ejbDesc = ejbContext.getDescriptor();
            if (!ElementType.METHOD.equals((Object)ainfo.getElementType())) continue;
            Method annMethod = (Method)ainfo.getAnnotatedElement();
            if (!TimerSchedule.isValid(sch)) continue;
            ejbDesc.addSchedule(annMethod, (Object)sch);
            if (!this.logger.isLoggable(Level.FINE)) continue;
            this.logger.fine("@@@ Found Schedule on " + annMethod);
            TimerSchedule ts = new TimerSchedule(sch, annMethod.getName(), annMethod.getParameterTypes().length);
            Calendar date = ts.getNextTimeout();
            this.logger.fine("@@@ First timeout: " + (ts.isValid(date) ? date.getTime() : "NEVER"));
            this.logger.fine("@@@ Schedule : " + ts.getScheduleAsString());
            this.logger.fine("@@@ TimerConfig : " + (sch.info() != null && !sch.info().equals("") ? sch.info() : null) + " # " + sch.persistent());
        }
        return this.getDefaultProcessedResult();
    }

    public Class<? extends Annotation>[] getTypeDependencies() {
        return new Class[]{Stateless.class, Singleton.class};
    }

    @Override
    protected boolean supportTypeInheritance() {
        return true;
    }
}

