/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 * 
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */
package org.glassfish.ejb.deployment.annotation.handlers;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;

import javax.ejb.ApplicationException;

import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbApplicationExceptionInfo;

import org.glassfish.apf.HandlerProcessingResult;
import org.glassfish.apf.AnnotationInfo;
import org.glassfish.apf.AnnotatedElementHandler;
import org.glassfish.apf.AnnotationProcessorException;
import com.sun.enterprise.deployment.annotation.context.EjbBundleContext;
import com.sun.enterprise.deployment.annotation.handlers.AbstractHandler;
import org.jvnet.hk2.annotations.Service;

/**
 * Handles @javax.ejb.ApplicationException 
 */
@Service
public class ApplicationExceptionHandler extends AbstractHandler {
    
    public ApplicationExceptionHandler() {
    }
    
    /**
     * @return the annoation type this annotation handler is handling
     */
    public Class<? extends Annotation> getAnnotationType() {
        return ApplicationException.class;
    }    

     public HandlerProcessingResult processAnnotation
         (AnnotationInfo ainfo) throws AnnotationProcessorException {

        AnnotatedElement ae = ainfo.getAnnotatedElement();
        Annotation annotation = ainfo.getAnnotation();

        AnnotatedElementHandler aeHandler = 
            ainfo.getProcessingContext().getHandler();
        

        if (aeHandler instanceof EjbBundleContext) {
            EjbBundleContext ejbBundleContext = (EjbBundleContext)aeHandler;
            
            EjbBundleDescriptor ejbBundle = ejbBundleContext.getDescriptor();

            ApplicationException appExcAnn = (ApplicationException) annotation;

            EjbApplicationExceptionInfo appExcInfo = new 
                EjbApplicationExceptionInfo();
            Class annotatedClass = (Class) ae;
            appExcInfo.setExceptionClassName(annotatedClass.getName());
            appExcInfo.setRollback(appExcAnn.rollback());

            // Set on descriptor unless the same application exception was defined
            // in ejb-jar.xml
            boolean alreadyExists = false;
            for(EjbApplicationExceptionInfo existingAppEx :
                    ejbBundle.getApplicationExceptions()) {
                if( existingAppEx.getExceptionClassName().equals(annotatedClass.getName()) ) {
                    alreadyExists = true;
                    break;
                }
            }

            if( !alreadyExists ) {
                ejbBundle.addApplicationException(appExcInfo);
            }

        }

        return getDefaultProcessedResult();

     }

    protected boolean supportTypeInheritance() {
        return true;
    }
}
