/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ejb.deployment.annotation.handlers;

import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.deployment.annotation.context.EjbContext;
import com.sun.enterprise.deployment.annotation.handlers.PostProcessor;
import com.sun.enterprise.deployment.util.TypeUtil;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.logging.Level;
import javax.ejb.Asynchronous;
import javax.ejb.Local;
import javax.ejb.Remote;
import javax.ejb.Singleton;
import javax.ejb.Stateful;
import javax.ejb.Stateless;
import org.glassfish.apf.AnnotatedElementHandler;
import org.glassfish.apf.AnnotationInfo;
import org.glassfish.apf.AnnotationProcessorException;
import org.glassfish.apf.HandlerProcessingResult;
import org.glassfish.ejb.deployment.annotation.handlers.AbstractAttributeHandler;
import org.jvnet.hk2.annotations.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class AsynchronousHandler
extends AbstractAttributeHandler
implements PostProcessor {
    public Class<? extends Annotation> getAnnotationType() {
        return Asynchronous.class;
    }

    @Override
    protected HandlerProcessingResult processAnnotation(AnnotationInfo ainfo, EjbContext[] ejbContexts) throws AnnotationProcessorException {
        for (EjbContext ejbContext : ejbContexts) {
            EjbDescriptor ejbDesc = ejbContext.getDescriptor();
            if (ElementType.TYPE.equals((Object)ainfo.getElementType())) {
                ejbContext.addPostProcessInfo(ainfo, (PostProcessor)this);
                continue;
            }
            Method annMethod = (Method)ainfo.getAnnotatedElement();
            this.setAsynchronous(annMethod, ejbDesc);
        }
        return this.getDefaultProcessedResult();
    }

    public Class<? extends Annotation>[] getTypeDependencies() {
        return new Class[]{Local.class, Remote.class, Stateful.class, Stateless.class, Singleton.class};
    }

    @Override
    protected boolean supportTypeInheritance() {
        return true;
    }

    public void postProcessAnnotation(AnnotationInfo ainfo, AnnotatedElementHandler aeHandler) throws AnnotationProcessorException {
        Method[] methods;
        EjbContext ejbContext = (EjbContext)aeHandler;
        EjbDescriptor ejbDesc = ejbContext.getDescriptor();
        Class classAn = (Class)ainfo.getAnnotatedElement();
        for (Method m0 : methods = classAn.getDeclaredMethods()) {
            this.setAsynchronous(m0, ejbDesc);
        }
    }

    protected void setAsynchronous(Method m0, EjbDescriptor ejbDesc) throws AnnotationProcessorException {
        Set mds = ejbDesc.getClientBusinessMethodDescriptors();
        for (Object next : mds) {
            MethodDescriptor nextDesc = (MethodDescriptor)next;
            Method m = nextDesc.getMethod(ejbDesc);
            if (!this.sameAsynchronousMethodSignature(m, m0)) continue;
            this.checkValidReturnType(m);
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("Setting asynchronous flag on " + nextDesc);
            }
            nextDesc.setAsynchronous(true);
            break;
        }
    }

    private void checkValidReturnType(Method m) throws AnnotationProcessorException {
        if (!m.getReturnType().equals(Void.TYPE) && !m.getReturnType().equals(Future.class)) {
            throw new AnnotationProcessorException("Return type of a method " + m + "annotated as @Asynchronous is not void or Future<V>");
        }
    }

    private boolean sameAsynchronousMethodSignature(Method asyncm, Method otherm) {
        if (TypeUtil.sameMethodSignature((Method)asyncm, (Method)otherm)) {
            return true;
        }
        if (asyncm.getName().equals(otherm.getName()) && TypeUtil.sameParamTypes((Method)asyncm, (Method)otherm) && asyncm.getReturnType().equals(Future.class)) {
            Type asyncmt = asyncm.getGenericReturnType();
            Type othermt = otherm.getGenericReturnType();
            return othermt.equals(((ParameterizedType)asyncmt).getActualTypeArguments()[0]);
        }
        return false;
    }
}

