/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.codegen;

import com.sun.ejb.EJBUtils;
import com.sun.ejb.codegen.ClassGeneratorFactory;
import com.sun.ejb.codegen.Generator;
import com.sun.ejb.codegen.GeneratorException;
import com.sun.ejb.codegen.IndentingWriter;
import com.sun.ejb.codegen.InvalidBean;
import com.sun.ejb.codegen.WrapperGenerator;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.Method;
import java.rmi.Remote;
import javax.ejb.EJBObject;

public class Remote30WrapperGenerator
extends Generator
implements ClassGeneratorFactory {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(WrapperGenerator.class);
    private String remoteInterfaceName;
    private Class businessInterface;
    private String remoteClientClassName;
    private String remoteClientPackageName;
    private String remoteClientSimpleName;
    private Method[] bizMethods;
    private ClassLoader loader;

    public String getGeneratedClass() {
        return this.remoteClientClassName;
    }

    public String className() {
        return this.getGeneratedClass();
    }

    public Remote30WrapperGenerator(ClassLoader cl, String businessIntfName, String remoteIntfName) throws GeneratorException {
        this.remoteInterfaceName = remoteIntfName;
        this.loader = cl;
        try {
            this.businessInterface = cl.loadClass(businessIntfName);
        }
        catch (ClassNotFoundException ex) {
            throw new InvalidBean(localStrings.getLocalString("generator.remote_interface_not_found", "Business interface " + this.businessInterface + " not found "));
        }
        if (EJBObject.class.isAssignableFrom(this.businessInterface)) {
            throw new GeneratorException("Invalid Remote Business Interface " + this.businessInterface + ". A Remote Business interface MUST " + "not extend javax.ejb.EJBObject.");
        }
        this.remoteClientClassName = EJBUtils.getGeneratedRemoteWrapperName(this.businessInterface.getName());
        this.remoteClientPackageName = this.getPackageName(this.remoteClientClassName);
        this.remoteClientSimpleName = this.getBaseName(this.remoteClientClassName);
        this.bizMethods = this.removeDups(this.businessInterface.getMethods());
    }

    public void generate(OutputStream out) throws GeneratorException, IOException {
        IndentingWriter p = new IndentingWriter(new OutputStreamWriter(out));
        if (this.remoteClientPackageName != null) {
            p.pln("package " + this.remoteClientPackageName + ";");
        }
        p.plnI("public final class " + this.remoteClientSimpleName + " extends com.sun.ejb.containers.RemoteBusinessWrapperBase" + " implements " + this.businessInterface.getName() + " {");
        p.pln("");
        p.pln("private " + this.remoteInterfaceName + " delegate_;");
        p.pln("");
        p.plnI("public " + this.remoteClientSimpleName + "(" + this.remoteInterfaceName + " stub" + " , " + "java.lang.String busIntf" + ")" + " {");
        p.pln("super(stub, busIntf);");
        p.pln("");
        p.pln("delegate_ = stub;");
        p.pOln("}");
        p.pln("");
        for (int i = 0; i < this.bizMethods.length; ++i) {
            this.printMethodImpl(p, this.bizMethods[i]);
        }
        p.pOln("}");
        p.close();
    }

    private void printMethodImpl(IndentingWriter p, Method m) throws IOException {
        int i;
        p.p("public " + this.printType(m.getReturnType()) + " " + m.getName() + "(");
        Class<?>[] params = m.getParameterTypes();
        for (int i2 = 0; i2 < params.length; ++i2) {
            if (i2 != 0) {
                p.p(", ");
            }
            p.p(this.printType(params[i2]) + " param" + i2);
        }
        p.p(") ");
        Class<?>[] exceptions = m.getExceptionTypes();
        for (i = 0; i < exceptions.length; ++i) {
            if (i == 0) {
                p.p("throws ");
            } else {
                p.p(", ");
            }
            p.p(exceptions[i].getName());
        }
        p.plnI("{");
        if (!Remote.class.isAssignableFrom(this.businessInterface)) {
            p.pln("try {");
        }
        if (m.getReturnType() != Void.TYPE) {
            p.p("    return ");
        }
        p.p("    delegate_." + m.getName() + "(");
        for (i = 0; i < params.length; ++i) {
            if (i != 0) {
                p.p(" , ");
            }
            p.p("param" + i);
        }
        p.pln(");");
        if (!Remote.class.isAssignableFrom(this.businessInterface)) {
            p.pln("} catch(javax.transaction.TransactionRolledbackException trex) {");
            p.pln("\tjava.lang.RuntimeException r =  new javax.ejb.EJBTransactionRolledbackException();");
            p.pln("\tr.initCause(trex);");
            p.pln("\tthrow r;");
            p.pln("} catch(java.rmi.NoSuchObjectException nsoe) {");
            p.pln("\tjava.lang.RuntimeException r =  new javax.ejb.NoSuchEJBException();");
            p.pln("\tr.initCause(nsoe);");
            p.pln("\tthrow r;");
            p.pln("} catch(javax.transaction.TransactionRequiredException txre) {");
            p.pln("\tjava.lang.RuntimeException r =  new javax.ejb.EJBTransactionRequiredException();");
            p.pln("\tr.initCause(txre);");
            p.pln("\tthrow r;");
            p.pln("} catch(java.rmi.RemoteException re) {");
            p.pln("\tthrow new javax.ejb.EJBException(re);");
            p.pln("} ");
        }
        p.pln("");
        p.pOln("} ");
        p.pln("");
    }
}

