/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.containers;

import com.sun.ejb.EjbInvocation;
import com.sun.ejb.containers.EjbAsyncInvocationManager;
import com.sun.ejb.containers.EjbAsyncTask;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EjbFutureTask<V>
extends FutureTask<V> {
    private EjbAsyncTask ejbAsyncTask;
    private EjbAsyncInvocationManager asyncInvManager;
    private boolean cancelCalled = false;
    private volatile boolean complete = false;
    private volatile V resultValue;
    private volatile Throwable resultException;

    public EjbFutureTask(EjbAsyncTask<V> callable, EjbAsyncInvocationManager mgr) {
        super(callable);
        this.ejbAsyncTask = callable;
        this.asyncInvManager = mgr;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        if (!this.cancelCalled) {
            this.cancelCalled = true;
            if (mayInterruptIfRunning) {
                EjbInvocation inv = this.ejbAsyncTask.getEjbInvocation();
                inv.setWasCancelCalled(true);
            }
        }
        return false;
    }

    @Override
    public V get() throws InterruptedException, ExecutionException {
        if (!this.complete) {
            try {
                super.get();
            }
            catch (ExecutionException ee) {
            }
            catch (InterruptedException ie) {
                this.setResultException(ie);
            }
            catch (RuntimeException re) {
                this.setResultException(re);
            }
        }
        if (this.resultException != null) {
            if (this.resultException instanceof ExecutionException) {
                throw (ExecutionException)this.resultException;
            }
            if (this.resultException instanceof InterruptedException) {
                throw (InterruptedException)this.resultException;
            }
            throw (RuntimeException)this.resultException;
        }
        return this.resultValue;
    }

    @Override
    public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        if (!this.complete) {
            try {
                super.get(timeout, unit);
            }
            catch (ExecutionException ee) {
            }
            catch (TimeoutException t) {
                throw t;
            }
            catch (InterruptedException ie) {
                this.setResultException(ie);
            }
            catch (RuntimeException re) {
                this.setResultException(re);
            }
        }
        if (this.resultException != null) {
            if (this.resultException instanceof ExecutionException) {
                throw (ExecutionException)this.resultException;
            }
            if (this.resultException instanceof InterruptedException) {
                throw (InterruptedException)this.resultException;
            }
            throw (RuntimeException)this.resultException;
        }
        return this.resultValue;
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public boolean isDone() {
        return this.cancelCalled || this.complete;
    }

    EjbAsyncTask getEjbAsyncTask() {
        return this.ejbAsyncTask;
    }

    long getInvId() {
        return this.ejbAsyncTask.getInvId();
    }

    void setResultValue(V v) {
        this.resultValue = v;
        this.complete = true;
    }

    void setResultException(Throwable t) {
        this.resultException = t;
        this.complete = true;
    }
}

