/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ejb.deployment.annotation.handlers;

import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.deployment.annotation.context.EjbContext;
import com.sun.enterprise.deployment.annotation.handlers.PostProcessor;
import com.sun.enterprise.deployment.util.TypeUtil;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import javax.ejb.AccessTimeout;
import javax.ejb.ConcurrencyManagement;
import javax.ejb.Singleton;
import javax.ejb.Stateful;
import org.glassfish.apf.AnnotatedElementHandler;
import org.glassfish.apf.AnnotationInfo;
import org.glassfish.apf.AnnotationProcessorException;
import org.glassfish.apf.HandlerProcessingResult;
import org.glassfish.ejb.deployment.EjbSingletonDescriptor;
import org.glassfish.ejb.deployment.annotation.handlers.AbstractAttributeHandler;
import org.jvnet.hk2.annotations.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class AccessTimeoutHandler
extends AbstractAttributeHandler
implements PostProcessor {
    public Class<? extends Annotation> getAnnotationType() {
        return AccessTimeout.class;
    }

    @Override
    protected HandlerProcessingResult processAnnotation(AnnotationInfo ainfo, EjbContext[] ejbContexts) throws AnnotationProcessorException {
        AccessTimeout timeout = (AccessTimeout)ainfo.getAnnotation();
        for (EjbContext ejbContext : ejbContexts) {
            if (!(ejbContext.getDescriptor() instanceof EjbSingletonDescriptor)) continue;
            EjbSingletonDescriptor singletonDesc = (EjbSingletonDescriptor)ejbContext.getDescriptor();
            if (ElementType.TYPE.equals((Object)ainfo.getElementType())) {
                ejbContext.addPostProcessInfo(ainfo, (PostProcessor)this);
                continue;
            }
            Method annMethod = (Method)ainfo.getAnnotatedElement();
            if (this.matchesExistingAccessTimeoutMethod(annMethod, singletonDesc)) continue;
            MethodDescriptor newMethodDesc = new MethodDescriptor(annMethod);
            singletonDesc.addAccessTimeoutMethod(newMethodDesc, timeout.value(), timeout.unit());
        }
        return this.getDefaultProcessedResult();
    }

    public Class<? extends Annotation>[] getTypeDependencies() {
        return new Class[]{Singleton.class, Stateful.class, ConcurrencyManagement.class};
    }

    @Override
    protected boolean supportTypeInheritance() {
        return true;
    }

    public void postProcessAnnotation(AnnotationInfo ainfo, AnnotatedElementHandler aeHandler) throws AnnotationProcessorException {
        EjbContext ejbContext = (EjbContext)aeHandler;
        EjbSingletonDescriptor ejbDesc = (EjbSingletonDescriptor)ejbContext.getDescriptor();
        Class classAn = (Class)ainfo.getAnnotatedElement();
        AccessTimeout timeoutAnn = (AccessTimeout)ainfo.getAnnotation();
        ArrayList<Method> toProcess = new ArrayList<Method>();
        for (Method m : ejbContext.getComponentDefinitionMethods()) {
            if (!classAn.equals(m.getDeclaringClass())) continue;
            toProcess.add(m);
        }
        for (Method m : classAn.getDeclaredMethods()) {
            if (!Modifier.isPrivate(m.getModifiers())) continue;
            toProcess.add(m);
        }
        for (Method m : toProcess) {
            if (this.matchesExistingAccessTimeoutMethod(m, ejbDesc)) continue;
            MethodDescriptor newMethodDesc = new MethodDescriptor(m);
            ejbDesc.addAccessTimeoutMethod(newMethodDesc, timeoutAnn.value(), timeoutAnn.unit());
        }
    }

    private boolean matchesExistingAccessTimeoutMethod(Method methodToMatch, EjbSingletonDescriptor desc) {
        List<MethodDescriptor> timeoutMethods = desc.getAccessTimeoutMethods();
        boolean match = false;
        for (MethodDescriptor next : timeoutMethods) {
            Method m = next.getMethod((EjbDescriptor)desc);
            if (!m.getDeclaringClass().equals(methodToMatch.getDeclaringClass()) || !TypeUtil.sameMethodSignature((Method)m, (Method)methodToMatch)) continue;
            match = true;
            break;
        }
        return match;
    }
}

