/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.base.io;

import com.sun.ejb.base.io.SerializableJNDIContext;
import com.sun.ejb.containers.EjbContainerUtilImpl;
import com.sun.ejb.spi.io.IndirectlySerializable;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Context;

class EJBObjectOutputStream
extends ObjectOutputStream {
    protected static final Logger _ejbLogger = EjbContainerUtilImpl.getInstance().getLogger();
    static final int EJBID_OFFSET = 0;
    static final int INSTANCEKEYLEN_OFFSET = 8;
    static final int INSTANCEKEY_OFFSET = 12;
    private static final byte HOME_KEY = -1;

    EJBObjectOutputStream(OutputStream out, boolean replaceObject) throws IOException {
        super(out);
        if (replaceObject) {
            this.enableReplaceObject(replaceObject);
        }
    }

    protected Object replaceObject(Object obj) throws IOException {
        Object result = obj;
        if (obj instanceof IndirectlySerializable) {
            result = ((IndirectlySerializable)obj).getSerializableObjectFactory();
        } else if (obj instanceof Serializable) {
            result = obj;
        } else if (obj instanceof Context) {
            result = new SerializableJNDIContext((Context)obj);
        } else {
            if (_ejbLogger.isLoggable(Level.FINE)) {
                _ejbLogger.log(Level.FINE, "EJBObjectInputStream_handling_non_serializable_object", obj.getClass().getName());
            }
            result = obj;
        }
        return result;
    }
}

