/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ejb.startup;

import com.sun.ejb.Container;
import com.sun.ejb.ContainerFactory;
import com.sun.ejb.containers.AbstractSingletonContainer;
import com.sun.ejb.containers.EJBTimerService;
import com.sun.ejb.containers.EjbContainerUtil;
import com.sun.ejb.containers.EjbContainerUtilImpl;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.v3.common.PlainTextActionReporter;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.deployment.ApplicationContainer;
import org.glassfish.api.deployment.ApplicationContext;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.OpsParams;
import org.glassfish.api.deployment.UndeployCommandParameters;
import org.glassfish.ejb.security.application.EJBSecurityManager;
import org.glassfish.ejb.security.factory.EJBSecurityManagerFactory;
import org.glassfish.ejb.startup.SingletonLifeCycleManager;
import org.glassfish.internal.api.ServerContext;
import org.glassfish.internal.deployment.Deployment;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PerLookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(name="ejb")
@Scoped(value=PerLookup.class)
public class EjbApplication
implements ApplicationContainer<Collection<EjbDescriptor>> {
    private String appName;
    private Collection<EjbDescriptor> ejbs;
    private Collection<Container> containers = new ArrayList<Container>();
    private ClassLoader ejbAppClassLoader;
    private DeploymentContext dc;
    private Habitat habitat;
    @Inject
    private EJBSecurityManagerFactory ejbSMF;
    private ContainerFactory ejbContainerFactory;
    private SingletonLifeCycleManager singletonLCM;
    private static boolean restored = false;
    private static Object lock = new Object();
    private static final char NAME_PART_SEPARATOR = '_';
    private static final char NAME_CONCATENATOR = ' ';

    public EjbApplication(Collection<EjbDescriptor> bundleDesc, DeploymentContext dc, ClassLoader cl, Habitat habitat) {
        this.ejbs = bundleDesc;
        this.ejbAppClassLoader = cl;
        this.appName = "";
        this.dc = dc;
        this.habitat = habitat;
        this.ejbContainerFactory = (ContainerFactory)habitat.getByContract(ContainerFactory.class);
    }

    public Collection<EjbDescriptor> getDescriptor() {
        return this.ejbs;
    }

    public boolean start(ApplicationContext startupContext) {
        return true;
    }

    boolean loadAndStartContainers(ApplicationContext startupContext) {
        boolean counter = false;
        boolean usesEJBTimerService = false;
        this.singletonLCM = new SingletonLifeCycleManager();
        for (EjbDescriptor desc : this.ejbs) {
            desc.setUniqueId(this.getUniqueId(desc));
            try {
                EJBSecurityManager ejbSM = null;
                Container container = this.ejbContainerFactory.createContainer(desc, this.ejbAppClassLoader, ejbSM, this.dc);
                this.containers.add(container);
                if (container instanceof AbstractSingletonContainer) {
                    this.singletonLCM.addSingletonContainer((AbstractSingletonContainer)container);
                }
                usesEJBTimerService = usesEJBTimerService || container.isTimedObject();
            }
            catch (Throwable th) {
                throw new RuntimeException("Error during EjbApplication.start() ", th);
            }
        }
        System.out.println("==> Uses Timers? == " + usesEJBTimerService);
        if (usesEJBTimerService) {
            this.initEJBTimerService();
        }
        for (Container container : this.containers) {
            container.doAfterApplicationDeploy();
        }
        this.singletonLCM.doStartup();
        return true;
    }

    public boolean stop(ApplicationContext stopContext) {
        UndeployCommandParameters params = (UndeployCommandParameters)((DeploymentContext)stopContext).getCommandParameters(UndeployCommandParameters.class);
        boolean undeploy = params.origin == OpsParams.Origin.undeploy;
        this.singletonLCM.doShutdown();
        for (Container container : this.containers) {
            if (undeploy) {
                container.undeploy();
                continue;
            }
            container.onShutdown();
        }
        this.containers.clear();
        return true;
    }

    public boolean suspend() {
        return false;
    }

    public boolean resume() {
        return false;
    }

    public ClassLoader getClassLoader() {
        return this.ejbAppClassLoader;
    }

    private long getUniqueId(EjbDescriptor desc) {
        EjbBundleDescriptor bundle = desc.getEjbBundleDescriptor();
        Application application = bundle.getApplication();
        StringBuffer rc = new StringBuffer().append(desc.getName()).append(' ').append(application.getRegistrationName());
        if (!application.isVirtual()) {
            rc.append(' ').append(bundle.getModuleDescriptor().getArchiveUri());
        }
        return rc.toString().hashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initEJBTimerService() {
        Object object = lock;
        synchronized (object) {
            EjbContainerUtil ejbContainerUtil = EjbContainerUtilImpl.getInstance();
            EJBTimerService ejbTimerService = ejbContainerUtil.getEJBTimerService();
            if (ejbTimerService == null) {
                Logger logger = ejbContainerUtil.getLogger();
                Deployment deployment = (Deployment)this.habitat.getByContract(Deployment.class);
                boolean isRegistered = deployment.isRegistered("ejb-timer-service-app");
                if (isRegistered) {
                    logger.log(Level.FINE, "EJBTimerService is already deployed and will be loaded later.");
                    return;
                }
                logger.log(Level.INFO, "Loading EJBTimerService. Please wait.");
                ServerContext sc = (ServerContext)this.habitat.getByContract(ServerContext.class);
                File root = sc.getInstallRoot();
                File app = new File(root, "lib/install/applications/ejb-timer-service-app.war");
                if (!app.exists()) {
                    throw new RuntimeException("Failed to deploy EJBTimerService: required WAR file (ejb-timer-service-app.war) is not installed");
                }
                Properties params = new Properties();
                params.put("path", app.getAbsolutePath());
                PlainTextActionReporter report = new PlainTextActionReporter();
                CommandRunner cr = (CommandRunner)this.habitat.getComponent(CommandRunner.class);
                cr.doCommand("deploy", params, (ActionReport)report);
                if (report.getActionExitCode() != ActionReport.ExitCode.SUCCESS) {
                    throw new RuntimeException("Failed to deploy EJBTimerService: " + report.getFailureCause());
                }
            }
        }
    }
}

