/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ejb.deployment.annotation.handlers;

import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbInterceptor;
import com.sun.enterprise.deployment.InterceptorBindingDescriptor;
import com.sun.enterprise.deployment.LifecycleCallbackDescriptor;
import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.deployment.annotation.context.EjbContext;
import com.sun.enterprise.deployment.annotation.context.EjbInterceptorContext;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.reflect.Method;
import java.util.HashSet;
import javax.ejb.PostActivate;
import javax.ejb.PrePassivate;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptors;
import org.glassfish.apf.AnnotatedElementHandler;
import org.glassfish.apf.AnnotationInfo;
import org.glassfish.apf.AnnotationProcessorException;
import org.glassfish.apf.HandlerProcessingResult;
import org.glassfish.apf.ProcessingContext;
import org.glassfish.apf.impl.ComponentDefinition;
import org.glassfish.ejb.deployment.annotation.handlers.AbstractAttributeHandler;
import org.jvnet.hk2.annotations.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class InterceptorsHandler
extends AbstractAttributeHandler {
    public Class<? extends Annotation> getAnnotationType() {
        return Interceptors.class;
    }

    @Override
    protected boolean supportTypeInheritance() {
        return true;
    }

    @Override
    protected HandlerProcessingResult processAnnotation(AnnotationInfo ainfo, EjbContext[] ejbContexts) throws AnnotationProcessorException {
        Interceptors interceptors = (Interceptors)ainfo.getAnnotation();
        EjbBundleDescriptor ejbBundle = ejbContexts[0].getDescriptor().getEjbBundleDescriptor();
        for (Class clazz : interceptors.value()) {
            this.processInterceptorClass(clazz, ejbBundle, ainfo);
        }
        for (Class clazz : ejbContexts) {
            EjbDescriptor ejbDescriptor = clazz.getDescriptor();
            InterceptorBindingDescriptor binding = new InterceptorBindingDescriptor();
            binding.setEjbName(ejbDescriptor.getName());
            for (Class interceptor : interceptors.value()) {
                binding.appendInterceptorClass(interceptor.getName());
            }
            if (ElementType.METHOD.equals((Object)ainfo.getElementType())) {
                Method m = (Method)ainfo.getAnnotatedElement();
                MethodDescriptor md = new MethodDescriptor(m, "Bean");
                binding.setBusinessMethod(md);
            }
            ejbBundle.prependInterceptorBinding(binding);
        }
        return this.getDefaultProcessedResult();
    }

    private void processInterceptorClass(Class interceptorClass, EjbBundleDescriptor ejbBundle, AnnotationInfo ainfo) throws AnnotationProcessorException {
        HashSet<LifecycleCallbackDescriptor> aroundInvokeDescriptors = new HashSet<LifecycleCallbackDescriptor>();
        HashSet<LifecycleCallbackDescriptor> postActivateDescriptors = new HashSet<LifecycleCallbackDescriptor>();
        HashSet<LifecycleCallbackDescriptor> prePassivateDescriptors = new HashSet<LifecycleCallbackDescriptor>();
        ComponentDefinition cdef = new ComponentDefinition(interceptorClass);
        for (Method m : cdef.getMethods()) {
            if (m.getAnnotation(AroundInvoke.class) != null) {
                aroundInvokeDescriptors.add(this.getLifecycleCallbackDescriptor(m));
            }
            if (m.getAnnotation(PostActivate.class) != null) {
                postActivateDescriptors.add(this.getLifecycleCallbackDescriptor(m));
            }
            if (m.getAnnotation(PrePassivate.class) == null) continue;
            prePassivateDescriptors.add(this.getLifecycleCallbackDescriptor(m));
        }
        EjbInterceptor interceptor = ejbBundle.getInterceptorByClassName(interceptorClass.getName());
        if (interceptor == null) {
            interceptor = new EjbInterceptor();
            interceptor.setInterceptorClassName(interceptorClass.getName());
            ejbBundle.addInterceptor(interceptor);
        }
        if (aroundInvokeDescriptors.size() > 0) {
            interceptor.addAroundInvokeDescriptors(aroundInvokeDescriptors);
        }
        if (postActivateDescriptors.size() > 0) {
            interceptor.addCallbackDescriptors(LifecycleCallbackDescriptor.CallbackType.POST_ACTIVATE, postActivateDescriptors);
        }
        if (prePassivateDescriptors.size() > 0) {
            interceptor.addCallbackDescriptors(LifecycleCallbackDescriptor.CallbackType.PRE_PASSIVATE, prePassivateDescriptors);
        }
        EjbInterceptorContext ejbInterceptorContext = new EjbInterceptorContext(interceptor);
        ProcessingContext procContext = ainfo.getProcessingContext();
        procContext.pushHandler((AnnotatedElementHandler)ejbInterceptorContext);
        procContext.getProcessor().process(procContext, new Class[]{interceptorClass});
    }

    public Class<? extends Annotation>[] getTypeDependencies() {
        return this.getEjbAnnotationTypes();
    }

    private LifecycleCallbackDescriptor getLifecycleCallbackDescriptor(Method m) {
        LifecycleCallbackDescriptor lccDesc = new LifecycleCallbackDescriptor();
        lccDesc.setLifecycleCallbackClass(m.getDeclaringClass().getName());
        lccDesc.setLifecycleCallbackMethod(m.getName());
        return lccDesc;
    }
}

