/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.containers;

import com.sun.ejb.containers.BaseContainer;
import com.sun.ejb.containers.EJBContextImpl;
import com.sun.ejb.containers.EJBTimerService;
import com.sun.ejb.containers.TimerPrimaryKey;
import com.sun.ejb.containers.TimerSchedule;
import com.sun.ejb.containers.TimerWrapper;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.EntityContext;
import javax.ejb.ScheduleExpression;
import javax.ejb.Timer;
import javax.ejb.TimerConfig;
import javax.ejb.TimerService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EJBTimerServiceWrapper
implements TimerService {
    private EJBTimerService timerService_;
    private EJBContextImpl ejbContext_;
    private long containerId_;
    private boolean entity_;
    private Object timedObjectPrimaryKey_;

    public EJBTimerServiceWrapper(EJBTimerService timerService, EJBContextImpl ejbContext) {
        this.timerService_ = timerService;
        this.ejbContext_ = ejbContext;
        BaseContainer container = (BaseContainer)ejbContext.getContainer();
        this.containerId_ = container.getEjbDescriptor().getUniqueId();
        this.entity_ = false;
        this.timedObjectPrimaryKey_ = null;
    }

    public EJBTimerServiceWrapper(EJBTimerService timerService, EntityContext entityContext) {
        this(timerService, (EJBContextImpl)entityContext);
        this.entity_ = true;
        this.timedObjectPrimaryKey_ = null;
    }

    public Timer createTimer(long duration, Serializable info) throws IllegalArgumentException, IllegalStateException, EJBException {
        this.checkCreateTimerCallPermission();
        this.checkDuration(duration);
        return this.createTimerInternal(duration, 0L, info);
    }

    public Timer createTimer(long initialDuration, long intervalDuration, Serializable info) throws IllegalArgumentException, IllegalStateException, EJBException {
        this.checkCreateTimerCallPermission();
        this.checkInitialDuration(initialDuration);
        return this.createTimerInternal(initialDuration, intervalDuration, info);
    }

    public Timer createTimer(Date expiration, Serializable info) throws IllegalArgumentException, IllegalStateException, EJBException {
        this.checkCreateTimerCallPermission();
        this.checkExpiration(expiration);
        return this.createTimerInternal(expiration, 0L, info);
    }

    public Timer createTimer(Date initialExpiration, long intervalDuration, Serializable info) throws IllegalArgumentException, IllegalStateException, EJBException {
        this.checkCreateTimerCallPermission();
        this.checkExpiration(initialExpiration);
        return this.createTimerInternal(initialExpiration, intervalDuration, info);
    }

    public Timer createSingleActionTimer(long duration, TimerConfig timerConfig) throws IllegalArgumentException, IllegalStateException, EJBException {
        this.checkCreateTimerCallPermission();
        this.checkDuration(duration);
        return this.createTimerInternal(duration, 0L, timerConfig);
    }

    public Timer createIntervalTimer(long initialDuration, long intervalDuration, TimerConfig timerConfig) throws IllegalArgumentException, IllegalStateException, EJBException {
        this.checkCreateTimerCallPermission();
        this.checkInitialDuration(initialDuration);
        return this.createTimerInternal(initialDuration, intervalDuration, timerConfig);
    }

    public Timer createSingleActionTimer(Date initialExpiration, TimerConfig timerConfig) throws IllegalArgumentException, IllegalStateException, EJBException {
        this.checkCreateTimerCallPermission();
        this.checkExpiration(initialExpiration);
        return this.createTimerInternal(initialExpiration, 0L, timerConfig);
    }

    public Timer createIntervalTimer(Date initialExpiration, long intervalDuration, TimerConfig timerConfig) throws IllegalArgumentException, IllegalStateException, EJBException {
        this.checkCreateTimerCallPermission();
        this.checkExpiration(initialExpiration);
        return this.createTimerInternal(initialExpiration, intervalDuration, timerConfig);
    }

    public Timer createCalendarTimer(ScheduleExpression schedule, TimerConfig timerConfig) throws IllegalArgumentException, IllegalStateException, EJBException {
        this.checkCreateTimerCallPermission();
        this.checkScheduleExpression(schedule);
        return this.createTimerInternal(schedule, timerConfig);
    }

    public Timer createCalendarTimer(ScheduleExpression schedule) throws IllegalArgumentException, IllegalStateException, EJBException {
        this.checkCreateTimerCallPermission();
        this.checkScheduleExpression(schedule);
        TimerConfig tc = new TimerConfig();
        tc.setInfo(null);
        return this.createTimerInternal(schedule, tc);
    }

    public Collection<Timer> getTimers() throws IllegalStateException, EJBException {
        this.checkCallPermission();
        Collection<Object> timerIds = new HashSet();
        if (this.ejbContext_.isTimedObject()) {
            try {
                timerIds = this.timerService_.getTimerIds(this.containerId_, this.getTimedObjectPrimaryKey());
            }
            catch (Exception fe) {
                EJBException ejbEx = new EJBException();
                ejbEx.initCause((Throwable)fe);
                throw ejbEx;
            }
        }
        HashSet<Timer> timerWrappers = new HashSet<Timer>();
        for (TimerPrimaryKey next : timerIds) {
            timerWrappers.add(new TimerWrapper(next, this.timerService_));
        }
        return timerWrappers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getTimedObjectPrimaryKey() {
        if (!this.entity_) {
            return null;
        }
        EJBTimerServiceWrapper eJBTimerServiceWrapper = this;
        synchronized (eJBTimerServiceWrapper) {
            if (this.timedObjectPrimaryKey_ == null) {
                this.timedObjectPrimaryKey_ = ((EntityContext)this.ejbContext_).getPrimaryKey();
            }
        }
        return this.timedObjectPrimaryKey_;
    }

    private void checkCreateTimerCallPermission() throws IllegalStateException {
        if (!this.ejbContext_.isTimedObject()) {
            throw new IllegalStateException("EJBTimerService.createTimer can only be called from a timed object.  This EJB does not implement javax.ejb.TimedObject");
        }
        this.checkCallPermission();
    }

    private void checkCallPermission() throws IllegalStateException {
        this.ejbContext_.checkTimerServiceMethodAccess();
    }

    private Timer createTimerInternal(long initialDuration, long intervalDuration, Serializable info) throws IllegalArgumentException, IllegalStateException, EJBException {
        TimerConfig tc = new TimerConfig();
        tc.setInfo(info);
        return this.createTimerInternal(initialDuration, intervalDuration, tc);
    }

    private Timer createTimerInternal(long initialDuration, long intervalDuration, TimerConfig tc) throws IllegalArgumentException, IllegalStateException, EJBException {
        this.checkIntervalDuration(intervalDuration);
        TimerPrimaryKey timerId = null;
        try {
            timerId = this.timerService_.createTimer(this.containerId_, this.getTimedObjectPrimaryKey(), initialDuration, intervalDuration, tc);
        }
        catch (CreateException ce) {
            EJBException ejbEx = new EJBException();
            ejbEx.initCause((Throwable)ce);
            throw ejbEx;
        }
        return new TimerWrapper(timerId, this.timerService_);
    }

    private Timer createTimerInternal(Date initialExpiration, long intervalDuration, Serializable info) throws IllegalArgumentException, IllegalStateException, EJBException {
        TimerConfig tc = new TimerConfig();
        tc.setInfo(info);
        return this.createTimerInternal(initialExpiration, intervalDuration, tc);
    }

    private Timer createTimerInternal(Date initialExpiration, long intervalDuration, TimerConfig tc) throws IllegalArgumentException, IllegalStateException, EJBException {
        this.checkIntervalDuration(intervalDuration);
        TimerPrimaryKey timerId = null;
        try {
            timerId = this.timerService_.createTimer(this.containerId_, this.getTimedObjectPrimaryKey(), initialExpiration, intervalDuration, tc);
        }
        catch (CreateException ce) {
            EJBException ejbEx = new EJBException();
            ejbEx.initCause((Throwable)ce);
            throw ejbEx;
        }
        return new TimerWrapper(timerId, this.timerService_);
    }

    private Timer createTimerInternal(ScheduleExpression schedule, TimerConfig tc) throws IllegalArgumentException, IllegalStateException, EJBException {
        TimerPrimaryKey timerId = null;
        try {
            timerId = this.timerService_.createTimer(this.containerId_, this.getTimedObjectPrimaryKey(), new TimerSchedule(schedule), tc);
        }
        catch (CreateException ce) {
            EJBException ejbEx = new EJBException();
            ejbEx.initCause((Throwable)ce);
            throw ejbEx;
        }
        return new TimerWrapper(timerId, this.timerService_);
    }

    private void checkDuration(long duration) throws IllegalArgumentException {
        if (duration < 0L) {
            throw new IllegalArgumentException("invalid duration=" + duration);
        }
    }

    private void checkInitialDuration(long initialDuration) throws IllegalArgumentException {
        if (initialDuration < 0L) {
            throw new IllegalArgumentException("invalid initial duration = " + initialDuration);
        }
    }

    private void checkIntervalDuration(long intervalDuration) throws IllegalArgumentException {
        if (intervalDuration < 0L) {
            throw new IllegalArgumentException("invalid interval duration = " + intervalDuration);
        }
    }

    private void checkScheduleExpression(ScheduleExpression expression) throws IllegalArgumentException {
        if (expression == null) {
            throw new IllegalArgumentException("null ScheduleExpression");
        }
    }

    private void checkExpiration(Date expiration) throws IllegalArgumentException {
        if (expiration == null) {
            throw new IllegalArgumentException("null expiration");
        }
        if (expiration.getTime() < 0L) {
            throw new IllegalArgumentException("Negative expiration");
        }
    }
}

