/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.codegen;

import com.sun.ejb.codegen.GeneratorException;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.util.TypeUtil;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.logging.LogDomains;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.rmi.Remote;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.deployment.DeployCommandParameters;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.loader.util.ASClassLoaderUtil;
import org.jvnet.hk2.component.Habitat;

public class StaticRmiStubGenerator {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(StaticRmiStubGenerator.class);
    private static final Logger _logger = LogDomains.getLogger(StaticRmiStubGenerator.class, (String)"javax.enterprise.system.container.ejb");
    private static final String ORG_OMG_STUB_PREFIX = "org.omg.stub.";

    public void ejbc(Habitat h, DeploymentContext deploymentCtx) throws Exception {
        Iterator itr;
        File stubsDir = deploymentCtx.getScratchDir("ejb");
        EjbBundleDescriptor ejbBundle = (EjbBundleDescriptor)deploymentCtx.getModuleMetaData(EjbBundleDescriptor.class);
        long startTime = this.now();
        String classPath = ASClassLoaderUtil.getModuleClassPath((Habitat)h, (DeploymentContext)deploymentCtx);
        ClassLoader jcl = ejbBundle.getClassLoader();
        String gnrtrTMP = stubsDir.getCanonicalPath();
        DeployCommandParameters dcp = (DeployCommandParameters)deploymentCtx.getCommandParameters(DeployCommandParameters.class);
        boolean generateRmicStubs = dcp.generatermistubs;
        Vector remote30Files = new Vector();
        HashSet allStubClasses = new HashSet();
        if (generateRmicStubs) {
            Set ejbStubClasses = this.getStubClasses(jcl, ejbBundle);
            allStubClasses.addAll(ejbStubClasses);
            long l = this.now();
        }
        Vector<String> allClientFiles = new Vector<String>();
        this.addGeneratedFiles(allStubClasses, allClientFiles, stubsDir);
        if (remote30Files.size() > 0 && (itr = remote30Files.iterator()) != null) {
            while (itr.hasNext()) {
                String file = (String)itr.next();
                allClientFiles.add(file.replace(".java", ".class"));
            }
        }
    }

    private String getFileName(String className, String repository) {
        return repository + File.separator + className.replace('.', File.separatorChar) + ".java";
    }

    private OutputStream createOutputStream(String fileName) throws IOException {
        File file = new File(fileName);
        File parent = null;
        parent = file.getParentFile();
        if (parent != null && !parent.exists()) {
            parent.mkdirs();
        }
        FileOutputStream out = new FileOutputStream(fileName);
        BufferedOutputStream bout = new BufferedOutputStream(out);
        return bout;
    }

    private void rmic(String classPath, List rmicOptions, Set stubClasses, File destDir, String repository) throws GeneratorException, IOException {
        if (stubClasses.size() == 0) {
            _logger.log(Level.FINE, "[EJBC] No code generation required");
            return;
        }
        ArrayList<String> options = new ArrayList<String>();
        ArrayList<String> fileList = new ArrayList<String>();
        options.addAll(rmicOptions);
        options.add("-classpath");
        String bigClasspath = System.getProperty("java.class.path") + File.pathSeparator + classPath + File.pathSeparator + repository;
        options.add(bigClasspath);
        options.add("-d");
        options.add(destDir.toString());
        for (String next : stubClasses) {
            _logger.log(Level.FINE, "[EJBC] rmic " + next + "...");
            fileList.add(next);
        }
        if (_logger.isLoggable(Level.FINE)) {
            StringBuffer sbuf = new StringBuffer();
            Iterator it = options.iterator();
            while (it.hasNext()) {
                sbuf.append("\n\t").append(it.next());
            }
            it = fileList.iterator();
            while (it.hasNext()) {
                sbuf.append("\n\t").append(it.next());
            }
            _logger.log(Level.FINE, "[EJBC] RMIC COMMAND: " + sbuf.toString());
        }
    }

    private void addGeneratedFiles(Set stubClasses, Vector allClientFiles, File stubsDir) {
        for (String next : stubClasses) {
            String stubFile = stubsDir.toString() + File.separator + this.getStubName(next).replace('.', File.separatorChar) + ".class";
            allClientFiles.add(stubFile);
        }
        _logger.log(Level.FINE, "[EJBC] Generated client files: " + allClientFiles);
    }

    private String getStubName(String fullName) {
        String className = fullName;
        String packageName = "";
        int lastDot = fullName.lastIndexOf(46);
        if (lastDot != -1) {
            className = fullName.substring(lastDot + 1, fullName.length());
            packageName = fullName.substring(0, lastDot + 1);
        }
        String stubName = packageName + "_" + className + "_Stub";
        if (this.isSpecialPackage(fullName)) {
            stubName = ORG_OMG_STUB_PREFIX + stubName;
        }
        return stubName;
    }

    private boolean isSpecialPackage(String name) {
        if (name == null) {
            return false;
        }
        return name.startsWith("javax.");
    }

    private Set getRemoteSuperInterfaces(ClassLoader jcl, String homeRemoteIntf) throws ClassNotFoundException {
        Set allSuperInterfaces = TypeUtil.getSuperInterfaces((ClassLoader)jcl, (String)homeRemoteIntf, (String)"java.rmi.Remote");
        HashSet<String> remoteSuperInterfaces = new HashSet<String>();
        for (String intfName : allSuperInterfaces) {
            Class<?> intfClass = jcl.loadClass(intfName);
            if (!Remote.class.isAssignableFrom(intfClass) || intfName.equals("javax.ejb.EJBHome") || intfName.equals("javax.ejb.EJBObject")) continue;
            remoteSuperInterfaces.add(intfName);
        }
        return remoteSuperInterfaces;
    }

    private Set getStubClasses(ClassLoader jcl, EjbBundleDescriptor ejbBundle) throws IOException, ClassNotFoundException {
        HashSet<String> stubClasses = new HashSet<String>();
        for (EjbDescriptor desc : ejbBundle.getEjbs()) {
            if (!desc.isRemoteInterfacesSupported()) continue;
            String home = desc.getHomeClassName();
            String remote = desc.getRemoteClassName();
            stubClasses.add(home);
            Set homeSuperIntfs = this.getRemoteSuperInterfaces(jcl, home);
            stubClasses.addAll(homeSuperIntfs);
            stubClasses.add(remote);
            Set remoteSuperIntfs = this.getRemoteSuperInterfaces(jcl, remote);
            stubClasses.addAll(remoteSuperIntfs);
        }
        return stubClasses;
    }

    private String getClassPath(String[] paths, File other) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < paths.length; ++i) {
            sb.append(paths[i] + File.pathSeparator);
        }
        if (other != null) {
            sb.append(other.toString());
        }
        return sb.toString();
    }

    private long now() {
        return System.currentTimeMillis();
    }

    private void progress(String message) {
        try {
            _logger.log(Level.FINE, message);
        }
        catch (Throwable t) {
            _logger.log(Level.FINER, "Cannot set status message", t);
        }
    }
}

