/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.containers;

import com.sun.ejb.containers.BaseContainer;
import com.sun.ejb.containers.EJBLocalRemoteObject;
import com.sun.ejb.containers.EjbContainerUtilImpl;
import com.sun.ejb.containers.EntityContainer;
import com.sun.ejb.spi.io.IndirectlySerializable;
import com.sun.ejb.spi.io.SerializableObjectFactory;
import com.sun.logging.LogDomains;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJBException;
import javax.ejb.EJBLocalHome;
import javax.ejb.EJBLocalObject;
import javax.ejb.RemoveException;

public abstract class EJBLocalObjectImpl
extends EJBLocalRemoteObject
implements EJBLocalObject,
IndirectlySerializable {
    private static final Logger _logger = EjbContainerUtilImpl.getInstance().getLogger();
    private static Class[] NO_PARAMS = new Class[0];
    private static Method REMOVE_METHOD = null;
    private boolean isLocalHomeView;
    private boolean isOptionalLocalBusinessView;
    private Object optionalLocalBusinessClientObject;
    private HashMap<String, Object> clientObjectMap = new HashMap();

    protected Object getClientObject() {
        return this;
    }

    void mapClientObject(String intfClassName, Object obj) {
        this.clientObjectMap.put(intfClassName, obj);
        if (this.isOptionalLocalBusinessView) {
            this.optionalLocalBusinessClientObject = obj;
        }
    }

    Object getClientObject(String intfClassName) {
        return this.clientObjectMap.get(intfClassName);
    }

    void setIsLocalHomeView(boolean flag) {
        this.isLocalHomeView = flag;
    }

    boolean isLocalHomeView() {
        return this.isLocalHomeView;
    }

    boolean isOptionalLocalBusinessView() {
        return this.isOptionalLocalBusinessView;
    }

    void setIsOptionalLocalBusinessView(boolean flag) {
        this.isOptionalLocalBusinessView = flag;
    }

    Object getOptionalLocalBusinessClientObject() {
        return this.optionalLocalBusinessClientObject;
    }

    static EJBLocalObjectImpl toEJBLocalObjectImpl(EJBLocalObject localObj) {
        EJBLocalObjectImpl localObjectImpl = localObj instanceof EJBLocalObjectImpl ? (EJBLocalObjectImpl)localObj : (EJBLocalObjectImpl)((Object)Proxy.getInvocationHandler(localObj));
        return localObjectImpl;
    }

    public EJBLocalHome getEJBLocalHome() throws EJBException {
        this.container.authorizeLocalMethod(10);
        this.container.checkExists(this);
        return this.container.getEJBLocalHome();
    }

    public void remove() throws RemoveException, EJBException {
        try {
            this.container.removeBean(this, REMOVE_METHOD, true);
        }
        catch (RemoteException re) {
            EJBException ejbEx = new EJBException("unexpected RemoteException");
            ejbEx.initCause((Throwable)re);
            throw ejbEx;
        }
    }

    public Object getPrimaryKey() throws EJBException {
        if (this.container instanceof EntityContainer) {
            this.container.authorizeLocalMethod(11);
            this.container.checkExists(this);
            return this.primaryKey;
        }
        throw new EJBException("Invalid operation for Session EJBs.");
    }

    public boolean isIdentical(EJBLocalObject other) throws EJBException {
        this.container.authorizeLocalMethod(13);
        this.container.checkExists(this);
        return this == other;
    }

    public SerializableObjectFactory getSerializableObjectFactory() {
        return new SerializableLocalObject(this.container.getEjbDescriptor().getUniqueId(), this.isLocalHomeView, this.isOptionalLocalBusinessView, this.primaryKey, this.getSfsbClientVersion());
    }

    static {
        try {
            REMOVE_METHOD = EJBLocalObject.class.getMethod("remove", NO_PARAMS);
        }
        catch (NoSuchMethodException e) {
            _logger.log(Level.FINE, "Exception retrieving remove method", e);
        }
    }

    private static final class SerializableLocalObject
    implements SerializableObjectFactory {
        private long containerId;
        private boolean localHomeView;
        private boolean optionalLocalBusView;
        private Object primaryKey;
        private long version;
        private static transient Logger _logger = LogDomains.getLogger(SerializableLocalObject.class, (String)"javax.enterprise.system.container.ejb");

        SerializableLocalObject(long containerId, boolean localHomeView, boolean optionalLocalBusinessView, Object primaryKey, long version) {
            this.containerId = containerId;
            this.localHomeView = localHomeView;
            this.optionalLocalBusView = optionalLocalBusinessView;
            this.primaryKey = primaryKey;
            this.version = version;
        }

        long getVersion() {
            return this.version;
        }

        public Object createObject() throws IOException {
            BaseContainer container = EjbContainerUtilImpl.getInstance().getContainer(this.containerId);
            if (this.localHomeView) {
                EJBLocalObjectImpl ejbLocalObjectImpl = container.getEJBLocalObjectImpl(this.primaryKey);
                ejbLocalObjectImpl.setSfsbClientVersion(this.version);
                return ejbLocalObjectImpl.getClientObject();
            }
            EJBLocalObjectImpl ejbLocalBusinessObjectImpl = this.optionalLocalBusView ? container.getOptionalEJBLocalBusinessObjectImpl(this.primaryKey) : container.getEJBLocalBusinessObjectImpl(this.primaryKey);
            ejbLocalBusinessObjectImpl.setSfsbClientVersion(this.version);
            return ejbLocalBusinessObjectImpl.getClientObject();
        }
    }
}

