/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ejb.embedded;

import java.io.File;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeploymentElement {
    private File element;
    private boolean isEJBModule;

    DeploymentElement(File element, boolean isEJBModule) {
        this.element = element;
        this.isEJBModule = isEJBModule;
    }

    File getElement() {
        return this.element;
    }

    boolean isEJBModule() {
        return this.isEJBModule;
    }

    public static boolean hasEJBModule(Set<DeploymentElement> modules) {
        for (DeploymentElement module : modules) {
            if (!module.isEJBModule()) continue;
            return true;
        }
        return false;
    }

    public static boolean hasLibrary(Set<DeploymentElement> modules) {
        for (DeploymentElement module : modules) {
            if (module.isEJBModule()) continue;
            return true;
        }
        return false;
    }

    public static int countEJBModules(Set<DeploymentElement> modules) {
        int result = 0;
        for (DeploymentElement module : modules) {
            if (!module.isEJBModule()) continue;
            ++result;
        }
        return result;
    }
}

