/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ejb.embedded;

import com.sun.enterprise.util.i18n.StringManager;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class DomainXmlTransformer {
    private File in;
    private File out;
    private final XMLEventFactory xmlEventFactory = XMLEventFactory.newInstance();
    private final XMLOutputFactory xof = XMLOutputFactory.newInstance();
    private Logger _logger = Logger.getAnonymousLogger("com.sun.logging.enterprise.system.container.ejb.LogStrings");
    private static final String VIRTUAL_SERVER = "virtual-server";
    private static final String NETWORK_LISTENERS = "network-listeners";
    private static final String IIOP_LISTENER = "iiop-listener";
    private static final String PROTOCOLS = "protocols";
    private static final String APPLICATIONS = "applications";
    private static final String JMS_HOST = "jms-host";
    private static final String JMX_CONNECTOR = "jmx-connector";
    private static final String LAZY_INIT_ATTR = "lazy-init";
    private static final String DAS_CONFIG = "das-config";
    private static final String DYNAMIC_RELOAD_ENABLED = "dynamic-reload-enabled";
    private static final String ENABLED = "enabled";
    private static final String FALSE = "false";
    private static final Set<String> SKIP_ELEMENTS = new HashSet<String>(Arrays.asList("virtual-server"));
    private static final Set<String> SKIP_ELEMENTS_KEEP_PORTS = new HashSet<String>();
    private static final Set<String> EMPTY_ELEMENTS = new HashSet<String>(Arrays.asList("network-listeners", "protocols", "applications"));
    private static final Set<String> EMPTY_ELEMENTS_KEEP_PORTS = new HashSet<String>(Arrays.asList("applications"));
    private static final Set<String> SKIP_SETTINGS_ELEMENTS = new HashSet<String>(Arrays.asList("iiop-listener", "jms-host", "das-config"));
    private static final Set<String> DISABLE_ELEMENTS = new HashSet<String>(Arrays.asList("jmx-connector"));
    private static final Set<String> DISABLE_SUB_ELEMENTS = new HashSet<String>(Arrays.asList("lazy-init", "dynamic-reload-enabled"));
    private static final StringManager localStrings = StringManager.getManager(DomainXmlTransformer.class);

    public DomainXmlTransformer(File domainXml) {
        this.in = domainXml;
    }

    public DomainXmlTransformer(File domainXml, Logger logger) {
        this.in = domainXml;
        this._logger = logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public File transform(boolean keepPorts) {
        block50: {
            FileInputStream fis = null;
            FileOutputStream fos = null;
            XMLEventReader parser = null;
            XMLEventWriter writer = null;
            XMLInputFactory xif = XMLInputFactory.class.getClassLoader() == null ? XMLInputFactory.newInstance() : XMLInputFactory.newInstance(XMLInputFactory.class.getName(), XMLInputFactory.class.getClassLoader());
            Set<String> empty_elements = keepPorts ? EMPTY_ELEMENTS_KEEP_PORTS : EMPTY_ELEMENTS;
            Set<String> skip_elements = keepPorts ? SKIP_ELEMENTS_KEEP_PORTS : SKIP_ELEMENTS;
            fis = new FileInputStream(this.in);
            this.out = File.createTempFile("domain", "xml");
            if (this._logger.isLoggable(Level.FINE)) {
                this._logger.fine("[DomainXmlTransformer] Creating temp domain file: " + this.out);
            }
            if (System.getProperty("org.glassfish.ejb.embedded.keep-temporary-files") == null) {
                this.out.deleteOnExit();
            }
            fos = new FileOutputStream(this.out);
            parser = xif.createXMLEventReader(fis);
            writer = this.xof.createXMLEventWriter(fos);
            while (parser.hasNext()) {
                XMLEvent event = parser.nextEvent();
                if (event.isStartElement()) {
                    String name = event.asStartElement().getName().getLocalPart();
                    if (skip_elements.contains(name)) {
                        if (this._logger.isLoggable(Level.FINE)) {
                            this._logger.fine("[DomainXmlTransformer] Skipping all of: " + name);
                        }
                        this.getEndEventFor(parser, name);
                        continue;
                    }
                    boolean skip_to_end = false;
                    if (empty_elements.contains(name)) {
                        if (this._logger.isLoggable(Level.FINE)) {
                            this._logger.fine("[DomainXmlTransformer] Skipping details of: " + name);
                        }
                        skip_to_end = true;
                    } else if (SKIP_SETTINGS_ELEMENTS.contains(name)) {
                        event = this.getSkippedElementStartEvent(event);
                        skip_to_end = true;
                    } else if (DISABLE_ELEMENTS.contains(name)) {
                        event = this.getDisabledStartEvent(event);
                        skip_to_end = true;
                    }
                    if (skip_to_end) {
                        writer.add(event);
                        event = this.getEndEventFor(parser, name);
                    }
                }
                if (this._logger.isLoggable(Level.FINEST)) {
                    this._logger.finest("[DomainXmlTransformer] Processing: " + event);
                }
                writer.add(event);
            }
            writer.flush();
            writer.close();
            Object var13_14 = null;
            try {
                if (parser != null) {
                    parser.close();
                }
            }
            catch (Exception e2) {
                // empty catch block
            }
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (Exception e2) {
                // empty catch block
            }
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (Exception e2) {
                // empty catch block
            }
            try {
                if (fos != null) {
                    fos.close();
                }
                break block50;
            }
            catch (Exception e2) {}
            break block50;
            {
                catch (Exception e) {
                    this._logger.log(Level.SEVERE, "ejb.embedded.tmp_file_create_error", e.getMessage());
                    this._logger.log(Level.FINE, e.getMessage(), e);
                    File file = null;
                    Object var13_15 = null;
                    try {
                        if (parser != null) {
                            parser.close();
                        }
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                    try {
                        if (fis != null) {
                            fis.close();
                        }
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                    try {
                        if (writer != null) {
                            writer.close();
                        }
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                    try {
                        if (fos != null) {
                            fos.close();
                        }
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                    return file;
                }
            }
            catch (Throwable throwable) {
                Object var13_16 = null;
                try {
                    if (parser != null) {
                        parser.close();
                    }
                }
                catch (Exception e2) {
                    // empty catch block
                }
                try {
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (Exception e2) {
                    // empty catch block
                }
                try {
                    if (writer != null) {
                        writer.close();
                    }
                }
                catch (Exception e2) {
                    // empty catch block
                }
                try {
                    if (fos != null) {
                        fos.close();
                    }
                }
                catch (Exception e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        if (this._logger.isLoggable(Level.FINE)) {
            this._logger.fine("[DomainXmlTransformer] Created temp domain file: " + this.out);
        }
        return this.out;
    }

    private XMLEvent getEndEventFor(XMLEventReader parser, String name) throws XMLStreamException, EOFException {
        while (parser.hasNext()) {
            XMLEvent event = parser.nextEvent();
            if (!event.isEndElement() || !event.asEndElement().getName().getLocalPart().equals(name)) continue;
            if (this._logger.isLoggable(Level.FINEST)) {
                this._logger.finest("[DomainXmlTransformer] END: " + name);
            }
            return event;
        }
        throw new EOFException(localStrings.getString("ejb.embedded.no_matching_end_element", (Object)name));
    }

    private StartElement getEmptyStartEvent(XMLEvent event) {
        StartElement oldStartEvent = event.asStartElement();
        return this.xmlEventFactory.createStartElement(oldStartEvent.getName(), null, oldStartEvent.getNamespaces());
    }

    private StartElement getSkippedElementStartEvent(XMLEvent event) {
        HashSet<Attribute> attributes = new HashSet<Attribute>();
        Iterator<Attribute> i = event.asStartElement().getAttributes();
        while (i.hasNext()) {
            Attribute a = i.next();
            if (DISABLE_SUB_ELEMENTS.contains(a.getName().getLocalPart())) continue;
            attributes.add(a);
        }
        StartElement oldStartEvent = event.asStartElement();
        return this.xmlEventFactory.createStartElement(oldStartEvent.getName(), attributes.iterator(), oldStartEvent.getNamespaces());
    }

    private StartElement getDisabledStartEvent(XMLEvent event) {
        HashSet<Attribute> attributes = new HashSet<Attribute>();
        Iterator<Attribute> i = event.asStartElement().getAttributes();
        while (i.hasNext()) {
            Attribute a = i.next();
            if (a.getName().getLocalPart().equals(ENABLED)) continue;
            attributes.add(a);
        }
        Attribute newAttribute = this.xmlEventFactory.createAttribute(ENABLED, FALSE);
        attributes.add(newAttribute);
        StartElement oldStartEvent = event.asStartElement();
        return this.xmlEventFactory.createStartElement(oldStartEvent.getName(), attributes.iterator(), oldStartEvent.getNamespaces());
    }
}

