/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ejb.startup;

import com.sun.ejb.codegen.StaticRmiStubGenerator;
import com.sun.ejb.containers.EJBTimerService;
import com.sun.ejb.containers.EjbContainerUtilImpl;
import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.container.common.spi.util.ComponentEnvManager;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.JndiNameEnvironment;
import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.deployment.RootDeploymentDescriptor;
import com.sun.enterprise.deployment.ScheduledTimerDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.module.bootstrap.StartupContext;
import com.sun.enterprise.security.PolicyLoader;
import com.sun.enterprise.security.SecurityUtil;
import com.sun.enterprise.security.util.IASSecurityException;
import com.sun.logging.LogDomains;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.admin.config.ReferenceContainer;
import org.glassfish.api.container.Container;
import org.glassfish.api.deployment.ApplicationContext;
import org.glassfish.api.deployment.DeployCommandParameters;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.MetaData;
import org.glassfish.api.deployment.OpsParams;
import org.glassfish.api.deployment.UndeployCommandParameters;
import org.glassfish.api.event.EventListener;
import org.glassfish.api.event.Events;
import org.glassfish.api.invocation.RegisteredComponentInvocationHandler;
import org.glassfish.deployment.common.DeploymentException;
import org.glassfish.deployment.common.DeploymentUtils;
import org.glassfish.ejb.security.application.EJBSecurityManager;
import org.glassfish.ejb.security.application.EjbSecurityProbeProvider;
import org.glassfish.ejb.security.factory.EJBSecurityManagerFactory;
import org.glassfish.ejb.spi.CMPDeployer;
import org.glassfish.ejb.spi.CMPService;
import org.glassfish.ejb.startup.EjbApplication;
import org.glassfish.ejb.startup.EjbContainerStarter;
import org.glassfish.internal.api.ServerContext;
import org.glassfish.internal.data.ApplicationInfo;
import org.glassfish.internal.deployment.Deployment;
import org.glassfish.internal.deployment.ExtendedDeploymentContext;
import org.glassfish.javaee.core.deployment.JavaEEDeployer;
import org.glassfish.server.ServerEnvironmentImpl;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PostConstruct;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class EjbDeployer
extends JavaEEDeployer<EjbContainerStarter, EjbApplication>
implements PostConstruct,
EventListener {
    @Inject
    protected ServerContext sc;
    @Inject
    protected Domain domain;
    @Inject
    protected ServerEnvironmentImpl env;
    @Inject
    protected PolicyLoader policyLoader;
    @Inject
    protected EJBSecurityManagerFactory ejbSecManagerFactory;
    @Inject
    private ComponentEnvManager compEnvManager;
    @Inject
    private Events events;
    @Inject
    StartupContext startupContext;
    private Object lock = new Object();
    private volatile CMPDeployer cmpDeployer = null;
    private static Random random = new Random();
    static final String APP_UNIQUE_ID_PROP = "org.glassfish.ejb.container.application_unique_id";
    static final String IS_TIMEOUT_APP_PROP = "org.glassfish.ejb.container.is_timeout_application";
    private AtomicLong uniqueIdCounter;
    private static final Logger _logger = LogDomains.getLogger(EjbDeployer.class, (String)"javax.enterprise.system.container.ejb");
    private final EjbSecurityProbeProvider probeProvider = new EjbSecurityProbeProvider();

    public EjbDeployer() {
        this.uniqueIdCounter = new AtomicLong(System.currentTimeMillis());
    }

    public void postConstruct() {
        boolean isUpgrade;
        Properties arguments = this.startupContext.getArguments();
        if (arguments != null && (isUpgrade = Boolean.valueOf(arguments.getProperty("-upgrade")).booleanValue())) {
            return;
        }
        this.events.register((EventListener)this);
    }

    protected String getModuleType() {
        return "ejb";
    }

    public MetaData getMetaData() {
        return new MetaData(false, new Class[]{EjbBundleDescriptor.class}, new Class[]{Application.class});
    }

    public boolean prepare(DeploymentContext dc) {
        Application app;
        String keepStateVal;
        long uniqueAppId;
        EjbBundleDescriptor ejbBundle = (EjbBundleDescriptor)dc.getModuleMetaData(EjbBundleDescriptor.class);
        if (ejbBundle == null) {
            throw new RuntimeException("Unable to load EJB module.  DeploymentContext does not contain any EJB  Check archive to ensure correct packaging for " + dc.getSourceDir());
        }
        Properties appProps = dc.getAppProps();
        if (!appProps.containsKey(APP_UNIQUE_ID_PROP)) {
            uniqueAppId = this.getNextEjbAppUniqueId();
            appProps.setProperty(APP_UNIQUE_ID_PROP, uniqueAppId + "");
        } else {
            uniqueAppId = Long.parseLong(appProps.getProperty(APP_UNIQUE_ID_PROP));
        }
        OpsParams params = dc.getCommandParameters(OpsParams.class);
        if (params.origin.isDeploy() && (keepStateVal = (String)dc.getAppProps().get("org.glassfish.ejb.startup.keepstate")) != null) {
            ejbBundle.getApplication().setKeepStateResolved(keepStateVal);
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "EjbDeployer.prepare set keepstate to {0} for application.", ejbBundle.getApplication().getKeepStateResolved());
            }
        }
        if (!(app = ejbBundle.getApplication()).isUniqueIdSet()) {
            app.setUniqueId(uniqueAppId);
        }
        return super.prepare(dc);
    }

    public EjbApplication load(EjbContainerStarter containerStarter, DeploymentContext dc) {
        super.load((Container)containerStarter, dc);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "EjbDeployer Loading app from: " + dc.getSourceDir());
        }
        RegisteredComponentInvocationHandler handler = (RegisteredComponentInvocationHandler)this.habitat.getComponent(RegisteredComponentInvocationHandler.class, "ejbSecurityCIH");
        handler.register();
        EjbBundleDescriptor ejbBundle = (EjbBundleDescriptor)dc.getModuleMetaData(EjbBundleDescriptor.class);
        if (ejbBundle == null) {
            throw new RuntimeException("Unable to load EJB module.  DeploymentContext does not contain any EJB  Check archive to ensure correct packaging for " + dc.getSourceDir());
        }
        ejbBundle.setClassLoader(dc.getClassLoader());
        if (ejbBundle.containsCMPEntity()) {
            CMPService cmpService = (CMPService)this.habitat.getByContract(CMPService.class);
            if (cmpService == null) {
                throw new RuntimeException("CMP Module is not available");
            }
            if (!cmpService.isReady()) {
                throw new RuntimeException("CMP Module is not initialized");
            }
        }
        EjbApplication ejbApp = new EjbApplication(ejbBundle, dc, dc.getClassLoader(), this.habitat, this.ejbSecManagerFactory);
        try {
            this.compEnvManager.bindToComponentNamespace((JndiNameEnvironment)ejbBundle);
            RootDeploymentDescriptor rootDesc = ejbBundle.getModuleDescriptor().getDescriptor();
            if (rootDesc != ejbBundle && rootDesc instanceof WebBundleDescriptor) {
                WebBundleDescriptor webBundle = (WebBundleDescriptor)rootDesc;
                this.compEnvManager.bindToComponentNamespace((JndiNameEnvironment)webBundle);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Exception registering ejb bundle level resources", e);
        }
        ejbApp.loadContainers((ApplicationContext)dc);
        if (ejbApp.containsTimedObject()) {
            OpsParams params = dc.getCommandParameters(OpsParams.class);
            ApplicationInfo appInfo = this.appRegistry.get(params.name());
            appInfo.addTransientAppMetaData(IS_TIMEOUT_APP_PROP, (Object)Boolean.TRUE);
        }
        return ejbApp;
    }

    public void unload(EjbApplication ejbApplication, DeploymentContext dc) {
        EjbBundleDescriptor ejbBundle = ejbApplication.getEjbBundleDescriptor();
        try {
            this.compEnvManager.unbindFromComponentNamespace((JndiNameEnvironment)ejbBundle);
        }
        catch (Exception e) {
            _logger.log(Level.WARNING, "Error unbinding ejb bundle " + ejbBundle.getModuleName() + " dependency namespace", e);
        }
        if (ejbBundle.containsCMPEntity()) {
            this.initCMPDeployer();
            if (this.cmpDeployer != null) {
                this.cmpDeployer.unload(ejbBundle.getClassLoader());
            }
        }
    }

    public void clean(DeploymentContext dc) {
        OpsParams params = dc.getCommandParameters(OpsParams.class);
        if ((params.origin.isUndeploy() || params.origin.isDeploy()) && this.isDas()) {
            if (this.cmpDeployer != null) {
                this.cmpDeployer.clean(dc);
            }
            Properties appProps = dc.getAppProps();
            String uniqueAppId = appProps.getProperty(APP_UNIQUE_ID_PROP);
            try {
                if (this.getTimeoutStatusFromApplicationInfo(params.name()) && uniqueAppId != null) {
                    String target = params.origin.isDeploy() ? ((DeployCommandParameters)dc.getCommandParameters(DeployCommandParameters.class)).target : ((UndeployCommandParameters)dc.getCommandParameters(UndeployCommandParameters.class)).target;
                    EJBTimerService timerService = EjbContainerUtilImpl.getInstance().getEJBTimerService(target);
                    if (_logger.isLoggable(Level.FINE)) {
                        _logger.log(Level.FINE, "EjbDeployer APP ID of a Timeout App? " + uniqueAppId);
                        _logger.log(Level.FINE, "EjbDeployer TimerService: " + timerService);
                    }
                    if (timerService == null) {
                        throw new RuntimeException("EJB Timer Service is not available");
                    }
                    if (this.getKeepStateFromApplicationInfo(params.name())) {
                        _logger.log(Level.INFO, "Timers will not be destroyed since keepstate is true for application {0}", params.name());
                    } else {
                        timerService.destroyAllTimers(Long.parseLong(uniqueAppId));
                    }
                }
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, "Failed to delete timers for application with id " + uniqueAppId, e);
            }
        }
        if (params.origin.isUndeploy() || params.origin.isDeploy()) {
            String appName = params.name();
            String[] contextIds = this.ejbSecManagerFactory.getContextsForApp(appName, false);
            if (contextIds != null) {
                for (String contextId : contextIds) {
                    try {
                        this.probeProvider.policyDestructionStartedEvent(contextId);
                        SecurityUtil.removePolicy((String)contextId);
                        this.probeProvider.policyDestructionEndedEvent(contextId);
                        this.probeProvider.policyDestructionEvent(contextId);
                    }
                    catch (IASSecurityException ex) {
                        _logger.log(Level.WARNING, "Error removing the policy file for application " + appName + " " + (Object)((Object)ex));
                    }
                    ArrayList<EJBSecurityManager> managers = this.ejbSecManagerFactory.getManagers(contextId, false);
                    if (managers == null) continue;
                    for (EJBSecurityManager m : managers) {
                        m.destroy();
                    }
                }
            }
            SecurityUtil.removeRoleMapper((DeploymentContext)dc);
        }
    }

    protected void generateArtifacts(DeploymentContext dc) throws DeploymentException {
        OpsParams params = dc.getCommandParameters(OpsParams.class);
        if (!params.origin.isDeploy() || !this.isDas()) {
            return;
        }
        EjbBundleDescriptor bundle = (EjbBundleDescriptor)dc.getModuleMetaData(EjbBundleDescriptor.class);
        DeployCommandParameters dcp = (DeployCommandParameters)dc.getCommandParameters(DeployCommandParameters.class);
        boolean generateRmicStubs = dcp.generatermistubs;
        dc.addTransientAppMetaData("org.glassfish.ejb.spi.module.classpath", (Object)this.getModuleClassPath(dc));
        if (generateRmicStubs) {
            StaticRmiStubGenerator staticStubGenerator = new StaticRmiStubGenerator(this.habitat);
            try {
                staticStubGenerator.ejbc(dc);
            }
            catch (Exception e) {
                throw new DeploymentException("Static RMI-IIOP Stub Generation exception for " + dc.getSourceDir(), (Throwable)e);
            }
        }
        if (bundle == null || !bundle.containsCMPEntity()) {
            return;
        }
        this.initCMPDeployer();
        if (this.cmpDeployer == null) {
            throw new DeploymentException("No CMP Deployer is available to deploy this module");
        }
        this.cmpDeployer.deploy(dc);
    }

    public void event(EventListener.Event event) {
        if (event.is(Deployment.APPLICATION_PREPARED) && this.isDas()) {
            ExtendedDeploymentContext context = (ExtendedDeploymentContext)event.hook();
            OpsParams opsparams = context.getCommandParameters(OpsParams.class);
            DeployCommandParameters dcp = (DeployCommandParameters)context.getCommandParameters(DeployCommandParameters.class);
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "EjbDeployer in APPLICATION_PREPARED for " + context.getSourceDir());
                _logger.log(Level.FINE, "EjbDeployer in origin " + opsparams.origin);
                _logger.log(Level.FINE, "EjbDeployer in INSTANCE: " + this.env.getInstanceName() + " for TARGET: " + dcp.target);
            }
            if (!opsparams.origin.isDeploy() && !opsparams.origin.isCreateAppRef() || this.env.getInstanceName().equals(dcp.target)) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "EjbDeployer ... skipping event");
                }
                return;
            }
            ApplicationInfo appInfo = this.appRegistry.get(opsparams.name());
            Application app = (Application)appInfo.getMetaData(Application.class);
            boolean isTimedApp = false;
            String target = dcp.target;
            if (dcp.isredeploy != null && dcp.isredeploy.booleanValue() && DeploymentUtils.isDomainTarget((String)target)) {
                String ref;
                List targets = (List)context.getTransientAppMetaData("previousTargets", List.class);
                Iterator i$ = targets.iterator();
                while (i$.hasNext() && this.domain.getClusterNamed(target = (ref = (String)i$.next())) == null) {
                }
            }
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "EjbDeployer using target for event as " + target);
            }
            for (EjbBundleDescriptor ejbBundle : app.getEjbBundleDescriptors()) {
                if (!this.checkEjbBundleForTimers(ejbBundle, target)) continue;
                isTimedApp = true;
            }
            if (isTimedApp && opsparams.origin.isDeploy()) {
                appInfo.addTransientAppMetaData(IS_TIMEOUT_APP_PROP, (Object)Boolean.TRUE);
            }
        }
    }

    private boolean checkEjbBundleForTimers(EjbBundleDescriptor ejbBundle, String target) {
        boolean result = false;
        if (ejbBundle != null) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "EjbDeployer.checkEjbBundleForTimers in BUNDLE: " + ejbBundle.getName());
            }
            for (EjbDescriptor ejbDescriptor : ejbBundle.getEjbs()) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "EjbDeployer.checkEjbBundleForTimers in EJB: " + ejbDescriptor.getName());
                }
                if (!ejbDescriptor.isTimedObject()) continue;
                result = true;
                if (DeploymentUtils.isDomainTarget((String)target)) continue;
                this.createAutomaticPersistentTimersForEJB(ejbDescriptor, target);
            }
        }
        return result;
    }

    private void createAutomaticPersistentTimersForEJB(EjbDescriptor ejbDescriptor, String target) {
        block10: {
            try {
                if (EjbContainerUtilImpl.getInstance().isEJBLite()) {
                    throw new RuntimeException("Invalid application.  EJB " + ejbDescriptor.getName() + " uses the EJB Timer Service" + ". This feature is not part of the EJB 3.1 Lite API");
                }
                EJBTimerService timerService = EjbContainerUtilImpl.getInstance().getEJBTimerService(target);
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "EjbDeployer BEAN ID? " + ejbDescriptor.getUniqueId());
                    _logger.log(Level.FINE, "EjbDeployer TimerService: " + timerService);
                }
                if (timerService != null) {
                    String owner = this.getOwnerId(target);
                    HashMap<MethodDescriptor, List<ScheduledTimerDescriptor>> schedules = new HashMap<MethodDescriptor, List<ScheduledTimerDescriptor>>();
                    for (ScheduledTimerDescriptor schd : ejbDescriptor.getScheduledTimerDescriptors()) {
                        ArrayList<ScheduledTimerDescriptor> list;
                        MethodDescriptor method = schd.getTimeoutMethod();
                        if (method == null || !schd.getPersistent()) continue;
                        if (_logger.isLoggable(Level.FINE)) {
                            _logger.log(Level.FINE, "... processing " + method);
                        }
                        if ((list = (ArrayList<ScheduledTimerDescriptor>)schedules.get(method)) == null) {
                            list = new ArrayList<ScheduledTimerDescriptor>();
                            schedules.put(method, list);
                        }
                        list.add(schd);
                    }
                    if (_logger.isLoggable(Level.FINE)) {
                        _logger.log(Level.FINE, "EjbDeployer - calling timerService.createSchedules for " + ejbDescriptor.getUniqueId());
                    }
                    timerService.createSchedules(ejbDescriptor.getUniqueId(), ejbDescriptor.getApplication().getUniqueId(), schedules, owner);
                    if (_logger.isLoggable(Level.FINE)) {
                        _logger.log(Level.FINE, "EjbDeployer Done With BEAN ID: " + ejbDescriptor.getUniqueId());
                    }
                    break block10;
                }
                throw new RuntimeException("EJB Timer Service is not available");
            }
            catch (Exception e) {
                throw new DeploymentException("Failed to create automatic timers for " + ejbDescriptor.getName(), (Throwable)e);
            }
        }
    }

    private String getOwnerId(String target) {
        ReferenceContainer ref = this.domain.getReferenceContainerNamed(target);
        if (ref != null && ref.isCluster()) {
            int useInstance;
            Cluster cluster = (Cluster)ref;
            List instances = cluster.getInstances();
            Server s0 = (Server)instances.get(useInstance = random.nextInt(instances.size()));
            if (s0.isRunning()) {
                return s0.getName();
            }
            for (Server s : instances) {
                if (!s.isRunning()) continue;
                return s.getName();
            }
        }
        return target;
    }

    private long getNextEjbAppUniqueId() {
        long next = this.uniqueIdCounter.incrementAndGet();
        return next << 16;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initCMPDeployer() {
        if (this.cmpDeployer == null) {
            Object object = this.lock;
            synchronized (object) {
                this.cmpDeployer = (CMPDeployer)this.habitat.getByContract(CMPDeployer.class);
            }
        }
    }

    private boolean isDas() {
        return EjbContainerUtilImpl.getInstance().isDas();
    }

    private boolean getKeepStateFromApplicationInfo(String appName) {
        return this.getBooleanStateFromApplicationInfo("org.glassfish.ejb.startup.keepstate", appName);
    }

    private boolean getBooleanStateFromApplicationInfo(String flag, String appName) {
        ApplicationInfo appInfo = this.appRegistry.get(appName);
        if (appInfo == null) {
            return false;
        }
        Boolean rc = (Boolean)appInfo.getTransientAppMetaData(flag, Boolean.class);
        return rc == null ? false : rc;
    }

    private boolean getTimeoutStatusFromApplicationInfo(String appName) {
        return this.getBooleanStateFromApplicationInfo(IS_TIMEOUT_APP_PROP, appName);
    }
}

