/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.containers;

import com.sun.ejb.Container;
import com.sun.ejb.ContainerFactory;
import com.sun.ejb.containers.BMCSingletonContainer;
import com.sun.ejb.containers.BaseContainer;
import com.sun.ejb.containers.CMCSingletonContainer;
import com.sun.ejb.containers.CommitCEntityContainer;
import com.sun.ejb.containers.EntityContainer;
import com.sun.ejb.containers.MessageBeanContainer;
import com.sun.ejb.containers.ReadOnlyBeanContainer;
import com.sun.ejb.containers.StatelessSessionContainer;
import com.sun.ejb.containers.TimerBeanContainer;
import com.sun.ejb.containers.builder.StatefulContainerBuilder;
import com.sun.enterprise.config.serverbeans.EjbContainer;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbEntityDescriptor;
import com.sun.enterprise.deployment.EjbMessageBeanDescriptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.deployment.runtime.IASEjbExtraDescriptors;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.ejb.security.application.EJBSecurityManager;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;

@Service
public final class ContainerFactoryImpl
implements ContainerFactory {
    @Inject
    private Habitat habitat;
    @Inject
    private EjbContainer ejbContainerDesc;
    private static final Logger _logger = LogDomains.getLogger(ContainerFactoryImpl.class, (String)"javax.enterprise.system.container.ejb");

    public Container createContainer(EjbDescriptor ejbDescriptor, ClassLoader loader, EJBSecurityManager sm, DeploymentContext dynamicConfigContext) throws Exception {
        BaseContainer container = null;
        String modulename = "";
        IASEjbExtraDescriptors iased = null;
        if (ejbDescriptor instanceof EjbSessionDescriptor) {
            EjbSessionDescriptor sd = (EjbSessionDescriptor)ejbDescriptor;
            if (sd.isStateless()) {
                container = ejbDescriptor.getLocalClassName() != null && ejbDescriptor.getLocalBusinessClassNames().contains("com.sun.ejb.containers.TimerLocal") ? new TimerBeanContainer(ejbDescriptor, loader) : new StatelessSessionContainer(ejbDescriptor, loader);
            } else if (sd.isStateful()) {
                StatefulContainerBuilder sfsbBuilder = (StatefulContainerBuilder)this.habitat.getComponent(StatefulContainerBuilder.class);
                sfsbBuilder.buildContainer(dynamicConfigContext, ejbDescriptor, loader);
                container = sfsbBuilder.getContainer();
            } else {
                container = sd.hasContainerManagedConcurrency() ? new CMCSingletonContainer(ejbDescriptor, loader) : new BMCSingletonContainer(ejbDescriptor, loader);
            }
        } else if (ejbDescriptor instanceof EjbMessageBeanDescriptor) {
            container = new MessageBeanContainer(ejbDescriptor, loader);
        } else if (((EjbEntityDescriptor)ejbDescriptor).getIASEjbExtraDescriptors().isIsReadOnlyBean()) {
            EjbEntityDescriptor robDesc = (EjbEntityDescriptor)ejbDescriptor;
            container = new ReadOnlyBeanContainer(ejbDescriptor, loader);
        } else if (ejbDescriptor.getLocalHomeClassName() != null && ejbDescriptor.getLocalHomeClassName().equals("com.sun.ejb.containers.TimerLocalHome")) {
            container = new TimerBeanContainer(ejbDescriptor, loader);
        } else {
            String commitOption = null;
            iased = ((EjbEntityDescriptor)ejbDescriptor).getIASEjbExtraDescriptors();
            if (iased != null) {
                commitOption = iased.getCommitOption();
            }
            if (commitOption == null) {
                commitOption = this.ejbContainerDesc.getCommitOption();
            }
            if (commitOption.equals("A")) {
                _logger.log(Level.WARNING, "ejb.commit_option_A_not_supported", new Object[]{ejbDescriptor.getName()});
                container = new EntityContainer(ejbDescriptor, loader);
            } else if (commitOption.equals("C")) {
                _logger.log(Level.FINE, "Using commit option C for: " + ejbDescriptor.getName());
                container = new CommitCEntityContainer(ejbDescriptor, loader);
            } else {
                _logger.log(Level.FINE, "Using commit option B for: " + ejbDescriptor.getName());
                container = new EntityContainer(ejbDescriptor, loader);
            }
        }
        container.setSecurityManager(sm);
        ((BaseContainer)container).initializeHome();
        return container;
    }
}

