/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ejb.deployment;

import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.deployment.FieldDescriptor;
import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.deployment.util.BeanMethodCalculator;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;
import javax.ejb.EJBLocalObject;
import javax.ejb.EJBObject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service
@Scoped(value=PerLookup.class)
public class BeanMethodCalculatorImpl
implements BeanMethodCalculator {
    private final String[] entityBeanHomeMethodsDisallowed = new String[]{"getEJBMetaData", "getHomeHandle"};
    private final String[] entityBeanRemoteMethodsDisallowed = new String[]{"getEJBHome", "getHandle", "getPrimaryKey", "isIdentical"};
    private final String[] entityBeanLocalHomeMethodsDisallowed = new String[0];
    private final String[] entityBeanLocalInterfaceMethodsDisallowed = new String[]{"getEJBLocalHome", "getPrimaryKey", "isIdentical"};
    private final String[] sessionBeanMethodsDisallowed = new String[]{"*"};
    private final String[] sessionLocalBeanMethodsDisallowed = new String[]{"*"};
    private Map disallowedMethodsPerInterface;

    public Vector getPossibleCmpCmrFields(ClassLoader cl, String className) throws ClassNotFoundException {
        Vector<FieldDescriptor> fieldDescriptors = new Vector<FieldDescriptor>();
        Class<?> theClass = cl.loadClass(className);
        Method[] methods = theClass.getMethods();
        for (int mIndex = 0; mIndex < methods.length; ++mIndex) {
            Method next = methods[mIndex];
            String nextName = next.getName();
            int nextModifiers = next.getModifiers();
            if (!Modifier.isAbstract(nextModifiers) || !nextName.startsWith("get") || nextName.length() <= 3) continue;
            String field = nextName.substring(3, 4).toLowerCase() + nextName.substring(4);
            fieldDescriptors.add(new FieldDescriptor(field));
        }
        return fieldDescriptors;
    }

    public Vector getMethodsFor(EjbDescriptor ejbDescriptor, ClassLoader classLoader) throws ClassNotFoundException {
        Vector methods = new Vector();
        if (ejbDescriptor.isRemoteInterfacesSupported()) {
            BeanMethodCalculatorImpl.addAllInterfaceMethodsIn(methods, classLoader.loadClass(ejbDescriptor.getHomeClassName()));
            BeanMethodCalculatorImpl.addAllInterfaceMethodsIn(methods, classLoader.loadClass(ejbDescriptor.getRemoteClassName()));
        }
        if (ejbDescriptor.isRemoteBusinessInterfacesSupported()) {
            for (String intf : ejbDescriptor.getRemoteBusinessClassNames()) {
                BeanMethodCalculatorImpl.addAllInterfaceMethodsIn(methods, classLoader.loadClass(intf));
            }
        }
        if (ejbDescriptor.isLocalInterfacesSupported()) {
            BeanMethodCalculatorImpl.addAllInterfaceMethodsIn(methods, classLoader.loadClass(ejbDescriptor.getLocalHomeClassName()));
            BeanMethodCalculatorImpl.addAllInterfaceMethodsIn(methods, classLoader.loadClass(ejbDescriptor.getLocalClassName()));
        }
        if (ejbDescriptor.isLocalBusinessInterfacesSupported()) {
            for (String intf : ejbDescriptor.getLocalBusinessClassNames()) {
                BeanMethodCalculatorImpl.addAllInterfaceMethodsIn(methods, classLoader.loadClass(intf));
            }
        }
        if (ejbDescriptor.isLocalBean()) {
            BeanMethodCalculatorImpl.addAllInterfaceMethodsIn(methods, classLoader.loadClass(ejbDescriptor.getEjbClassName()));
        }
        if (ejbDescriptor.hasWebServiceEndpointInterface()) {
            BeanMethodCalculatorImpl.addAllInterfaceMethodsIn(methods, classLoader.loadClass(ejbDescriptor.getWebServiceEndpointInterfaceName()));
        }
        return methods;
    }

    private static void addAllInterfaceMethodsIn(Collection methods, Class c) {
        methods.addAll(Arrays.asList(c.getMethods()));
    }

    public Collection getTransactionalMethodsFor(EjbDescriptor ejbDescriptor, ClassLoader loader) throws ClassNotFoundException, NoSuchMethodException {
        boolean statefulSessionBean = false;
        Vector<MethodDescriptor> methods = new Vector<MethodDescriptor>();
        if (ejbDescriptor instanceof EjbSessionDescriptor) {
            Method[] busIntfMethods;
            Class<?> businessIntf;
            Collection potentials;
            Collection disallowedMethods;
            statefulSessionBean = ((EjbSessionDescriptor)ejbDescriptor).isStateful();
            if (ejbDescriptor.isRemoteInterfacesSupported()) {
                disallowedMethods = this.extractDisallowedMethodsFor(EJBObject.class, this.sessionBeanMethodsDisallowed);
                potentials = this.getTransactionMethodsFor(loader, ejbDescriptor.getRemoteClassName(), disallowedMethods);
                this.transformAndAdd(potentials, "Remote", methods);
            }
            if (ejbDescriptor.isRemoteBusinessInterfacesSupported()) {
                for (String intfName : ejbDescriptor.getRemoteBusinessClassNames()) {
                    businessIntf = loader.loadClass(intfName);
                    for (Method next : busIntfMethods = businessIntf.getMethods()) {
                        methods.add(new MethodDescriptor(next, "Remote"));
                    }
                }
            }
            if (ejbDescriptor.isLocalInterfacesSupported()) {
                disallowedMethods = this.extractDisallowedMethodsFor(EJBLocalObject.class, this.sessionLocalBeanMethodsDisallowed);
                potentials = this.getTransactionMethodsFor(loader, ejbDescriptor.getLocalClassName(), disallowedMethods);
                this.transformAndAdd(potentials, "Local", methods);
            }
            if (ejbDescriptor.isLocalBusinessInterfacesSupported()) {
                for (String intfName : ejbDescriptor.getLocalBusinessClassNames()) {
                    businessIntf = loader.loadClass(intfName);
                    for (Method next : busIntfMethods = businessIntf.getMethods()) {
                        methods.add(new MethodDescriptor(next, "Local"));
                    }
                }
            }
            if (ejbDescriptor.isLocalBean()) {
                Method[] busIntfMethods2;
                String intfName = ejbDescriptor.getEjbClassName();
                Class<?> businessIntf2 = loader.loadClass(intfName);
                for (Method next : busIntfMethods2 = businessIntf2.getMethods()) {
                    methods.add(new MethodDescriptor(next, "Local"));
                }
            }
            if (ejbDescriptor.hasWebServiceEndpointInterface()) {
                Class<?> webServiceClass = loader.loadClass(ejbDescriptor.getWebServiceEndpointInterfaceName());
                Method[] webMethods = webServiceClass.getMethods();
                for (int i = 0; i < webMethods.length; ++i) {
                    methods.add(new MethodDescriptor(webMethods[i], "ServiceEndpoint"));
                }
            }
        } else {
            String localHomeIntf;
            String homeIntf = ejbDescriptor.getHomeClassName();
            if (homeIntf != null) {
                Class<?> home = loader.loadClass(homeIntf);
                Collection potentials = this.getTransactionMethodsFor(EJBHome.class, home);
                this.transformAndAdd(potentials, "Home", methods);
                String remoteIntf = ejbDescriptor.getRemoteClassName();
                Class<?> remote = loader.loadClass(remoteIntf);
                potentials = this.getTransactionMethodsFor(EJBObject.class, remote);
                this.transformAndAdd(potentials, "Remote", methods);
            }
            if ((localHomeIntf = ejbDescriptor.getLocalHomeClassName()) != null) {
                Class<?> home = loader.loadClass(localHomeIntf);
                Collection potentials = this.getTransactionMethodsFor(EJBLocalHome.class, home);
                this.transformAndAdd(potentials, "LocalHome", methods);
                String remoteIntf = ejbDescriptor.getLocalClassName();
                Class<?> remote = loader.loadClass(remoteIntf);
                potentials = this.getTransactionMethodsFor(EJBLocalObject.class, remote);
                this.transformAndAdd(potentials, "Local", methods);
            }
        }
        if (!statefulSessionBean && ejbDescriptor.isTimedObject()) {
            methods.add(ejbDescriptor.getEjbTimeoutMethod());
        }
        return methods;
    }

    private Collection getTransactionMethodsFor(ClassLoader loader, String interfaceName, Collection disallowedMethods) throws ClassNotFoundException {
        Class<?> clazz = loader.loadClass(interfaceName);
        return this.getTransactionMethodsFor(clazz, disallowedMethods);
    }

    private Collection getTransactionMethodsFor(Class interfaceImpl, Collection disallowedMethods) {
        Vector<Method> v = new Vector<Method>(Arrays.asList(interfaceImpl.getMethods()));
        v.removeAll(disallowedMethods);
        return v;
    }

    private Collection getTransactionMethodsFor(Class interfaceType, Class interfaceImpl) {
        Collection disallowedTransactionMethods = this.getDisallowedTransactionMethodsFor(interfaceType);
        return this.getTransactionMethodsFor(interfaceImpl, disallowedTransactionMethods);
    }

    private Collection getDisallowedTransactionMethodsFor(Class interfaceType) {
        return this.extractDisallowedMethodsFor(interfaceType, this.getDisallowedMethodsNamesFor(interfaceType));
    }

    private Collection extractDisallowedMethodsFor(Class interfaceType, String[] methodNames) {
        Vector<Method> v = new Vector<Method>();
        if (methodNames.length == 0) {
            return v;
        }
        Method[] methods = interfaceType.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (methodNames[0].equals("*")) {
                v.addElement(methods[i]);
                continue;
            }
            if (Arrays.binarySearch(methodNames, methods[i].getName()) < 0) continue;
            v.addElement(methods[i]);
        }
        return v;
    }

    private void transformAndAdd(Collection methods, String methodIntf, Vector globalList) {
        for (Method m : methods) {
            MethodDescriptor md = new MethodDescriptor(m, methodIntf);
            globalList.add(md);
        }
    }

    private String[] getDisallowedMethodsNamesFor(Class interfaceType) {
        return (String[])this.getDisallowedMethodsNames().get(interfaceType);
    }

    protected Map getDisallowedMethodsNames() {
        if (this.disallowedMethodsPerInterface == null) {
            this.disallowedMethodsPerInterface = new Hashtable();
            this.disallowedMethodsPerInterface.put(EJBHome.class, this.entityBeanHomeMethodsDisallowed);
            this.disallowedMethodsPerInterface.put(EJBObject.class, this.entityBeanRemoteMethodsDisallowed);
            this.disallowedMethodsPerInterface.put(EJBLocalHome.class, this.entityBeanLocalHomeMethodsDisallowed);
            this.disallowedMethodsPerInterface.put(EJBLocalObject.class, this.entityBeanLocalInterfaceMethodsDisallowed);
        }
        return this.disallowedMethodsPerInterface;
    }
}

