/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.base.sfsb.util;

import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.AvailabilityService;
import com.sun.enterprise.config.serverbeans.EjbContainer;
import com.sun.enterprise.config.serverbeans.EjbContainerAvailability;
import com.sun.enterprise.config.serverbeans.EjbModule;
import com.sun.enterprise.config.serverbeans.J2eeApplication;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.runtime.IASEjbExtraDescriptors;
import com.sun.logging.LogDomains;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service
@Scoped(value=PerLookup.class)
public final class EJBServerConfigLookup {
    private final String DEFAULT_STORE_POOL_JNDI_NAME = "jdbc/hastore";
    private final String DEFAULT_SFSB_HA_PERSISTENCE_TYPE = "file";
    private final String DEFAULT_SFSB_NON_HA_PERSISTENCE_TYPE = "file";
    private static final String REPLICATED_TYPE = "replicated";
    AvailabilityService availabilityService;
    @Inject
    EjbContainer ejbContainer;
    @Inject
    Applications applications;
    @Inject(name="default-instance-name")
    Server server;
    private EjbDescriptor _ejbDescriptor = null;
    private boolean _haEnabled = false;
    private static boolean _isDebugMonitoringEnabled = false;
    private static final Logger _logger;

    public void initWithEjbDescriptor(EjbDescriptor ejbDescriptor) {
        this._ejbDescriptor = ejbDescriptor;
    }

    public static boolean isMonitoringEnabled() {
        return EJBServerConfigLookup.isDebugMonitoringEnabled();
    }

    public static boolean isDebugMonitoringEnabled() {
        return _isDebugMonitoringEnabled;
    }

    public boolean getAvailabilityEnabledFromConfig() {
        if (this.availabilityService == null) {
            _logger.fine("AvailabilityService was not defined - check domain.xml");
            return false;
        }
        return Boolean.valueOf(this.availabilityService.getAvailabilityEnabled());
    }

    private String getServerName() {
        return this.server != null ? this.server.getName() : null;
    }

    public String getClusterName() {
        String result = null;
        return result;
    }

    public boolean calculateEjbAvailabilityEnabledFromConfig() {
        _logger.finest("in EJBServerConfigLookup>>calculateEjbAvailabilityEnabledFromConfig");
        boolean isVirtual = this.isVirtualApplication();
        String appName = this.getApplicationName();
        boolean globalAvailability = this.getAvailabilityEnabledFromConfig();
        boolean ejbContainerAvailability = this.getEjbContainerAvailabilityEnabledFromConfig(globalAvailability);
        boolean ejbDescriptorAvailability = true;
        if (isVirtual) {
            boolean ejbModuleAvailability = this.getEjbModuleAvailability(appName, ejbContainerAvailability);
            ejbDescriptorAvailability = this.getAvailabilityEnabledFromEjbDescriptor(ejbModuleAvailability);
            this._haEnabled = globalAvailability && ejbContainerAvailability && ejbModuleAvailability && ejbDescriptorAvailability;
        } else {
            boolean j2eeApplicationAvailability = this.getJ2eeApplicationAvailability(appName, ejbContainerAvailability);
            ejbDescriptorAvailability = this.getAvailabilityEnabledFromEjbDescriptor(j2eeApplicationAvailability);
            this._haEnabled = globalAvailability && ejbContainerAvailability && j2eeApplicationAvailability && ejbDescriptorAvailability;
        }
        return this._haEnabled;
    }

    public String getPersistenceStoreType() {
        return this._haEnabled ? this.getSfsbHaPersistenceTypeFromConfig() : this.getSfsbNonHaPersistenceTypeFromConfig();
    }

    private boolean isVirtualApplication() {
        Application application = this._ejbDescriptor.getApplication();
        return application.isVirtual();
    }

    private String getApplicationName() {
        Application application = this._ejbDescriptor.getApplication();
        return application.getRegistrationName();
    }

    public boolean getEjbContainerAvailabilityEnabledFromConfig() {
        boolean globalAvailabilityEnabled = this.getAvailabilityEnabledFromConfig();
        _logger.finest("in EJBServerConfigLookup>>getEjbContainerAvailabilityEnabledFromConfig");
        EjbContainerAvailability eas = this.getEjbContainerAvailability();
        if (eas == null) {
            _logger.fine("EjbContainerAvailability was not defined - check domain.xml");
            return globalAvailabilityEnabled;
        }
        String easString = eas.getAvailabilityEnabled();
        Boolean bool = this.toBoolean(easString);
        if (bool == null) {
            return globalAvailabilityEnabled;
        }
        return bool;
    }

    public boolean getEjbContainerAvailabilityEnabledFromConfig(boolean inheritedValue) {
        _logger.finest("in EJBServerConfigLookup>>getEjbContainerAvailabilityEnabledFromConfig");
        EjbContainerAvailability eas = this.getEjbContainerAvailability();
        if (eas == null) {
            _logger.fine("EjbContainerAvailability was not defined - check domain.xml");
            return inheritedValue;
        }
        String easString = eas.getAvailabilityEnabled();
        Boolean bool = this.toBoolean(easString);
        if (bool == null) {
            return inheritedValue;
        }
        return bool;
    }

    private boolean getEjbModuleAvailability(String name, boolean inheritedValue) {
        EjbModule ejbModule;
        boolean result = false;
        EjbModule ejbModule2 = ejbModule = this.applications == null ? null : (EjbModule)this.applications.getModule(EjbModule.class, name);
        if (ejbModule != null) {
            result = Boolean.valueOf(ejbModule.getAvailabilityEnabled());
        }
        return result;
    }

    private boolean getJ2eeApplicationAvailability(String appName, boolean inheritedValue) {
        J2eeApplication j2eeApp;
        boolean result = false;
        J2eeApplication j2eeApplication = j2eeApp = this.applications == null ? null : (J2eeApplication)this.applications.getModule(J2eeApplication.class, appName);
        if (j2eeApp != null) {
            result = Boolean.valueOf(j2eeApp.getAvailabilityEnabled());
        }
        return result;
    }

    private EjbContainerAvailability getEjbContainerAvailability() {
        if (this.availabilityService == null) {
            return null;
        }
        return this.availabilityService.getEjbContainerAvailability();
    }

    public boolean getAvailabilityEnabledFromEjbDescriptor() {
        _logger.finest("in EJBServerConfigLookup>>getAvailabilityEnabledFromEjbDescriptor");
        IASEjbExtraDescriptors extraDescriptors = this._ejbDescriptor.getIASEjbExtraDescriptors();
        if (extraDescriptors == null) {
            return true;
        }
        String availabilityEnabledString = extraDescriptors.getAttributeValue("AvailabilityEnabled");
        Boolean bool = this.toBoolean(availabilityEnabledString);
        if (bool == null) {
            return true;
        }
        return bool;
    }

    public boolean getAvailabilityEnabledFromEjbDescriptor(boolean inheritedValue) {
        _logger.finest("in EJBServerConfigLookup>>getAvailabilityEnabledFromEjbDescriptor");
        IASEjbExtraDescriptors extraDescriptors = this._ejbDescriptor.getIASEjbExtraDescriptors();
        if (extraDescriptors == null) {
            return inheritedValue;
        }
        String availabilityEnabledString = extraDescriptors.getAttributeValue("AvailabilityEnabled");
        Boolean bool = this.toBoolean(availabilityEnabledString);
        if (bool == null) {
            return inheritedValue;
        }
        return bool;
    }

    public String getStorePoolJndiNameFromConfig() {
        _logger.finest("in ServerConfigLookup>>getStorePoolJndiNameFromConfig");
        String result = "jdbc/hastore";
        if (this.availabilityService == null) {
            return result;
        }
        String storePoolJndiName = this.availabilityService.getStorePoolName();
        if (storePoolJndiName != null) {
            result = storePoolJndiName;
        }
        return result;
    }

    public String getHaStorePoolJndiNameFromConfig() {
        _logger.finest("in EJBServerConfigLookup>>getHaStorePoolJndiNameFromConfig");
        String result = this.getStorePoolJndiNameFromConfig();
        EjbContainerAvailability ejbContainerAvailabilityBean = this.getEjbContainerAvailability();
        if (ejbContainerAvailabilityBean == null) {
            return result;
        }
        String result2 = ejbContainerAvailabilityBean.getSfsbStorePoolName();
        if (result2 != null) {
            result = result2;
        }
        return result;
    }

    public String getSfsbHaPersistenceTypeFromConfig() {
        _logger.finest("in EJBServerConfigLookup>>getSfsbHaPersistenceTypeFromConfig");
        String result = "file";
        EjbContainerAvailability ejbContainerAvailabilityBean = this.getEjbContainerAvailability();
        if (ejbContainerAvailabilityBean == null) {
            return result;
        }
        String result2 = ejbContainerAvailabilityBean.getSfsbHaPersistenceType();
        if (result2 != null) {
            result = result2;
        }
        return result;
    }

    public String getSfsbNonHaPersistenceTypeFromConfig() {
        _logger.finest("in EJBServerConfigLookup>>getSfsbNonHaPersistenceTypeFromConfig");
        String result = "file";
        EjbContainerAvailability ejbContainerAvailabilityBean = this.getEjbContainerAvailability();
        if (ejbContainerAvailabilityBean == null) {
            return result;
        }
        String result2 = ejbContainerAvailabilityBean.getSfsbPersistenceType();
        if (result2 != null) {
            result = result2;
        }
        return result;
    }

    public static boolean checkDebugMonitoringEnabled() {
        boolean result = false;
        try {
            Properties props = System.getProperties();
            String str = props.getProperty("MONITOR_EJB_CONTAINER");
            if (null != str && str.equalsIgnoreCase("TRUE")) {
                result = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    protected Boolean toBoolean(String value) {
        if (value == null) {
            return null;
        }
        if (value.equalsIgnoreCase("true")) {
            return Boolean.TRUE;
        }
        if (value.equalsIgnoreCase("yes")) {
            return Boolean.TRUE;
        }
        if (value.equalsIgnoreCase("on")) {
            return Boolean.TRUE;
        }
        if (value.equalsIgnoreCase("1")) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private boolean isReplicationTypeMemory() {
        return REPLICATED_TYPE.equalsIgnoreCase(this.getSfsbHaPersistenceTypeFromConfig());
    }

    public boolean needToAddSFSBVersionInterceptors() {
        boolean isClustered = false;
        boolean isEJBAvailabilityEnabled = false;
        boolean isStoreTypeMemory = false;
        try {
            isEJBAvailabilityEnabled = this.getEjbContainerAvailabilityEnabledFromConfig();
            _logger.log(Level.INFO, "EJBSCLookup:: sc.getEjbContainerAvailabilityEnabledFromConfig() ==> " + isEJBAvailabilityEnabled);
            isStoreTypeMemory = this.isReplicationTypeMemory();
        }
        catch (Exception ex) {
            _logger.log(Level.FINE, "Got exception in needToAddSFSBVersionInterceptors (" + ex + "). SFSBVersionInterceptors not added");
            _logger.log(Level.FINE, "Exception in needToAddSFSBVersionInterceptors", ex);
        }
        boolean result = isClustered && isEJBAvailabilityEnabled && isStoreTypeMemory;
        _logger.log(Level.FINE, "EJBServerConfigLookup::==> isClustered:" + isClustered + " ; isEJBAvailabilityEnabled: " + isEJBAvailabilityEnabled + " ; isStoreTypeMemory ==> " + isStoreTypeMemory + " ; result: " + result);
        return result;
    }

    static {
        _isDebugMonitoringEnabled = EJBServerConfigLookup.checkDebugMonitoringEnabled();
        _logger = LogDomains.getLogger(EJBServerConfigLookup.class, (String)"javax.enterprise.system.container.ejb");
    }
}

