/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ejb;

import com.sun.enterprise.deployment.annotation.introspection.AnnotationScanner;
import com.sun.enterprise.deployment.annotation.introspection.EjbComponentAnnotationScanner;
import com.sun.enterprise.deployment.util.AnnotationDetector;
import com.sun.enterprise.module.Module;
import com.sun.enterprise.module.ModuleDefinition;
import com.sun.enterprise.module.ModulesRegistry;
import com.sun.enterprise.module.Repository;
import com.sun.enterprise.module.common_impl.AbstractModulesRegistryImpl;
import com.sun.enterprise.module.common_impl.DirectoryBasedRepository;
import com.sun.hk2.component.InhabitantsParser;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.logging.Logger;
import javax.ejb.Stateful;
import javax.ejb.Stateless;
import org.glassfish.api.container.Sniffer;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.internal.deployment.GenericSniffer;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.Singleton;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(name="Ejb")
@Scoped(value=Singleton.class)
public class EjbSniffer
extends GenericSniffer
implements Sniffer {
    @Inject
    ModulesRegistry modulesRegistry;
    @Inject
    Habitat habitat;
    private static final Class[] ejbAnnotations = new Class[]{Stateless.class, Stateful.class, javax.ejb.Singleton.class};
    final String[] containers = new String[]{"org.glassfish.ejb.startup.EjbContainerStarter"};

    public EjbSniffer() {
        this("ejb", "META-INF/ejb-jar.xml", null);
    }

    public EjbSniffer(String containerName, String appStigma, String urlPattern) {
        super(containerName, appStigma, urlPattern);
    }

    public String[] getContainersNames() {
        return this.containers;
    }

    public Module[] setup(String containerHome, Logger logger) throws IOException {
        Module[] modules = new Module[1];
        Module m = this.modulesRegistry.makeModuleFor("org.glassfish.ejb.ejb-container", null);
        if (m == null) {
            File ejbLib = null;
            if (containerHome != null) {
                ejbLib = new File(containerHome);
            }
            if (!ejbLib.exists()) {
                throw new IOException("EJB Container not installed");
            }
            DirectoryBasedRepository ejb = new DirectoryBasedRepository("ejb", ejbLib);
            ejb.initialize();
            this.modulesRegistry.addRepository((Repository)ejb);
            InhabitantsParser parser = new InhabitantsParser(this.habitat);
            for (ModuleDefinition md : ejb.findAll()) {
                Module module = this.modulesRegistry.makeModuleFor(md.getName(), md.getVersion());
                if (module == null) continue;
                ((AbstractModulesRegistryImpl)this.modulesRegistry).parseInhabitants(module, "default", parser);
            }
            m = this.modulesRegistry.makeModuleFor("org.glassfish.ejb:ejb-container", null);
        }
        if (m != null) {
            modules[0] = m;
            return modules;
        }
        throw new IOException("Cannot find ejb module from the module's repositories");
    }

    public boolean handles(ReadableArchive location, ClassLoader loader) {
        boolean result = super.handles(location, loader);
        if (!result) {
            try {
                result = location.exists("WEB-INF/ejb-jar.xml");
                if (!result) {
                    AnnotationDetector detector = new AnnotationDetector((AnnotationScanner)new EjbComponentAnnotationScanner());
                    result = detector.hasAnnotationInArchive(location);
                }
            }
            catch (IOException ioEx) {
                // empty catch block
            }
        }
        return result;
    }

    public Class<? extends Annotation>[] getAnnotationTypes() {
        return ejbAnnotations;
    }

    public boolean isUserVisible() {
        return true;
    }
}

