/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ejb.mejb;

import com.sun.logging.LogDomains;
import java.io.File;
import java.io.IOException;
import java.util.logging.Logger;
import javax.naming.Context;
import javax.naming.NamingException;
import org.glassfish.api.ActionReport;
import org.glassfish.api.deployment.DeployCommandParameters;
import org.glassfish.api.deployment.OpsParams;
import org.glassfish.api.naming.GlassfishNamingManager;
import org.glassfish.api.naming.NamingObjectProxy;
import org.glassfish.internal.api.ServerContext;
import org.glassfish.internal.deployment.Deployment;
import org.glassfish.internal.deployment.ExtendedDeploymentContext;
import org.jvnet.hk2.component.Habitat;

public class MEJBNamingObjectProxy
implements NamingObjectProxy {
    public static final String MEJB_JNDI_NAME = "ejb/mgmt/MEJB";
    private Habitat habitat;
    private static final Logger _logger = LogDomains.getLogger(MEJBNamingObjectProxy.class, (String)"javax.enterprise.system.container.ejb");

    public MEJBNamingObjectProxy(Habitat habitat) {
        this.habitat = habitat;
    }

    public Object create(Context ic) throws NamingException {
        GlassfishNamingManager gfNamingManager = (GlassfishNamingManager)this.habitat.getComponent(GlassfishNamingManager.class);
        Object mEJBHome = null;
        try {
            gfNamingManager.unpublishObject(MEJB_JNDI_NAME);
            this.deployMEJB();
            mEJBHome = ic.lookup(MEJB_JNDI_NAME);
        }
        catch (NamingException ne) {
            throw ne;
        }
        catch (Exception e) {
            NamingException namingException = new NamingException(e.getMessage());
            namingException.initCause(e);
            throw namingException;
        }
        return mEJBHome;
    }

    private void deployMEJB() throws IOException {
        _logger.info("Loading MEJB app on JNDI look up");
        ServerContext serverContext = (ServerContext)this.habitat.getComponent(ServerContext.class);
        File mejbArchive = new File(serverContext.getInstallRoot(), "lib/install/applications/mejb.jar");
        DeployCommandParameters deployParams = new DeployCommandParameters(mejbArchive);
        deployParams.name = "mejb";
        ActionReport report = (ActionReport)this.habitat.getComponent(ActionReport.class, "plain");
        Deployment deployment = (Deployment)this.habitat.getComponent(Deployment.class);
        ExtendedDeploymentContext dc = deployment.getContext(_logger, mejbArchive, (OpsParams)deployParams, report);
        deployment.deploy(dc);
        if (report.getActionExitCode() != ActionReport.ExitCode.SUCCESS) {
            throw new RuntimeException("Failed to deploy MEJB app: " + report.getFailureCause());
        }
    }
}

